/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysPersonalHistoryDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysPersonalHistory;
import com.cxqm.xiaoerke.modules.haoyun.example.SysPersonalHistoryExample;
import com.cxqm.xiaoerke.modules.haoyun.service.SysPersonalHistoryService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPersonalHistoryServiceImpl
implements SysPersonalHistoryService {
    @Autowired
    SysPersonalHistoryDao sysPersonalHistoryDao;

    public SysPersonalHistory querySysPersonalHistoryByUserId(String userId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SysPersonalHistoryExample example = new SysPersonalHistoryExample();
        example.createCriteria().andUserIdEqualTo(userId);
        List<SysPersonalHistory> list = this.query(example);
        if (list == null || list.size() == 0) {
            return null;
        }
        SysPersonalHistory sysPersonalHistory = list.get(0);
        try {
            sysPersonalHistory.setMarriageableAgeForDate(sysPersonalHistory.getMarriageableAge() == null ? null : sdf.format(sysPersonalHistory.getMarriageableAge()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.get(0);
    }

    public void saveSysPersonalHistory(SysPersonalHistory sysPersonalHistory, String userId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (sysPersonalHistory.getId() != null && !sysPersonalHistory.getId().trim().equals("")) {
            sysPersonalHistory.setUpdateBy(new User(userId));
            sysPersonalHistory.setUpdateDate(new Date());
            sysPersonalHistory.setUserId(userId);
            try {
                Long time = sysPersonalHistory.getMarriageableAgeForDate() == null || sysPersonalHistory.getMarriageableAgeForDate().trim().equals("") ? null : Long.valueOf(sdf.parse(sysPersonalHistory.getMarriageableAgeForDate()).getTime());
                sysPersonalHistory.setMarriageableAge(time);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.sysPersonalHistoryDao.updateByPrimaryKeySelective(sysPersonalHistory);
        } else {
            sysPersonalHistory.setId(IdGen.vestaId());
            sysPersonalHistory.setUserId(userId);
            sysPersonalHistory.setCreateBy(new User(userId));
            sysPersonalHistory.setCreateDate(new Date());
            try {
                Long time = sysPersonalHistory.getMarriageableAgeForDate() == null || sysPersonalHistory.getMarriageableAgeForDate().trim().equals("") ? null : Long.valueOf(sdf.parse(sysPersonalHistory.getMarriageableAgeForDate()).getTime());
                sysPersonalHistory.setMarriageableAge(time);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            sysPersonalHistory.setDelFlag("0");
            this.sysPersonalHistoryDao.insertSelective(sysPersonalHistory);
        }
    }

    private List<SysPersonalHistory> query(SysPersonalHistoryExample example) {
        return this.sysPersonalHistoryDao.selectByExample(example);
    }
}

