/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.AccountDetailVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.BonusRatioCalculation;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyDoctorArticleVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.SetAccountSchemePriceBean;
import com.cxqm.xiaoerke.modules.haoyun.beans.SysUserAccountDetailCondition;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserAccountDetailDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyArticleBuy;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyGraphicOrder;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyScheme;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysUserAccount;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysUserAccountDetail;
import com.cxqm.xiaoerke.modules.haoyun.enums.AccountDetailEnum;
import com.cxqm.xiaoerke.modules.haoyun.example.HyDoctorArticleExample;
import com.cxqm.xiaoerke.modules.haoyun.example.SysUserAccountDetailExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDoctorArticleService;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserAccountDetailService;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserAccountService;
import com.cxqm.xiaoerke.modules.haoyun.util.AccountDelayQueueUtils;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserAccountDetailServiceImpl
implements SysUserAccountDetailService {
    @Autowired
    SysUserAccountDetailDao sysUserAccountDetailDao;
    @Autowired
    MongoDictionaryService mongoDictionaryService;
    @Autowired
    SysUserAccountService sysUserAccountService;
    @Autowired
    UserInfoService userInfoService;
    @Autowired
    HyDoctorArticleService hyDoctorArticleService;

    public void saveWithdrawCash(SysUserAccount sysUserAccount, Integer price, String hyWithdrawCashId) {
        Integer txje;
        if (sysUserAccount != null) {
            txje = sysUserAccount.getBalance() - price;
            if (txje < 0) {
                throw new RuntimeException("\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8d26\u6237\u91d1\u989d!");
            }
        } else {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u8be5\u7528\u7684\u8d26\u6237\u4fe1\u606f!");
        }
        this.sysUserAccountService.updateBalance(sysUserAccount.getId(), sysUserAccount.getSysUserId(), txje);
        SysUserAccountDetail detail = new SysUserAccountDetail();
        detail.setId(IdGen.vestaId());
        detail.setPrice(Integer.valueOf(-price.intValue()));
        detail.setSysUserAccountId(sysUserAccount.getId());
        detail.setThisTime(new Date());
        detail.setType(AccountDetailEnum.PUT_FORWARD.getCode());
        detail.setThisSource("\u63d0\u73b0\u5230\u5fae\u4fe1");
        detail.setSpare3(hyWithdrawCashId);
        detail.setCreateDate(new Date());
        detail.setCreateBy(new User(sysUserAccount.getSysUserId()));
        detail.setUpdateDate(new Date());
        detail.setDelFlag("0");
        this.sysUserAccountDetailDao.insertSelective(detail);
    }

    public List<SysUserAccountDetail> selectByExample(SysUserAccountDetailExample example) {
        return this.sysUserAccountDetailDao.selectByExample(example);
    }

    public void doctorManageRefundByOrderId(String orderId, String userId, String orderUserId) {
        SysUserAccountDetailExample example = new SysUserAccountDetailExample();
        example.createCriteria().andDelFlagEqualTo("0").andSpare3EqualTo(orderId);
        List<SysUserAccountDetail> detailList = this.sysUserAccountDetailDao.selectByExample(example);
        if (detailList == null || detailList.size() == 0) {
            return;
        }
        SysUserAccount sysUserAccount = null;
        Date date = new Date();
        User user = this.userInfoService.getUserById(orderUserId);
        for (SysUserAccountDetail detail : detailList) {
            sysUserAccount = this.sysUserAccountService.getById(detail.getSysUserAccountId());
            this.sysUserAccountService.updateBalance(sysUserAccount.getId(), userId, Integer.valueOf(sysUserAccount.getBalance() + Integer.parseInt("-" + detail.getPrice())));
            this.saveDoctorManageRefund(Integer.parseInt("-" + detail.getPrice()), sysUserAccount.getId(), userId, user.getName(), date, orderId, detail.getSpare1());
        }
    }

    private void saveDoctorManageRefund(Integer price, String accountId, String userId, String userName, Date operationTime, String orderId, String ratio) {
        SysUserAccountDetail detail = new SysUserAccountDetail();
        detail.setId(IdGen.vestaId());
        detail.setPrice(price);
        detail.setSysUserAccountId(accountId);
        detail.setThisTime(operationTime);
        detail.setType(AccountDetailEnum.INTERLOCUTION_REFUND.getCode());
        detail.setThisSource("\u7528\u6237" + userName + "\u7684\u95ee\u7b54\u9000\u6b3e");
        detail.setSpare1(ratio);
        detail.setSpare3(orderId);
        detail.setCreateDate(new Date());
        detail.setCreateBy(new User(userId));
        detail.setDelFlag("0");
        this.sysUserAccountDetailDao.insertSelective(detail);
    }

    public void doctorManageRefundSettlement(String accountId, Integer price, String orderId) {
        SysUserAccountDetail detail = new SysUserAccountDetail();
        detail.setId(IdGen.vestaId());
        detail.setPrice(price);
        detail.setSysUserAccountId(accountId);
        detail.setThisTime(new Date());
        detail.setType(AccountDetailEnum.MANAGE_REFUND.getCode());
        detail.setThisSource("\u7ba1\u7406\u7ed3\u7b97\u7684\u9000\u6b3e");
        detail.setSpare1("");
        detail.setSpare3(orderId);
        detail.setCreateDate(new Date());
        detail.setDelFlag("0");
        SysUserAccount sysUserAccount = this.sysUserAccountService.getById(accountId);
        this.sysUserAccountService.updateBalance(accountId, "", Integer.valueOf(sysUserAccount.getBalance() + price));
        this.sysUserAccountDetailDao.insertSelective(detail);
    }

    public BonusRatioCalculation packageBonusRatioCalculation(String userId, String subKey, Integer price) {
        JSONArray jsonArray;
        BonusRatioCalculation bonusRatioCalculation = new BonusRatioCalculation();
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("bonus_proportion", subKey);
        Map map = (Map)JSONObject.parse((String)mongoDictionary.getStr2());
        Map<String, Object> result = new HashMap<String, Object>();
        JSONArray fristFormula = JSONObject.parseArray((String)mongoDictionary.getStr1());
        String formula = "";
        for (String key : map.keySet()) {
            if (!userId.equals(key)) continue;
            formula = (String)map.get(key);
            break;
        }
        if (formula.equals("*")) {
            bonusRatioCalculation.setFormula("*");
            result.put(userId, price);
        }
        if (formula.equals("") && fristFormula.size() > 0) {
            result = this.setMapFormFormula(fristFormula, result, price, userId);
            bonusRatioCalculation.setFormula(mongoDictionary.getStr1());
            bonusRatioCalculation.setResult(result);
        }
        if (!formula.equals("*") && !formula.equals("") && (jsonArray = JSONObject.parseArray((String)formula)).size() > 0) {
            result = this.setMapFormFormula(jsonArray, result, price, userId);
            bonusRatioCalculation.setFormula(formula);
            bonusRatioCalculation.setResult(result);
        }
        return bonusRatioCalculation;
    }

    private Map<String, Object> setMapFormFormula(JSONArray jsonArray, Map<String, Object> result, Integer price, String userId) {
        Integer total_num = price;
        String num = "";
        if (jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String ratio = jsonObject.get((Object)"ratio").toString();
                if (i == jsonArray.size() - 1) {
                    num = String.valueOf(total_num);
                } else {
                    num = String.valueOf(Double.parseDouble(price.toString()) * Double.parseDouble(ratio));
                    num = num.substring(0, num.indexOf("."));
                    total_num = total_num - Integer.parseInt(num);
                }
                if (jsonObject.get((Object)"userId").equals("currentUserId")) {
                    result.put(userId, Integer.parseInt(num));
                    continue;
                }
                result.put((String)jsonObject.get((Object)"userId"), Integer.parseInt(num));
            }
            return result;
        }
        return null;
    }

    public void saveDoctorManageUserAccountDetail(String userId, Integer price, Integer allActualPrice, Date time, String formula, String describeUserId, String orderId) {
        User describeUser = this.userInfoService.getUserById(describeUserId);
        AccountDetailVo vo = new AccountDetailVo();
        vo.setUserId(userId);
        vo.setPrice(price);
        vo.setSpare2(allActualPrice == null ? null : allActualPrice.toString());
        vo.setThisTime(time);
        vo.setType(AccountDetailEnum.MANAGE.getCode());
        vo.setThisSource("\u7528\u6237" + describeUser.getName() + "\u7684\u7ba1\u7406\u6536\u6b3e");
        vo.setSpare1(formula);
        vo.setSpare3(orderId);
        SysUserAccount sysUserAccount = this.sysUserAccountService.saveUserAccount(vo);
        this.saveUserAccountDetail(sysUserAccount, vo);
    }

    public void saveWenDaUserAccountDetail(HyGraphicOrder hyGraphicOrder, Date time, Integer price) {
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("bonus_proportion", "ask_doctor");
        String public_peiz = mongoDictionary.getStr1();
        String geren_peiz = mongoDictionary.getStr2();
        JSONObject peizi = null;
        if (geren_peiz != null && geren_peiz.trim().length() > 0) {
            JSONObject temp = JSON.parseObject((String)geren_peiz);
            peizi = temp.getJSONObject(hyGraphicOrder.getDoctor().getSysUserId());
        }
        if (peizi == null) {
            peizi = JSON.parseObject((String)public_peiz);
        }
        String beizhu = peizi.toJSONString();
        beizhu = beizhu + "[orderId=" + hyGraphicOrder.getId() + "]";
        Iterator iterator = peizi.keySet().iterator();
        User user = this.userInfoService.getUserById(hyGraphicOrder.getUser().getId());
        while (iterator.hasNext()) {
            String name;
            String fenchenguserid;
            String key = (String)iterator.next();
            Double ratio = peizi.getDouble(key);
            if ("currentUserId".equals(key)) {
                fenchenguserid = hyGraphicOrder.getDoctor().getSysUserId();
                SysUserAccount sysUserAccount = this.sysUserAccountService.queryBalanceByUserId(fenchenguserid);
                if (sysUserAccount != null && this.queryByAccountIdAndTypeAndOrderId(sysUserAccount.getId(), AccountDetailEnum.INTERLOCUTION.getCode(), hyGraphicOrder.getId()) != null) {
                    break;
                }
            } else {
                fenchenguserid = key;
            }
            AccountDetailVo vo = new AccountDetailVo();
            vo.setUserId(fenchenguserid);
            vo.setPrice(Integer.valueOf((int)((double)price.intValue() * ratio)));
            vo.setSpare2(price == null ? null : price.toString());
            vo.setThisTime(time);
            vo.setType(AccountDetailEnum.INTERLOCUTION.getCode());
            if (user == null) {
                name = "\u5df2\u88ab\u5220\u9664";
            } else {
                name = user.getName();
                if (name == null || name.trim().length() <= 0) {
                    name = user.getLoginName();
                }
            }
            vo.setThisSource("\u7528\u6237" + name + "\u7684\u95ee\u7b54\u6536\u6b3e");
            vo.setSpare1(beizhu);
            vo.setSpare3(hyGraphicOrder.getId());
            System.out.println("\u65b0\u589e\u8d26\u6237\u660e\u7ec6\uff0c\u65f6\u95f4\uff1a" + new Date() + " userId\uff1a" + fenchenguserid);
            SysUserAccount sysUserAccount = this.sysUserAccountService.saveUserAccount(vo);
            this.saveUserAccountDetail(sysUserAccount, vo);
        }
    }

    private SysUserAccountDetail queryByAccountIdAndTypeAndOrderId(String accountId, String type, String orderId) {
        if (accountId == null || accountId.trim().equals("")) {
            return null;
        }
        if (type == null || type.trim().equals("")) {
            return null;
        }
        if (orderId == null || orderId.trim().equals("")) {
            return null;
        }
        SysUserAccountDetailExample example = new SysUserAccountDetailExample();
        example.createCriteria().andSysUserAccountIdEqualTo(accountId).andTypeEqualTo(type).andSpare3EqualTo(orderId);
        List<SysUserAccountDetail> list = this.sysUserAccountDetailDao.selectByExample(example);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public void saveUserAccountDetail(SysUserAccount sysUserAccount, AccountDetailVo vo) {
        SysUserAccountDetail detail = new SysUserAccountDetail();
        detail.setId(IdGen.vestaId());
        detail.setPrice(vo.getPrice());
        detail.setSpare1(vo.getSpare1());
        detail.setSpare2(vo.getSpare2());
        detail.setSpare3(vo.getSpare3());
        detail.setSysUserAccountId(sysUserAccount.getId());
        detail.setType(vo.getType());
        detail.setThisSource(vo.getThisSource());
        detail.setThisTime(vo.getThisTime());
        detail.setCreateBy(new User(vo.getUserId()));
        detail.setCreateDate(new Date());
        detail.setDelFlag("0");
        this.sysUserAccountDetailDao.insertSelective(detail);
    }

    public void saveUserAccountDetail(String userId, Integer price, String type, String this_source, String this_time, String spare1) {
        AccountDetailVo vo = new AccountDetailVo();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        vo.setUserId(userId);
        vo.setPrice(price);
        vo.setType(type);
        vo.setThisSource(this_source);
        try {
            vo.setThisTime(sdf.parse(this_time));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        vo.setSpare1(spare1);
        AccountDelayQueueUtils.pushToPublicQueue(vo);
    }

    public Page<SysUserAccountDetailCondition> queryAcccountDetailPageByUserId(Page<SysUserAccountDetail> page, String userId, String status, Date startTime, Date endTime) {
        SysUserAccountDetailCondition condition = new SysUserAccountDetailCondition();
        condition.setUserId(userId);
        if (status != null && status != "") {
            String[] array;
            ArrayList<String> statusList = new ArrayList<String>();
            for (String newstatus : array = status.split(",")) {
                statusList.add(newstatus);
            }
            condition.setStatusIn(statusList);
        }
        if (startTime != null) {
            condition.setStarttime(startTime);
        }
        if (endTime != null) {
            condition.setEndtime(endTime);
        }
        return this.sysUserAccountDetailDao.queryAcccountDetailPageByUserId(page, condition);
    }

    public List<SysUserAccountDetailCondition> queryAcccountDetailListByUserId(String userId, String status, Date startTime, Date endTime) {
        SysUserAccountDetailCondition condition = new SysUserAccountDetailCondition();
        condition.setUserId(userId);
        if (status != null && status != "") {
            String[] array;
            ArrayList<String> statusList = new ArrayList<String>();
            for (String newstatus : array = status.split(",")) {
                statusList.add(newstatus);
            }
            condition.setStatusIn(statusList);
        }
        if (startTime != null) {
            condition.setStarttime(startTime);
        }
        if (endTime != null) {
            condition.setEndtime(endTime);
        }
        return this.sysUserAccountDetailDao.queryAcccountDetailListByUserId(condition);
    }

    public Double selectSumAccount(String userId, String status, Date startTime, Date endTime) {
        SysUserAccountDetailCondition condition = new SysUserAccountDetailCondition();
        condition.setUserId(userId);
        if (status != null && status != "") {
            String[] array;
            ArrayList<String> statusList = new ArrayList<String>();
            for (String newstatus : array = status.split(",")) {
                statusList.add(newstatus);
            }
            condition.setStatusIn(statusList);
        }
        if (startTime != null) {
            condition.setStarttime(startTime);
        }
        if (endTime != null) {
            condition.setEndtime(endTime);
        }
        return this.sysUserAccountDetailDao.selectSumAccount(condition);
    }

    public SysUserAccountDetail selectByPrimaryKey(String id) {
        return this.sysUserAccountDetailDao.selectByPrimaryKey(id);
    }

    public List<SetAccountSchemePriceBean> queryProgrammeListByDoctorUserId(String doctorUserId) {
        return this.sysUserAccountDetailDao.queryProgrammeListByDoctorUserId(doctorUserId);
    }

    public List<HyScheme> queryProgrammeList(String title) {
        return this.sysUserAccountDetailDao.queryProgrammeList(title);
    }

    public void saveKnowledgeUserAccountDetail(HyArticleBuy hyArticleBuy) {
        if (hyArticleBuy != null && hyArticleBuy.getArticleId() != null && hyArticleBuy.getArticleId().trim().length() > 0) {
            HyDoctorArticleExample doctorArticleExample = new HyDoctorArticleExample();
            doctorArticleExample.createCriteria().andDelFlagEqualTo("0").andArticleIdEqualTo(hyArticleBuy.getArticleId());
            List voList = this.hyDoctorArticleService.findVoByList(doctorArticleExample, null);
            if (voList != null && voList.size() > 0) {
                HyDoctorArticleVo doctorArticleVo = (HyDoctorArticleVo)voList.get(0);
                AccountDetailVo vo = new AccountDetailVo();
                User user = null;
                if (doctorArticleVo.getDoctorUserId() != null) {
                    user = this.userInfoService.getUserById(doctorArticleVo.getDoctorUserId());
                }
                if (hyArticleBuy.getBuyPrice() != null && hyArticleBuy.getBuyPrice() > 0.0) {
                    try {
                        vo.setPrice(Integer.valueOf(String.valueOf(hyArticleBuy.getBuyPrice() * 100.0)));
                        vo.setSpare2(String.valueOf(hyArticleBuy.getBuyPrice() * 100.0));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                vo.setThisTime(hyArticleBuy.getBuyTime());
                vo.setType(AccountDetailEnum.EDITION_FEE.getCode());
                if (user != null) {
                    vo.setThisSource("\u7528\u6237" + user.getRealName() != null || user.getRealName().trim().length() > 0 ? user.getRealName() : user.getName() + "\u7684\u6587\u7ae0\u6536\u6b3e");
                }
                vo.setSpare1("[orderId=" + hyArticleBuy.getId() + "]");
                vo.setSpare3(hyArticleBuy.getId());
                SysUserAccount sysUserAccount = this.sysUserAccountService.saveUserAccount(vo);
                this.saveUserAccountDetail(sysUserAccount, vo);
            }
        }
    }
}

