/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.AccountDetailVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserAccountDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysUserAccount;
import com.cxqm.xiaoerke.modules.haoyun.example.SysUserAccountExample;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserAccountService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserAccountServiceImpl
implements SysUserAccountService {
    @Autowired
    SysUserAccountDao sysUserAccountDao;

    public SysUserAccount getById(String id) {
        return this.sysUserAccountDao.selectByPrimaryKey(id);
    }

    public void updateBalance(String accountId, String userId, Integer balance) {
        if (accountId == null || accountId.trim().equals("")) {
            return;
        }
        SysUserAccount sysUserAccount = new SysUserAccount();
        sysUserAccount.setId(accountId);
        sysUserAccount.setBalance(balance);
        sysUserAccount.setUpdateBy(new User(userId));
        sysUserAccount.setUpdateDate(new Date());
        this.sysUserAccountDao.updateByPrimaryKeySelective(sysUserAccount);
    }

    public SysUserAccount saveUserAccount(AccountDetailVo vo) {
        SysUserAccount sysUserAccount = this.queryBalanceByUserId(vo.getUserId());
        if (sysUserAccount == null) {
            sysUserAccount = new SysUserAccount();
            sysUserAccount.setBalance(vo.getPrice());
            sysUserAccount.setSysUserId(vo.getUserId());
            sysUserAccount.setId(IdGen.vestaId());
            sysUserAccount.setCreateBy(new User(vo.getUserId()));
            sysUserAccount.setCreateDate(new Date());
            sysUserAccount.setDelFlag("0");
            this.sysUserAccountDao.insertSelective(sysUserAccount);
        } else {
            if (vo.getPrice() != null && vo.getPrice() != 0) {
                sysUserAccount.setBalance(Integer.valueOf(sysUserAccount.getBalance() == null || sysUserAccount.getBalance() == 0 ? vo.getPrice() : sysUserAccount.getBalance() + vo.getPrice()));
            }
            sysUserAccount.setUpdateBy(new User(vo.getUserId()));
            sysUserAccount.setUpdateDate(new Date());
            this.sysUserAccountDao.updateByPrimaryKeySelective(sysUserAccount);
        }
        return sysUserAccount;
    }

    public SysUserAccount queryBalanceByUserId(String userId) {
        SysUserAccountExample example = new SysUserAccountExample();
        example.createCriteria().andSysUserIdEqualTo(userId);
        List<SysUserAccount> list = this.sysUserAccountDao.selectByExample(example);
        return list == null || list.size() == 0 ? null : list.get(0);
    }
}

