/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.filter.LoadProjectPath;
import com.cxqm.xiaoerke.common.utils.CookieUtils;
import com.cxqm.xiaoerke.common.utils.MD5UtilNew;
import com.cxqm.xiaoerke.common.utils.WCurrentUserUtil;
import com.cxqm.xiaoerke.modules.haoyun.service.HySpDoctorSession;
import com.cxqm.xiaoerke.modules.haoyun.web.ScavengDoctorInfo;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ScavengLoadUserInterceptor
extends HandlerInterceptorAdapter {
    public static String COOKIE_KEY = "X1+n3$]`N8~/_ScavengDoctor";
    public static String USERINFO_SID_LOGIN_KEY = "doctorSidLoginKey";
    public static String USERINFO_LOGIN_KEY = "doctorLoginKey";
    public static String USERINFO_LOGIN_TOKEN_KEY = "doctorLoginTokenKey";
    public static Integer COOKIE_VERSION = 1;
    private String sidKey;
    private String loginUrl;
    @Autowired
    private HySpDoctorSession hySpDoctorSession;

    public String getSidKey() {
        return this.sidKey;
    }

    public void setSidKey(String sidKey) {
        this.sidKey = sidKey;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String userCookieStr;
        String tokenOri;
        String token;
        ScavengDoctorInfo.clear();
        if (this.sidKey != null) {
            User user;
            String sid = request.getParameter(this.sidKey);
            if (this.hySpDoctorSession != null && (user = this.hySpDoctorSession.getUser(sid)) != null) {
                this.packCookies(user, request, response);
                ScavengDoctorInfo.setUserId(user.getId());
                ScavengDoctorInfo.setUser(user);
                return true;
            }
        }
        String userCookie = CookieUtils.getCookie((HttpServletRequest)request, (String)USERINFO_LOGIN_KEY);
        String userTokenCookie = CookieUtils.getCookie((HttpServletRequest)request, (String)USERINFO_LOGIN_TOKEN_KEY);
        if (userCookie != null && (token = MD5UtilNew.getMD5String((String)(tokenOri = (userCookieStr = String.valueOf(userCookie)) + COOKIE_KEY))).equals(userTokenCookie)) {
            JSONObject userJson = JSON.parseObject((String)userCookieStr);
            User user = (User)JSON.parseObject((String)userJson.toJSONString(), User.class);
            ScavengDoctorInfo.setUserId(user.getId());
            ScavengDoctorInfo.setUser(user);
            return true;
        }
        response.sendRedirect(LoadProjectPath.getUrlByScheme((HttpServletRequest)request, (String)this.loginUrl));
        return false;
    }

    private void packCookies(User user, HttpServletRequest request, HttpServletResponse response) {
        if (user == null) {
            return;
        }
        int maxAge = 2592000;
        JSONObject result = this.getUserJsonObject(user);
        String userJsonString = String.valueOf(result);
        String[] domainArr = request.getServerName().split("\\.");
        String doamin = domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*") ? request.getServerName() : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        String doctortoken = null;
        try {
            doctortoken = WCurrentUserUtil.MD5UserToken((String)userJsonString, (String)COOKIE_KEY);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        CookieUtils.setCookie((HttpServletResponse)response, (String)USERINFO_LOGIN_KEY, (String)userJsonString, (int)maxAge, (String)doamin);
        CookieUtils.setCookie((HttpServletResponse)response, (String)USERINFO_LOGIN_TOKEN_KEY, (String)doctortoken, (int)maxAge, (String)doamin);
    }

    public JSONObject getUserJsonObject(User user) {
        if (user == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)(user.getId() == null ? null : user.getId()));
        jsonObject.put("name", (Object)(user.getName() == null ? null : user.getName()));
        jsonObject.put("mobile", (Object)(user.getMobile() == null ? null : user.getMobile()));
        jsonObject.put("buckter", (Object)(user.getBuckter() == null ? null : user.getBuckter()));
        jsonObject.put("photo", (Object)(user.getPhoto() == null ? null : user.getPhoto()));
        jsonObject.put("userType", (Object)(user.getUserType() == null ? null : user.getUserType()));
        return jsonObject;
    }
}

