/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.order.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.DateUtils;
import com.cxqm.xiaoerke.common.utils.FrontUtils;
import com.cxqm.xiaoerke.modules.order.dao.ConsultPhoneRegisterServiceDao;
import com.cxqm.xiaoerke.modules.order.dao.SysConsultPhoneServiceDao;
import com.cxqm.xiaoerke.modules.order.entity.OrderServiceVo;
import com.cxqm.xiaoerke.modules.order.entity.SysConsultPhoneServiceVo;
import com.cxqm.xiaoerke.modules.order.service.ConsultPhoneOrderService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsultPhoneOrderServiceImpl
implements ConsultPhoneOrderService {
    @Autowired
    private SysConsultPhoneServiceDao sysConsultPhoneServiceDao;
    @Autowired
    private ConsultPhoneRegisterServiceDao consultPhoneRegisterServiceDao;

    public Map findDoctorAppointmentInfo(String doctorId) {
        HashMap<String, List<SysConsultPhoneServiceVo>> resultMap = new HashMap<String, List<SysConsultPhoneServiceVo>>();
        List<SysConsultPhoneServiceVo> list = this.sysConsultPhoneServiceDao.selectConsultList(doctorId, null);
        resultMap.put("appointment", list);
        return resultMap;
    }

    public SysConsultPhoneServiceVo getConsultServiceInfo(Integer consultServiceId) {
        return this.sysConsultPhoneServiceDao.selectByPrimaryKey(consultServiceId);
    }

    public Map<String, Object> getOrderListAll(Map<String, Object> params) {
        User user = UserUtils.getUser();
        String userId = user.getId();
        String pageNo = (String)params.get("pageNo");
        String pageSize = (String)params.get("pageSize");
        String status = (String)params.get("status");
        Page page = FrontUtils.generatorPage((String)pageNo, (String)pageSize);
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        if (status == null) {
            searchMap.put("state", null);
        } else {
            searchMap.put("state", status);
        }
        searchMap.put("userId", userId);
        Page<OrderServiceVo> resultPage = this.consultPhoneRegisterServiceDao.getOrderAllPageList((Page<OrderServiceVo>)page, searchMap);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("pageNo", resultPage.getPageNo());
        response.put("pageSize", resultPage.getPageSize());
        long tmp = FrontUtils.generatorTotalPage(resultPage);
        response.put("pageTotal", tmp + "");
        ArrayList orderList = new ArrayList();
        List list = resultPage.getList();
        if (list != null && !list.isEmpty()) {
            Collections.sort(list);
            for (OrderServiceVo order : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("doctorName", order.getDoctorName());
                map.put("position", order.getPosition());
                map.put("hospital", order.getHospitalName());
                SimpleDateFormat format = new SimpleDateFormat("MM/dd");
                map.put("date", format.format(order.getDate()));
                String startTime = DateUtils.DateToStr((Date)order.getBeginTime(), (String)"time");
                String endTime = DateUtils.DateToStr((Date)order.getEndTime(), (String)"time");
                map.put("time", startTime + "-" + endTime);
                map.put("status", order.getStatus());
                map.put("classify", order.getClassify());
                map.put("doctorId", order.getDoctorId());
                map.put("orderId", order.getOrderId());
                orderList.add(map);
            }
        }
        response.put("orderList", orderList);
        return response;
    }

    public Map<String, Object> getUserOrderPhoneConsultList(Map<String, Object> params) {
        User user = UserUtils.getUser();
        String userId = user.getId();
        String pageNo = (String)params.get("pageNo");
        String pageSize = (String)params.get("pageSize");
        String status = (String)params.get("status");
        Page page = FrontUtils.generatorPage((String)pageNo, (String)pageSize);
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        if (status == null) {
            searchMap.put("state", null);
        } else {
            searchMap.put("state", status);
        }
        searchMap.put("userId", userId);
        Page<OrderServiceVo> resultPage = this.consultPhoneRegisterServiceDao.getPhoneConsultPageList((Page<OrderServiceVo>)page, searchMap);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("pageNo", resultPage.getPageNo());
        response.put("pageSize", resultPage.getPageSize());
        long tmp = FrontUtils.generatorTotalPage(resultPage);
        response.put("pageTotal", tmp + "");
        List resultList = resultPage.getList();
        ArrayList orderList = new ArrayList();
        for (OrderServiceVo order : resultList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("doctorName", order.getDoctorName());
            map.put("position", order.getPosition());
            map.put("hospital", order.getHospitalName());
            SimpleDateFormat format = new SimpleDateFormat("MM/dd");
            map.put("date", format.format(order.getDate()));
            map.put("time", DateUtils.DateToStr((Date)order.getBeginTime(), (String)"time") + "-" + DateUtils.DateToStr((Date)order.getEndTime(), (String)"time"));
            map.put("status", order.getStatus());
            map.put("classify", order.getClassify());
            map.put("doctorId", order.getDoctorId());
            map.put("orderId", order.getOrderId());
            orderList.add(map);
        }
        response.put("orderList", orderList);
        return response;
    }

    public List<HashMap<String, Object>> getOrderPhoneConsultListByTime(String state, Date date) {
        return this.consultPhoneRegisterServiceDao.getOrderPhoneConsultListByTime(state, date);
    }

    public HashMap<String, Object> getConsultConnectInfo(Integer id) {
        return this.consultPhoneRegisterServiceDao.getConsultConnectInfo(id);
    }

    public void changeConsultPhoneRegisterServiceState(HashMap<String, Object> excuteMap) {
        this.consultPhoneRegisterServiceDao.changeConsultPhoneRegisterServiceState(excuteMap);
    }

    public HashMap<String, Object> getSettlementPhoneConsultInfoByDate(String doctorId, String date) {
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        searchMap.put("doctorId", doctorId);
        searchMap.put("date", date);
        List<Map<String, Object>> resultList = this.consultPhoneRegisterServiceDao.getSettlementPhoneConsultInfoByDate(searchMap);
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList timeList = new ArrayList();
        Float totalPrice = new Float(0.0f);
        if (resultList != null) {
            for (Map<String, Object> resultMap : resultList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("time", resultMap.get("beginTime"));
                map.put("name", resultMap.get("name"));
                map.put("price", resultMap.get("price"));
                timeList.add(map);
                totalPrice = Float.valueOf(totalPrice.floatValue() + Float.valueOf(String.valueOf(resultMap.get("price"))).floatValue());
            }
        }
        response.put("totalNum", resultList.size());
        response.put("totalPrice", totalPrice);
        response.put("timeList", timeList);
        return response;
    }

    public List<HashMap<String, Object>> getReturnPayConsultList() {
        return this.consultPhoneRegisterServiceDao.getReturnPayConsultList();
    }
}

