/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.order.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.DateUtils;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.modules.account.service.AccountService;
import com.cxqm.xiaoerke.modules.consult.sdk.CCPRestSDK;
import com.cxqm.xiaoerke.modules.healthRecords.entity.BabyIllnessInfoVo;
import com.cxqm.xiaoerke.modules.healthRecords.service.HealthRecordsService;
import com.cxqm.xiaoerke.modules.order.dao.ConsultPhoneManuallyConnectRecordDao;
import com.cxqm.xiaoerke.modules.order.dao.ConsultPhoneRegisterServiceDao;
import com.cxqm.xiaoerke.modules.order.dao.ConsultPhoneTimingDialDao;
import com.cxqm.xiaoerke.modules.order.dao.PhoneConsultDoctorRelationDao;
import com.cxqm.xiaoerke.modules.order.dao.SysConsultPhoneServiceDao;
import com.cxqm.xiaoerke.modules.order.entity.ConsulPhonetDoctorRelationVo;
import com.cxqm.xiaoerke.modules.order.entity.ConsultPhoneManuallyConnectVo;
import com.cxqm.xiaoerke.modules.order.entity.ConsultPhoneRegisterServiceVo;
import com.cxqm.xiaoerke.modules.order.entity.SysConsultPhoneServiceVo;
import com.cxqm.xiaoerke.modules.order.exception.CancelOrderException;
import com.cxqm.xiaoerke.modules.order.exception.CreateOrderException;
import com.cxqm.xiaoerke.modules.order.service.ConsultPhonePatientService;
import com.cxqm.xiaoerke.modules.sys.entity.BabyBaseInfoVo;
import com.cxqm.xiaoerke.modules.sys.entity.PatientVo;
import com.cxqm.xiaoerke.modules.sys.entity.SysPropertyVoWithBLOBsVo;
import com.cxqm.xiaoerke.modules.sys.service.DoctorInfoService;
import com.cxqm.xiaoerke.modules.sys.service.SysPropertyServiceImpl;
import com.cxqm.xiaoerke.modules.sys.service.SystemService;
import com.cxqm.xiaoerke.modules.sys.service.UtilService;
import com.cxqm.xiaoerke.modules.sys.utils.ChangzhuoMessageUtil;
import com.cxqm.xiaoerke.modules.sys.utils.DoctorMsgTemplate;
import com.cxqm.xiaoerke.modules.sys.utils.PatientMsgTemplate;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultPhonePatientServiceImpl
implements ConsultPhonePatientService {
    @Autowired
    private ConsultPhoneRegisterServiceDao consultPhoneRegisterServiceDao;
    @Autowired
    private SysConsultPhoneServiceDao sysConsultPhoneServiceDao;
    @Autowired
    private UtilService utilService;
    @Autowired
    private HealthRecordsService healthRecordsService;
    @Autowired
    private PhoneConsultDoctorRelationDao phoneConsultDoctorRelationDao;
    @Autowired
    private DoctorInfoService doctorInfoService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private ConsultPhoneTimingDialDao consultPhoneTimingDialDao;
    @Autowired
    private SysPropertyServiceImpl sysPropertyService;
    @Autowired
    private ConsultPhoneManuallyConnectRecordDao consultPhoneManuallyConnectRecordDao;

    public Map<String, Object> getPatientRegisterInfo(Integer patientRegisterId) {
        Map<String, Object> registerInfo = this.consultPhoneRegisterServiceDao.getPhoneConsultaServiceIndo(patientRegisterId);
        String position1 = (String)registerInfo.get("position1");
        String position = (String)registerInfo.get("position2");
        if (position1 != null && !"".equals(position1)) {
            position = position1 + "\u3001" + position;
        }
        registerInfo.put("position", position);
        registerInfo.put("expertise", this.doctorInfoService.getDoctorExpertiseById((String)registerInfo.get("doctorId"), (String)registerInfo.get("hospitalId"), null));
        return registerInfo;
    }

    @Transactional(rollbackFor={Exception.class})
    public int PatientRegister(String openid, String babyId, String babyName, Date birthDay, String phoneNum, String illnessDesc, int sysConsultPhoneId) throws CreateOrderException {
        if (!StringUtils.isNotNull((String)babyId)) {
            BabyBaseInfoVo babyVo = new BabyBaseInfoVo();
            babyVo.setBirthday(birthDay);
            babyVo.setName(babyName);
            babyVo.setState("0");
            babyVo.setOpenid(openid);
            babyVo.setUserid(UserUtils.getUser().getId());
            this.healthRecordsService.insertBabyInfo(babyVo);
            babyId = String.valueOf(babyVo.getId());
        }
        BabyIllnessInfoVo illnessVo = new BabyIllnessInfoVo();
        illnessVo.setCreateTime(new Date());
        illnessVo.setDesc(illnessDesc);
        illnessVo.setStatus("0");
        illnessVo.setBabyinfoId(babyId);
        int illnessInfoId = this.healthRecordsService.insertBabyIllnessInfo(illnessVo);
        PatientVo PatientVo2 = this.utilService.CreateUser(UserUtils.getUser().getPhone(), "", "patient");
        SysConsultPhoneServiceVo sysConsultPhoneServiceVo = this.sysConsultPhoneServiceDao.selectByPrimaryKey(sysConsultPhoneId);
        ConsulPhonetDoctorRelationVo consulPhonetDoctorRelationVo = this.phoneConsultDoctorRelationDao.selectByDoctorId(sysConsultPhoneServiceVo.getSysDoctorId());
        ConsultPhoneRegisterServiceVo vo = new ConsultPhoneRegisterServiceVo();
        vo.setIllnessDescribeId(illnessVo.getId());
        vo.setCreateTime(new Date());
        String register_no = ChangzhuoMessageUtil.createRandom((boolean)true, (int)10);
        vo.setRegisterNo(register_no);
        vo.setState("0");
        vo.setSysPatientId(PatientVo2.getId());
        vo.setSysPhoneconsultServiceId(Integer.valueOf(sysConsultPhoneId));
        vo.setPhoneNum(phoneNum);
        vo.setCreat_by(UserUtils.getUser().getId());
        vo.setType("0");
        Integer serviceLength = consulPhonetDoctorRelationVo.getServerLength() * 60 * 1000;
        vo.setSurplusTime((long)serviceLength.intValue());
        int result = this.consultPhoneRegisterServiceDao.insertSelective(vo);
        if (result == 0) {
            throw new CreateOrderException();
        }
        SysConsultPhoneServiceVo sysVo = new SysConsultPhoneServiceVo();
        sysVo.setId(Integer.valueOf(sysConsultPhoneId));
        sysVo.setState("1");
        sysVo.setUpdatedate(new Date());
        Integer sysState = this.sysConsultPhoneServiceDao.updateByPrimaryKeySelective(sysVo);
        if (sysState == 0) {
            throw new CreateOrderException();
        }
        return vo.getId();
    }

    public List<HashMap<String, Object>> getOrderList(String userId) {
        return this.consultPhoneRegisterServiceDao.getPhoneConsultaList(userId, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Float cancelOrder(Integer phoneConsultaServiceId, String cancelReason, String cancelState) throws CancelOrderException {
        int sysOrderState = 0;
        SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo = this.sysPropertyService.querySysProperty();
        Map<String, Object> map = this.consultPhoneRegisterServiceDao.getPhoneConsultaServiceIndo(phoneConsultaServiceId);
        ConsultPhoneRegisterServiceVo consultPhoneRegisterServiceVo = new ConsultPhoneRegisterServiceVo();
        consultPhoneRegisterServiceVo.setState("4");
        consultPhoneRegisterServiceVo.setUpdateTime(new Date());
        consultPhoneRegisterServiceVo.setId(phoneConsultaServiceId);
        consultPhoneRegisterServiceVo.setDeleteBy(UserUtils.getUser().getName());
        int state = this.consultPhoneRegisterServiceDao.updateByPrimaryKeySelective(consultPhoneRegisterServiceVo);
        if (state > 0) {
            sysOrderState = this.sysConsultPhoneServiceDao.cancelOrder((Integer)map.get("sys_phoneConsult_service_id"), cancelState);
        }
        if (sysOrderState > 0) {
            String doctorName = (String)map.get("doctorName");
            String doctorPhone = (String)map.get("doctorPhone");
            String babyName = (String)map.get("babyName");
            String date = (String)map.get("date");
            String beginTime = (String)map.get("beginTime");
            String week = DateUtils.getWeekOfDate((Date)DateUtils.StrToDate((String)((String)map.get("date")), (String)"yyyy/MM/dd"));
            Map parameter = this.systemService.getWechatParameter();
            String token = (String)parameter.get("token");
            String url = sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/phoneConsult#/orderDetail" + (String)map.get("doctorId") + "," + (Integer)map.get("orderId") + ",phone";
            PatientMsgTemplate.consultPhoneCancel2Wechat((String)doctorName, (String)date, (String)week, (String)beginTime, (String)((String)map.get("endTime")), (String)((String)map.get("phone")), (String)((String)map.get("orderNo")), (String)((Float)map.get("price") + ""), (String)((String)map.get("openid")), (String)token, (String)url);
            PatientMsgTemplate.consultPhoneRefund2Msg((String)doctorName, (String)((Float)map.get("price") + ""), (String)((String)map.get("phone")), (String)((String)map.get("date")), (String)week, (String)((String)map.get("beginTime")), (String)((String)map.get("orderNo")));
            if ("1".equals((String)map.get("status")) && "3".equals((String)map.get("types"))) {
                DoctorMsgTemplate.cancelDoctorPhoneConsult2Sms((String)doctorName, (String)babyName, (String)doctorPhone, (String)date, (String)week, (String)beginTime);
                Map tokenMap = this.systemService.getDoctorWechatParameter();
                String doctorToken = (String)tokenMap.get("token");
                String openId = this.doctorInfoService.findOpenIdByDoctorId((String)map.get("doctorId"));
                if (StringUtils.isNotNull((String)openId)) {
                    DoctorMsgTemplate.cancelDoctorPhoneConsult2Wechat((String)babyName, (String)doctorName, (String)date, (String)week, (String)beginTime, (String)doctorToken, (String)"", (String)openId);
                }
            }
        }
        if (sysOrderState == 0) {
            throw new CancelOrderException();
        }
        return (Float)map.get("price");
    }

    public int updateOrderInfoBySelect(ConsultPhoneRegisterServiceVo vo) {
        return this.consultPhoneRegisterServiceDao.updateByPrimaryKeySelective(vo);
    }

    public Page<ConsultPhoneRegisterServiceVo> findConsultPhonePatientList(Page<ConsultPhoneRegisterServiceVo> page, ConsultPhoneRegisterServiceVo vo) {
        Page<ConsultPhoneRegisterServiceVo> pages = this.consultPhoneRegisterServiceDao.findConsultPhonePatientList(page, vo);
        for (ConsultPhoneRegisterServiceVo tvo : pages.getList()) {
            tvo.setSurplusDate(new Date(tvo.getSurplusTime()));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orderId", tvo.getId());
            map.put("state", 1);
            List<ConsultPhoneManuallyConnectVo> list = this.consultPhoneTimingDialDao.getConsultPhoneTimingDialByInfo(map);
            if (list.size() == 0) continue;
            tvo.setState("daichonglian");
        }
        return pages;
    }

    public int getNewOrderCount(String state) {
        int count = this.consultPhoneRegisterServiceDao.getNewOrderCount(state);
        return count;
    }

    public List<ConsultPhoneRegisterServiceVo> getAllConsultPhoneRegisterListByInfo(ConsultPhoneRegisterServiceVo vo) {
        List<ConsultPhoneRegisterServiceVo> list = this.consultPhoneRegisterServiceDao.getAllConsultPhoneRegisterListByInfo(vo);
        SimpleDateFormat sdf = new SimpleDateFormat("mm:ss");
        for (ConsultPhoneRegisterServiceVo temp : list) {
            temp.setConsultPhoneTimeFromStr(DateUtils.DateToStr((Date)temp.getDate(), (String)"date") + " " + DateUtils.DateToStr((Date)temp.getBeginTime(), (String)"time"));
            temp.setType(temp.getPrice() + "\u5143/" + temp.getType() + "min");
            temp.setConsultPhoneTimeToStr(sdf.format(new Date(temp.getSurplusTime())));
            temp.setOrderTimeFromStr(DateUtils.DateToStr((Date)temp.getCreateTime(), (String)"datetime"));
            if ("0".equals(temp.getState())) {
                temp.setState("\u5f85\u652f\u4ed8");
                temp.setPayState("\u5f85\u652f\u4ed8");
            } else if ("1".equals(temp.getState())) {
                temp.setState("\u5f85\u63a5\u901a");
                temp.setPayState("\u5df2\u4ed8\u6b3e");
            } else if ("2".equals(temp.getState())) {
                temp.setState("\u5f85\u8bc4\u4ef7");
                temp.setPayState("\u5df2\u4ed8\u6b3e");
            } else if ("3".equals(temp.getState())) {
                temp.setState("\u5f85\u5206\u4eab");
                temp.setPayState("\u5df2\u4ed8\u6b3e");
            } else if ("4".equals(temp.getState())) {
                temp.setState("\u5df2\u53d6\u6d88");
                temp.setPayState("\u5df2\u9000\u6b3e");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orderId", temp.getId());
            map.put("state", 1);
            List<ConsultPhoneManuallyConnectVo> clist = this.consultPhoneTimingDialDao.getConsultPhoneTimingDialByInfo(map);
            if (clist.size() != 0) {
                temp.setState("\u7b49\u5f85\u91cd\u8fde");
                temp.setPayState("\u5df2\u4ed8\u6b3e");
            }
            if (temp.getUpdateTime() == null) continue;
            temp.setOrderTimeToStr(DateUtils.DateToStr((Date)temp.getUpdateTime(), (String)"datetime"));
        }
        return list;
    }

    public List<Map<String, Object>> getConsultPhoneRegisterListByInfo(Map map) {
        return this.consultPhoneRegisterServiceDao.getConsultPhoneRegisterListByInfo(map);
    }

    public Map manuallyConnectFormInfo(ConsultPhoneRegisterServiceVo vo) {
        Map<Object, Object> map = new HashMap<String, Object>();
        map.put("id", vo.getId());
        List<Map<String, Object>> consultInfoList = this.getConsultPhoneRegisterListByInfo(map);
        map.remove("id");
        map.put("doctorId", vo.getDoctorId());
        map.put("fromDate", "yes");
        List<Map<String, Object>> orderList = this.getConsultPhoneRegisterListByInfo(map);
        HashMap<Object, String> orderTimeMap = new HashMap<Object, String>();
        for (Map<String, Object> temp : orderList) {
            orderTimeMap.put(temp.get("date"), orderTimeMap.containsKey(temp.get("date")) ? orderTimeMap.get(temp.get("date")) + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + temp.get("beginTime").toString().substring(0, 5) + "--" + temp.get("endTime").toString().substring(0, 5) : temp.get("beginTime").toString().substring(0, 5) + "--" + temp.get("endTime").toString().substring(0, 5));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orderId", vo.getId());
        List<ConsultPhoneManuallyConnectVo> recordList = this.consultPhoneManuallyConnectRecordDao.getManuallyConnectRecordListByInfo(paramMap);
        for (ConsultPhoneManuallyConnectVo cvo : recordList) {
            cvo.setSurplusDate(new Date(cvo.getSurplusTime()));
        }
        map = consultInfoList.get(0);
        map.put("surplusTime", new Date((Long)map.get("surplusTime")));
        map.put("orderTimeMap", orderTimeMap);
        map.put("recordList", recordList);
        return map;
    }

    @Transactional(rollbackFor={Exception.class})
    public JSONObject manuallyConnect(ConsultPhoneManuallyConnectVo vo) throws Exception {
        JSONObject result = new JSONObject();
        boolean tip = true;
        if ("immediatelyDial".equals(vo.getDialType())) {
            this.dialConnection(vo);
            vo.setDialDate(new Date());
        } else if ("timingDial".equals(vo.getDialType())) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("orderId", vo.getOrderId());
            param.put("state", "1");
            List<ConsultPhoneManuallyConnectVo> list = this.consultPhoneTimingDialDao.getConsultPhoneTimingDialByInfo(param);
            if (list.size() == 0) {
                vo.setState("1");
                this.consultPhoneTimingDialDao.saveConsultPhoneTimingDialInfo(vo);
            } else {
                result.put((Object)"result", (Object)"\u5df2\u8bbe\u7f6e\u5b9a\u65f6\u62e8\u6253\uff01");
                tip = false;
            }
        }
        if (tip) {
            vo.setOperBy(UserUtils.getUser().getName());
            this.consultPhoneManuallyConnectRecordDao.saveManuallyConnectRecordInfo(vo);
        }
        return result;
    }

    public List<ConsultPhoneManuallyConnectVo> getConsultPhoneTimingDialByInfo(Map<String, Object> map) {
        List<ConsultPhoneManuallyConnectVo> list = this.consultPhoneTimingDialDao.getConsultPhoneTimingDialByInfo(map);
        return list;
    }

    public int updateConsultPhoneTimingDialInfo(ConsultPhoneManuallyConnectVo vo) {
        int count = this.consultPhoneTimingDialDao.updateConsultPhoneTimingDialInfo(vo);
        return count;
    }

    private String dialConnection(ConsultPhoneManuallyConnectVo vo) {
        long conversationLength = vo.getSurplusTime() / 1000L;
        HashMap result = CCPRestSDK.callback((String)vo.getDoctorPhone(), (String)vo.getUserPhone(), (String)"01057115120", (String)"01057115120", null, (String)"true", null, (String)(vo.getOrderId() + ""), (String)(conversationLength + ""), null, (String)"0", (String)"1", (String)"60", null);
        String statusCode = (String)result.get("statusCode");
        return statusCode;
    }

    public ConsultPhoneRegisterServiceVo selectByPrimaryKey(Integer phoneConsultaServiceId) {
        return this.consultPhoneRegisterServiceDao.selectByPrimaryKey(phoneConsultaServiceId);
    }

    public int CancelAppointNoPay() {
        this.consultPhoneRegisterServiceDao.cancelAppointNoPayRegiste();
        return this.consultPhoneRegisterServiceDao.cancelAppointNoPayOrder();
    }
}

