/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.order.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.DateUtils;
import com.cxqm.xiaoerke.common.utils.FrontUtils;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.account.entity.PayRecord;
import com.cxqm.xiaoerke.modules.account.service.PayRecordService;
import com.cxqm.xiaoerke.modules.order.dao.OrderPropertyDao;
import com.cxqm.xiaoerke.modules.order.dao.PatientRegisterServiceDao;
import com.cxqm.xiaoerke.modules.order.entity.OrderPropertyVo;
import com.cxqm.xiaoerke.modules.order.entity.PatientRegisterServiceVo;
import com.cxqm.xiaoerke.modules.order.service.OrderPropertyService;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class OrderPropertyServiceImpl
implements OrderPropertyService {
    @Autowired
    PatientRegisterServiceDao patientRegisterServiceDao;
    @Autowired
    private PayRecordService payRecordService;
    @Autowired
    OrderPropertyDao orderPropertyDao;
    private static ExecutorService threadExecutor = Executors.newSingleThreadExecutor();

    public void saveOrderProperty(OrderPropertyVo orderPropertyVo) {
        OrderPropertyThread thread = new OrderPropertyThread(orderPropertyVo);
        threadExecutor.execute(thread);
    }

    public class OrderPropertyThread
    extends Thread {
        private OrderPropertyVo propertyVo;

        public OrderPropertyThread(OrderPropertyVo orderPropertyVo) {
            this.propertyVo = orderPropertyVo;
        }

        @Override
        public void run() {
            if ("kefu".equals(this.propertyVo.getOrderSource())) {
                this.propertyVo.setYellowCattle("null");
                this.propertyVo.setFirstOrder("null");
                this.propertyVo.setScanCode("null");
                this.propertyVo.setCharge("no");
            } else {
                this.saveOrderProperty();
            }
            String date = DateUtils.DateToStr((Date)new Date());
            this.propertyVo.setCreateDate(date);
            this.propertyVo.setId(IdGen.uuid());
            OrderPropertyServiceImpl.this.orderPropertyDao.insert(this.propertyVo);
        }

        private void saveOrderProperty() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("openid", this.propertyVo.getOpenid());
            map.put("firstOrder", "no");
            List<PatientRegisterServiceVo> yellowCattleVo = OrderPropertyServiceImpl.this.patientRegisterServiceDao.findPageRegisterServiceByPatient(map);
            System.out.println("\u5224\u65ad\u662f\u4e0d\u662f\u9ec4\u725b\uff1f" + yellowCattleVo.size());
            if (yellowCattleVo.size() > 3) {
                this.propertyVo.setYellowCattle("yes");
                System.out.println("\u662f\u9ec4\u725b:" + yellowCattleVo.size());
            } else {
                this.propertyVo.setYellowCattle("no");
                System.out.println("\u4e0d\u662f\u9ec4\u725b:" + yellowCattleVo.size());
            }
            map.put("firstOrder", "yes");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("unBindUserPhoneNum", UserUtils.getUser().getPhone());
            Page page = FrontUtils.generatorPage((String)"1", (String)"10");
            Page<PatientRegisterServiceVo> resultPage = OrderPropertyServiceImpl.this.patientRegisterServiceDao.getUnBindUserPhoneOrder((Page<PatientRegisterServiceVo>)page, hashMap);
            List firstOrderVo = resultPage.getList();
            System.out.println("\u5224\u65ad\u662f\u4e0d\u662f\u9996\u6b21\u9884\u7ea6\uff1f" + firstOrderVo.size());
            if (firstOrderVo.size() == 1) {
                this.propertyVo.setFirstOrder("yes");
                System.out.println("\u662f\u9996\u5355:" + firstOrderVo.size());
            } else {
                this.propertyVo.setFirstOrder("no");
                System.out.println("\u4e0d\u662f\u9996\u5355:" + firstOrderVo.size());
            }
            PatientRegisterServiceVo patientRegisterServiceVo = new PatientRegisterServiceVo();
            patientRegisterServiceVo.setOpenId(this.propertyVo.getOpenid());
            patientRegisterServiceVo.setId(this.propertyVo.getPatientRegisterServiceId());
            List<PatientRegisterServiceVo> attendVos = OrderPropertyServiceImpl.this.patientRegisterServiceDao.findAttentionInfoByOpenIdLists(patientRegisterServiceVo);
            System.out.println("\u5224\u65ad\u662f\u4e0d\u662f\u626b\u7801\u7528\u6237\uff1f" + attendVos.size());
            if (attendVos.size() > 0) {
                this.propertyVo.setScanCode("yes");
                System.out.println("\u662f\u626b\u7801\u7528\u6237" + attendVos.size());
            } else {
                this.propertyVo.setScanCode("no");
                System.out.println("\u4e0d\u662f\u626b\u7801\u7528\u6237" + attendVos.size());
            }
            System.out.println("\u8ba2\u5355\u4e3b\u952e\uff1f" + this.propertyVo.getPatientRegisterServiceId());
            PayRecord payRecord = OrderPropertyServiceImpl.this.payRecordService.findPayRecordByOrder(this.propertyVo.getPatientRegisterServiceId());
            if (payRecord != null) {
                this.propertyVo.setCharge("yes");
                System.out.println("\u4ed8\u8d39" + payRecord.getCreatedBy());
            } else {
                this.propertyVo.setCharge("no");
                System.out.println("\u6ca1\u6709\u4ed8\u8d39" + payRecord);
            }
        }
    }
}

