/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.order.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.DateUtils;
import com.cxqm.xiaoerke.common.utils.FrontUtils;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.common.web.Servlets;
import com.cxqm.xiaoerke.modules.member.service.MemberService;
import com.cxqm.xiaoerke.modules.order.dao.PatientRegisterServiceDao;
import com.cxqm.xiaoerke.modules.order.dao.RegisterServiceDao;
import com.cxqm.xiaoerke.modules.order.dao.RegisterStoreDao;
import com.cxqm.xiaoerke.modules.order.dao.RegisterTemplateServiceDao;
import com.cxqm.xiaoerke.modules.order.entity.PatientRegisterServiceVo;
import com.cxqm.xiaoerke.modules.order.entity.RegisterServiceVo;
import com.cxqm.xiaoerke.modules.order.entity.RegisterStoreVo;
import com.cxqm.xiaoerke.modules.order.entity.RegisterTemplateServiceVo;
import com.cxqm.xiaoerke.modules.order.service.RegisterService;
import com.cxqm.xiaoerke.modules.order.service.impl.OrderMessageService;
import com.cxqm.xiaoerke.modules.sys.entity.DoctorHospitalRelationVo;
import com.cxqm.xiaoerke.modules.sys.entity.DoctorLocationVo;
import com.cxqm.xiaoerke.modules.sys.entity.HospitalVo;
import com.cxqm.xiaoerke.modules.sys.entity.IllnessVo;
import com.cxqm.xiaoerke.modules.sys.entity.Notification;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.DoctorInfoService;
import com.cxqm.xiaoerke.modules.sys.service.DoctorLocationService;
import com.cxqm.xiaoerke.modules.sys.service.HospitalInfoService;
import com.cxqm.xiaoerke.modules.sys.service.IllnessInfoService;
import com.cxqm.xiaoerke.modules.sys.service.MessageService;
import com.cxqm.xiaoerke.modules.sys.service.NotificationService;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import com.cxqm.xiaoerke.modules.sys.utils.LogUtils;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class RegisterServiceImpl
implements RegisterService {
    @Autowired
    private IllnessInfoService illnessInfoService;
    @Autowired
    private RegisterServiceDao registerServiceDao;
    @Autowired
    private RegisterTemplateServiceDao registerTemplateServiceDao;
    @Autowired
    private PatientRegisterServiceDao patientRegisterServiceDao;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private HospitalInfoService hospitalInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private DoctorInfoService doctorInfoService;
    @Autowired
    private DoctorLocationService doctorLocationService;
    @Autowired
    private OrderMessageService orderMessageService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private RegisterStoreDao registerStoreDao;

    public HashMap<String, Object> findRecentlyDateAppDate(String doctorId) {
        HashMap<String, Object> doctorMap = new HashMap<String, Object>();
        doctorMap.put("doctorId", doctorId);
        HashMap<String, Object> resultMap = this.registerServiceDao.findrecentlyDateAppDateExcute(doctorMap);
        return resultMap;
    }

    public List<HashMap<String, Object>> getDoctorVisitInfoByLocation(Map data) {
        return this.registerServiceDao.getDoctorVisitInfoByLocation(data);
    }

    public Map<String, Object> listAppointmentTimeHospital(Map<String, Object> params) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Date date = DateUtils.formatDate(params);
        String currentPage = (String)params.get("pageNo");
        String pageSize = (String)params.get("pageSize");
        String orderBy = (String)params.get("orderBy");
        String consultPhone = (String)params.get("consultPhone");
        Page page = FrontUtils.generatorPage((String)currentPage, (String)pageSize);
        HashMap<String, Object> hospitalInfo = new HashMap<String, Object>();
        hospitalInfo.put("orderBy", orderBy);
        hospitalInfo.put("date", date);
        hospitalInfo.put("consultPhone", consultPhone);
        if (StringUtils.isNotNull((String)consultPhone)) {
            List list = this.hospitalInfoService.findConsultHospitalByTime(date);
            response.put("hospitalData", list);
        } else {
            Page resultPage = this.hospitalInfoService.findPageHospitalByTime(hospitalInfo, page);
            LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000034", (String)("date:" + date));
            response.put("pageNo", resultPage.getPageNo());
            response.put("pageSize", resultPage.getPageSize());
            long tmp = FrontUtils.generatorTotalPage((Page)resultPage);
            response.put("pageTotal", tmp + "");
            List list = resultPage.getList();
            ArrayList hospitalVoList = new ArrayList();
            if (list != null && !list.isEmpty()) {
                for (Map hospitalVoMap : list) {
                    HashMap dataMap = new HashMap();
                    dataMap.put("hospitalId", hospitalVoMap.get("id"));
                    dataMap.put("hospitalName", hospitalVoMap.get("name"));
                    dataMap.put("hospitalLocation", hospitalVoMap.get("position"));
                    hospitalVoList.add(dataMap);
                }
            }
            response.put("hospitalData", hospitalVoList);
        }
        return response;
    }

    public Map<String, Object> listAppointmentTimeDoctor(Map<String, Object> params) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Date date = DateUtils.formatDate(params);
        String currentPage = (String)params.get("pageNo");
        String pageSize = (String)params.get("pageSize");
        String orderBy = (String)params.get("orderBy");
        String hospitalId = (String)params.get("hospitalId");
        String department_level1 = (String)params.get("department_level1");
        Page page = FrontUtils.generatorPage((String)currentPage, (String)pageSize);
        HashMap<String, Object> dateInfo = new HashMap<String, Object>();
        dateInfo.put("orderBy", orderBy);
        dateInfo.put("date", date);
        dateInfo.put("hospitalId", hospitalId);
        dateInfo.put("department_level1", department_level1);
        Page resultPage = this.doctorInfoService.findPageDoctorByTime(dateInfo, page);
        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000032", (String)("date:" + date + "\u533b\u9662" + hospitalId));
        String sort = "";
        if (orderBy == "0") {
            sort = "\u65f6\u95f4\u6700\u8fd1\u6392\u5e8f";
        } else if (orderBy == "1") {
            sort = "\u7c89\u4e1d\u6700\u591a\u6392\u5e8f";
        } else if (orderBy == "1") {
            sort = "\u4ece\u4e1a\u65f6\u95f4\u6392\u5e8f";
        }
        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000033", (String)("\u6839\u636e" + sort + "\u83b7\u53d6\u67d0\u4e2a\u9884\u7ea6\u65e5\u671f\u4e0b\u7684\u53ef\u9884\u7ea6\u533b\u751f"));
        response.put("pageNo", resultPage.getPageNo());
        response.put("pageSize", resultPage.getPageSize());
        long tmp = FrontUtils.generatorTotalPage((Page)resultPage);
        response.put("pageTotal", tmp + "");
        List list = resultPage.getList();
        ArrayList<HashMap<String, Object>> doctorDataVoList = new ArrayList<HashMap<String, Object>>();
        this.generateDoctorDataVoListByDate(list, doctorDataVoList, date);
        response.put("doctorDataVo", doctorDataVoList);
        return response;
    }

    public Map<String, Object> listAppointmentTimeHospitalDoctor(Map<String, Object> params) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Date date = DateUtils.formatDate(params);
        String currentPage = (String)params.get("pageNo");
        String pageSize = (String)params.get("pageSize");
        String orderBy = (String)params.get("orderBy");
        String hospitalId = (String)params.get("hospitalId");
        Page page = FrontUtils.generatorPage((String)currentPage, (String)pageSize);
        HashMap<String, Object> dateInfo = new HashMap<String, Object>();
        dateInfo.put("orderBy", orderBy);
        dateInfo.put("date", date);
        dateInfo.put("hospitalId", hospitalId);
        Page resultPage = this.doctorInfoService.findPageDoctorByTimeAndHospital(dateInfo, page);
        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000035", (String)("\u533b\u9662id:" + hospitalId));
        response.put("pageNo", resultPage.getPageNo());
        response.put("pageSize", resultPage.getPageSize());
        long tmp = FrontUtils.generatorTotalPage((Page)resultPage);
        response.put("pageTotal", tmp + "");
        List list = resultPage.getList();
        ArrayList<HashMap<String, Object>> doctorDataVoList = new ArrayList<HashMap<String, Object>>();
        this.generateDoctorDataVoList(list, doctorDataVoList);
        response.put("doctorDataVo", doctorDataVoList);
        return response;
    }

    public Map<String, Object> doctorAppointmentInfoOfDay(Map<String, Object> params) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String doctorId = (String)params.get("doctorId");
        Date date = DateUtils.formatDate(params);
        String DateToStr = DateUtils.DateToStr((Date)date);
        int week = 0;
        try {
            week = DateUtils.dayForWeek((String)DateToStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String dayWeek = DateUtils.getDayWeek((int)week);
        HashMap<String, Object> dataInfo = new HashMap<String, Object>();
        dataInfo.put("doctorId", doctorId);
        dataInfo.put("date", date);
        dataInfo.put("location_id", params.get("location_id"));
        StringBuffer bf = new StringBuffer();
        bf.append(DateToStr.substring(0, 10));
        bf.append("  " + dayWeek).toString();
        response.put("date", bf);
        dataInfo.put("user", "user");
        List<HashMap<String, Object>> appointmentVoList = this.registerServiceDao.findAllAppointmentInfoByDoctor(dataInfo);
        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000030", (String)("\u533b\u751f\u4e3b\u952e\uff1a" + doctorId + "date:" + date));
        HashMap<String, String> dataMapInfo = new HashMap<String, String>();
        ArrayList dataMapList = new ArrayList();
        for (Map map : appointmentVoList) {
            String hospitalId = (String)map.get("sys_hospital_id");
            dataMapInfo.put(hospitalId, hospitalId);
        }
        for (int i = 0; i < dataMapInfo.size(); ++i) {
            HashMap hashMap = new HashMap();
            ArrayList available_time = new ArrayList();
            for (Map map : appointmentVoList) {
                HashMap timeMap = new HashMap();
                hashMap.put("hospitalId", map.get("sys_hospital_id"));
                hashMap.put("location", map.get("location"));
                hashMap.put("price", map.get("price"));
                hashMap.put("service_type", map.get("service_type"));
                timeMap.put("register_service_id", map.get("id"));
                timeMap.put("begin_time", map.get("begin_time"));
                timeMap.put("end_time", map.get("end_time"));
                timeMap.put("status", map.get("status"));
                available_time.add(timeMap);
                hashMap.put("available_time", available_time);
            }
            dataMapList.add(hashMap);
        }
        response.put("appointmentList", dataMapList);
        return response;
    }

    public Map<String, Object> doctorAppointmentInfoDetailOfDay(Map<String, Object> params) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap perInfo = null;
        String doctorId = (String)params.get("doctorId");
        String patient_register_service_id = (String)params.get("patient_register_service_id");
        String sys_register_service_id = (String)params.get("register_service_id");
        String date = (String)params.get("date");
        String begin_time = (String)params.get("begin_time");
        String end_time = (String)params.get("end_time");
        HashMap<String, String> appointmentInfo = new HashMap<String, String>();
        appointmentInfo.put("doctorId", doctorId);
        appointmentInfo.put("patient_register_service_id", patient_register_service_id);
        appointmentInfo.put("date", date);
        appointmentInfo.put("begin_time", begin_time);
        appointmentInfo.put("end_time", end_time);
        appointmentInfo.put("sys_register_service_id", sys_register_service_id);
        String userId = UserUtils.getUser().getId();
        if (userId != null && !"".equals(userId)) {
            perInfo = this.userInfoService.findPersonDetailInfoByUserId(userId);
            response.put("phone", perInfo.get("phone"));
        }
        List list = this.doctorInfoService.findAppointmentInfoDetail(appointmentInfo);
        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000029", (String)("doctorId:" + doctorId + "sys_register_service_id:" + sys_register_service_id));
        for (Map appointmentData : list) {
            response.put("location", appointmentData.get("location"));
            response.put("price", appointmentData.get("price"));
            response.put("deposit", appointmentData.get("deposit"));
            response.put("service_type", appointmentData.get("service_type"));
            response.put("location", appointmentData.get("location"));
            response.put("root", appointmentData.get("root"));
            response.put("begin_time", appointmentData.get("begin_time"));
            response.put("end_time", appointmentData.get("end_time"));
        }
        return response;
    }

    public Map<String, Object> orderSourceRoute(Map<String, Object> params) {
        HashMap<String, Object> sourceRouteMap = new HashMap<String, Object>();
        String register_service_id = (String)params.get("register_service_id");
        if (register_service_id == null) {
            throw new RuntimeException("Parameter register_service_id cannot be null.");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("registerId", register_service_id);
        hashMap = this.registerServiceDao.getSysRegisterServiceInfo(hashMap);
        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000036", (String)("\u53f7\u6e90id:" + register_service_id));
        HashMap<String, String> response = new HashMap<String, String>();
        String location = hashMap.get("position") + "  " + hashMap.get("hospitalName") + "  " + hashMap.get("location");
        response.put("location", location);
        String[] strings = hashMap.get("root").toString().split("\uff1b");
        String traffic = strings[0];
        response.put("traffic", traffic);
        response.put("internal_route", strings[1]);
        response.put("shot_message", strings[2]);
        String car = traffic.substring(traffic.indexOf("\u505c\u8f66") + 2, traffic.indexOf("\u3001\u5730\u94c1") - 1);
        String subway = traffic.substring(traffic.indexOf("\u3001\u5730\u94c1") + 3, traffic.indexOf("\u3001\u516c\u4ea4") - 1);
        String bus = traffic.substring(traffic.indexOf("\u3001\u516c\u4ea4") + 3);
        response.put("car", car);
        response.put("subway", subway);
        response.put("bus", bus);
        sourceRouteMap.put("root", response);
        return sourceRouteMap;
    }

    public Map<String, Object> returnRegisterInfo(String doctorId, String pageFlag) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        List dlvlist = this.doctorLocationService.getDoctorLocationInfo(doctorId);
        if (dlvlist != null && dlvlist.size() != 0) {
            DoctorLocationVo doctorLocationVo = (DoctorLocationVo)dlvlist.get(0);
            RegisterServiceVo vo = new RegisterServiceVo();
            vo.setSysDoctorId(doctorLocationVo.getSysDoctorId());
            vo.setSysHospitalId(doctorLocationVo.getSysHospitalId());
            vo.setDoctorName(doctorLocationVo.getDoctorName());
            vo.setHospitalName(doctorLocationVo.getHospital());
            vo.setLocation(doctorLocationVo.getLocation());
            vo.setLocationId(doctorLocationVo.getId());
            ArrayList<String> dateList = new ArrayList<String>();
            String weekday = "";
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(6, 7 * Integer.parseInt(pageFlag));
            Date firstDay = c.getTime();
            for (int i = 0; i < 7; ++i) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(firstDay);
                if (i == 0) {
                    weekday = calendar.get(7) + "";
                }
                ((Calendar)calendar).add(5, i);
                Date date = calendar.getTime();
                int dayForWeek = 0;
                dayForWeek = calendar.get(7) == 1 ? 7 : calendar.get(7) - 1;
                String[] weekDays = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u65e5"};
                String date_ = DateUtils.DateToStr((Date)date, (String)"date");
                dateList.add(date_ + "(" + weekDays[dayForWeek - 1] + ")");
            }
            Map<String, Object> retmap = this.compareRegisterTime(doctorId, DateUtils.DateToStr((Date)firstDay, (String)"date"), vo.getLocationId());
            vo.setPrice((Float)retmap.get("price"));
            vo.setServiceType((String)retmap.get("serverType"));
            retMap.put("dateList", dateList);
            retMap.put("locationList", dlvlist);
            retMap.put("registerServiceVo", vo);
            retMap.put("repeatFlag", retmap.get("repeatFlag"));
            retMap.put("intervalFlag", retmap.get("intervalFlag"));
            retMap.put("timeList", retmap.get("timeList"));
            retMap.put("distimeList", retmap.get("distimeList"));
            return retMap;
        }
        return null;
    }

    public JSONObject getRegisterTime(String doctorId, String date, String locationId) {
        JSONObject result = new JSONObject();
        Map<String, Object> retmap = this.compareRegisterTime(doctorId, date, locationId);
        result.put((Object)"price", retmap.get("price"));
        result.put((Object)"serverType", retmap.get("serverType"));
        result.put((Object)"repeatFlag", retmap.get("repeatFlag"));
        result.put((Object)"intervalFlag", retmap.get("intervalFlag"));
        result.put((Object)"success", (Object)"success");
        result.put((Object)"timeList", retmap.get("timeList"));
        result.put((Object)"distimeList", retmap.get("distimeList"));
        return result;
    }

    public String judgeRepeatEffect(String date, String timeParam, String locationId, String doctorId, String operRepeat) {
        String[] timeArray = timeParam.split(";");
        StringBuffer sb = new StringBuffer("");
        for (String time : timeArray) {
            RegisterServiceVo vo = new RegisterServiceVo();
            vo.setLocationId(locationId);
            vo.setSysDoctorId(doctorId);
            RegisterServiceVo rvo = new RegisterServiceVo();
            rvo.setSysDoctorId(doctorId);
            rvo.setLocationId(locationId);
            List dateList = new ArrayList();
            Map<String, Object> retMap = this.getDateList(rvo, date, time, operRepeat);
            dateList = (List)retMap.get("dateList");
            String repeat = (String)retMap.get("repeat");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sysDoctorId", doctorId);
            map.put("locationId", locationId);
            map.put("dateList", dateList);
            map.put("status", "1");
            map.put("time", time);
            List<RegisterServiceVo> rsList = this.registerServiceDao.getRegisterListByInfo(map);
            RegisterServiceVo isRepeatvo = null;
            for (RegisterServiceVo rsvo : rsList) {
                if (!date.equals(DateUtils.DateToStr((Date)rsvo.getDate(), (String)"date"))) continue;
                if (!"0".equals(rsvo.getRepeatFlag()) && !"1".equals(rsvo.getRepeatFlag())) {
                    isRepeatvo = rsvo;
                    continue;
                }
                if ("yes".equals(operRepeat)) continue;
                isRepeatvo = rsvo;
            }
            if (isRepeatvo != null) {
                sb.append(DateUtils.DateToStr((Date)isRepeatvo.getDate(), (String)"date") + DateUtils.DateToStr((Date)isRepeatvo.getBeginTime(), (String)"time") + "\u7684\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6");
                continue;
            }
            for (RegisterServiceVo rsvo : rsList) {
                if (!"0".equals(rsvo.getRepeatFlag()) && !"1".equals(rvo.getRepeatFlag())) continue;
                sb.append(DateUtils.DateToStr((Date)rsvo.getDate(), (String)"date") + DateUtils.DateToStr((Date)rsvo.getBeginTime(), (String)"time") + "\u7684\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6");
            }
        }
        return sb.toString();
    }

    public Map findRegisterList(Page<RegisterServiceVo> page, RegisterServiceVo registerServiceVo) {
        registerServiceVo.setStatus("0");
        Page<RegisterServiceVo> pageList = this.registerServiceDao.findRegisterList(page, registerServiceVo);
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        for (RegisterServiceVo temp : pageList.getList()) {
            if ("0".equals(temp.getRelationType())) {
                temp.setRelationType("\u516c\u7acb\u533b\u9662");
                continue;
            }
            if ("1".equals(temp.getRelationType())) {
                temp.setRelationType("\u516c\u7acb\u533b\u9662");
                continue;
            }
            if (!"2".equals(temp.getRelationType())) continue;
            temp.setRelationType("\u5408\u4f5c\u673a\u6784");
        }
        ArrayList<String> illLevel1List = new ArrayList<String>();
        List p = this.illnessInfoService.getFirstIllnessList();
        if (p != null) {
            for (IllnessVo vo : p) {
                illLevel1List.add(vo.getLevel_1());
            }
        }
        Page hpage = this.hospitalInfoService.findPageAllHospital(new Page());
        List tempList = hpage.getList();
        ArrayList<HospitalVo> hospitalList = new ArrayList<HospitalVo>();
        for (HashMap tempMap : tempList) {
            HospitalVo vo = new HospitalVo();
            vo.setId((String)tempMap.get("id"));
            vo.setName((String)tempMap.get("name"));
            hospitalList.add(vo);
        }
        map.put("illLevel1List", illLevel1List);
        map.put("hospital", hospitalList);
        map.put("page", (ArrayList<Object>)pageList);
        return map;
    }

    public Page<RegisterServiceVo> findEffectiveRegisterList(Page<RegisterServiceVo> page, RegisterServiceVo registerServiceVo) {
        return this.registerServiceDao.findNoDelRegisterList(page, registerServiceVo);
    }

    public List<RegisterServiceVo> findNoDelRegisterAppointmentList(RegisterServiceVo vo) {
        return this.registerServiceDao.findNoDelRegisterAppointmentList(vo);
    }

    public Page<RegisterServiceVo> findWillNoRegisterList(Page<RegisterServiceVo> page) {
        Page<RegisterServiceVo> pageList = this.registerServiceDao.findWillNoRegisterList(page);
        return pageList;
    }

    public RegisterServiceVo getRegisterByInfo(String register) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sysRegisterId", register);
        RegisterServiceVo vo = this.registerServiceDao.getRegisterByInfo(map);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> addRegister(RegisterServiceVo registerServiceVo, List<String> timeList, String date, String operInterval) {
        Class<RegisterServiceImpl> clazz = RegisterServiceImpl.class;
        synchronized (RegisterServiceImpl.class) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, String> retmap = new HashMap<String, String>();
            ArrayList<String> insertDateList = new ArrayList<String>();
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add("0");
            statusList.add("1");
            map.put("sysDoctorId", registerServiceVo.getSysDoctorId());
            map.put("statusList", statusList);
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            String weekday = c.get(7) + "";
            if ("no".equals(operInterval)) {
                map.put("date", date);
            } else if ("1".equals(operInterval) || "0".equals(operInterval)) {
                insertDateList.add(date);
                for (int i = 0; i < 3; ++i) {
                    c.add(6, 7);
                    if ("1".equals(operInterval) && (i == 0 || i == 2)) continue;
                    Date today = c.getTime();
                    insertDateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                }
                map.put("dateList", insertDateList);
            }
            StringBuffer sb = new StringBuffer("");
            int countRepeat = 0;
            int countUsed = 0;
            int countRegister = 0;
            for (String time : timeList) {
                ArrayList<RegisterServiceVo> insertFlagList = new ArrayList<RegisterServiceVo>();
                ArrayList<RegisterServiceVo> updateList = new ArrayList<RegisterServiceVo>();
                ArrayList<String> updateDateList = new ArrayList<String>();
                map.put("time", time);
                List<RegisterServiceVo> rsvlist = this.registerServiceDao.getRegisterListByInfo(map);
                for (RegisterServiceVo vo : rsvlist) {
                    insertFlagList.add(vo);
                    if (!vo.getLocationId().equals(registerServiceVo.getLocationId()) || !"0".equals(vo.getStatus())) continue;
                    updateDateList.add(DateUtils.DateToStr((Date)vo.getDate(), (String)"date"));
                    updateList.add(vo);
                }
                if (insertFlagList.size() == 0) {
                    if ("no".equals(operInterval)) {
                        registerServiceVo.setRepeatFlag("2");
                        this.insertRegister(registerServiceVo, time, date);
                    } else {
                        registerServiceVo.setRepeatFlag(operInterval);
                        RegisterTemplateServiceVo rtsv = this.operTemplate("get", registerServiceVo, weekday, date, time, operInterval);
                        if (rtsv != null) {
                            if ("1".equals(rtsv.getRepeatInterval()) && "1".equals(operInterval)) {
                                for (String dt : insertDateList) {
                                    if (updateDateList.contains(dt)) continue;
                                    this.insertRegister(registerServiceVo, time, dt);
                                }
                                this.operTemplate("update", registerServiceVo, weekday, date, time, operInterval);
                            } else {
                                ++countRepeat;
                                if ("1".equals(rtsv.getRepeatInterval())) {
                                    sb.append(time + "\u7684\u53f7\u6e90\u5df2\u88ab\u8bbe\u7f6e\u9694\u5468\u91cd\u590d\uff01\n");
                                } else {
                                    sb.append(time + "\u7684\u53f7\u6e90\u5df2\u88ab\u8bbe\u7f6e\u6bcf\u5468\u91cd\u590d\uff01\n");
                                }
                            }
                        } else {
                            for (String dt : insertDateList) {
                                if (updateDateList.contains(dt)) continue;
                                this.insertRegister(registerServiceVo, time, dt);
                            }
                            this.operTemplate("add", registerServiceVo, weekday, date, time, operInterval);
                        }
                    }
                } else {
                    for (RegisterServiceVo vo : insertFlagList) {
                        if ("1".equals(vo.getStatus())) {
                            ++countRegister;
                            sb.append(DateUtils.DateToStr((Date)vo.getDate(), (String)"date") + "(" + DateUtils.DateToStr((Date)vo.getBeginTime(), (String)"time") + ")\u7684\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6\n");
                            continue;
                        }
                        ++countUsed;
                        sb.append(DateUtils.DateToStr((Date)vo.getDate(), (String)"date") + "(" + DateUtils.DateToStr((Date)vo.getBeginTime(), (String)"time") + ")\u7684\u53f7\u6e90\u5df2\u88ab\u5360\u7528\n");
                    }
                }
                if (!"".equals(sb.toString())) continue;
                for (RegisterServiceVo rsv : updateList) {
                    this.update(rsv.getId(), registerServiceVo.getPrice().floatValue(), registerServiceVo.getServiceType());
                }
            }
            StringBuffer sbf = new StringBuffer("");
            if (countRepeat != 0) {
                sbf.append(countRepeat + "\u4e2a\u53f7\u6e90\u5df2\u88ab\u8bbe\u7f6e\u91cd\u590d<br/>");
            }
            if (countRegister != 0) {
                sbf.append(countRegister + "\u4e2a\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6<br/>");
            }
            if (countUsed != 0) {
                sbf.append(countUsed + "\u4e2a\u53f7\u6e90\u5df2\u88ab\u5360\u7528<br/>");
            }
            retmap.put("doctor", sbf.toString());
            retmap.put("backend", sb.toString());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return retmap;
        }
    }

    public void updateRegister(RegisterServiceVo registerServiceVo, String time, String date, String operRepeat) {
        Map<String, Object> retMap = this.getDateList(registerServiceVo, date, time, operRepeat);
        List insertDateList = (List)retMap.get("dateList");
        String repeat = (String)retMap.get("repeat");
        if ("yes".equals(operRepeat) && "yes".equals(repeat)) {
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            String weekday = c.get(7) + "";
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add("0");
            statusList.add("1");
            map.put("sysDoctorId", registerServiceVo.getSysDoctorId());
            map.put("statusList", statusList);
            map.put("time", time);
            map.put("dateList", insertDateList);
            List<RegisterServiceVo> rsvlist = this.registerServiceDao.getRegisterListByInfo(map);
            for (RegisterServiceVo vo : rsvlist) {
                this.update(vo.getId(), registerServiceVo.getPrice().floatValue(), registerServiceVo.getServiceType());
            }
            this.operTemplate("update", registerServiceVo, weekday, date, time, null);
        } else {
            this.update(registerServiceVo.getId(), registerServiceVo.getPrice().floatValue(), registerServiceVo.getServiceType());
        }
    }

    public int deleteRegisters(RegisterServiceVo registerServiceVo, List<String> timeList, String date, String operRepeat, String deleteBy) {
        int count = 0;
        Random r = new Random();
        for (String time : timeList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List dateList = new ArrayList();
            Map<String, Object> retMap = this.getDateList(registerServiceVo, date, time, operRepeat);
            dateList = (List)retMap.get("dateList");
            String repeat = (String)retMap.get("repeat");
            map.put("dateList", dateList);
            map.put("sysDoctorId", registerServiceVo.getSysDoctorId());
            map.put("locationId", registerServiceVo.getLocationId());
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add("0");
            statusList.add("1");
            map.put("statusList", statusList);
            map.put("time", time);
            List<RegisterServiceVo> rsList = this.registerServiceDao.getRegisterListByInfo(map);
            RegisterServiceVo isRepeatvo = null;
            for (RegisterServiceVo rvo : rsList) {
                if (!date.equals(DateUtils.DateToStr((Date)rvo.getDate(), (String)"date"))) continue;
                if (!"0".equals(rvo.getRepeatFlag()) && !"1".equals(rvo.getRepeatFlag())) {
                    isRepeatvo = rvo;
                    continue;
                }
                if ("yes".equals(operRepeat)) continue;
                isRepeatvo = rvo;
            }
            if (isRepeatvo != null) {
                HashMap<String, Object> executeMap = new HashMap<String, Object>();
                if ("1".equals(isRepeatvo.getStatus())) {
                    HashMap<String, Object> executeMap1 = new HashMap<String, Object>();
                    executeMap1.put("registerId", isRepeatvo.getId());
                    HashMap<String, Object> patientRegister = this.patientRegisterServiceDao.getPatientRegisterInfo(executeMap1);
                    String patientRegisterId = (String)patientRegister.get("id");
                    executeMap.put("id", patientRegisterId);
                    executeMap.put("keep", "1");
                    executeMap.put("reason", "\u533b\u751f\u505c\u8bca");
                    executeMap.put("deleteBy", deleteBy);
                    this.patientRegisterServiceDao.updatePatientRegisterStatusCancelById(executeMap);
                    PatientRegisterServiceVo pVo = new PatientRegisterServiceVo();
                    DoctorHospitalRelationVo dhVo = new DoctorHospitalRelationVo();
                    pVo.setId(patientRegisterId);
                    dhVo = this.patientRegisterServiceDao.getRegisterAttributeOfHospital(pVo);
                    String relationType = pVo.getRelationType();
                    if (!relationType.equals("2")) {
                        this.memberService.updateMemberLeftTimes(patientRegister.get("member_service_id") + "", "1");
                    }
                    LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000027", (String)("\u8ba2\u5355\u4e3b\u952e" + patientRegisterId + ":" + date));
                    try {
                        executeMap.put("patient_register_service_id", patientRegisterId);
                        this.orderMessageService.sendMessage(executeMap, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.insertNotification(patientRegisterId);
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(isRepeatvo.getBeginTime());
                calendar.add(13, r.nextInt(58) + 1);
                executeMap.put("registerId", isRepeatvo.getId());
                executeMap.put("updateDate", new Date());
                executeMap.put("beginTime", calendar.getTime());
                count += this.registerServiceDao.updateSysRegisterStatusCancel(executeMap);
                LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000028", (String)("\u8ba2\u5355\u4e3b\u952e" + isRepeatvo.getId() + ":" + date));
            } else {
                for (RegisterServiceVo rvo : rsList) {
                    if (!"0".equals(rvo.getRepeatFlag()) && !"1".equals(rvo.getRepeatFlag())) continue;
                    HashMap<String, Object> executeMap = new HashMap<String, Object>();
                    if ("1".equals(rvo.getStatus())) {
                        HashMap<String, Object> executeMap1 = new HashMap<String, Object>();
                        executeMap1.put("registerId", rvo.getId());
                        HashMap<String, Object> patientRegister = this.patientRegisterServiceDao.getPatientRegisterInfo(executeMap1);
                        String patientRegisterId = (String)patientRegister.get("id");
                        executeMap.put("id", patientRegisterId);
                        executeMap.put("keep", "1");
                        executeMap.put("reason", "\u533b\u751f\u505c\u8bca");
                        executeMap.put("deleteBy", deleteBy);
                        this.patientRegisterServiceDao.updatePatientRegisterStatusCancelById(executeMap);
                        PatientRegisterServiceVo pVo = new PatientRegisterServiceVo();
                        DoctorHospitalRelationVo dhVo = new DoctorHospitalRelationVo();
                        pVo.setId(patientRegisterId);
                        dhVo = this.patientRegisterServiceDao.getRegisterAttributeOfHospital(pVo);
                        String relationType = dhVo.getRelationType();
                        if (!relationType.equals("2")) {
                            this.memberService.updateMemberLeftTimes((String)patientRegister.get("member_service_id"), "1");
                        }
                        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000027", (String)("\u8ba2\u5355\u4e3b\u952e" + patientRegisterId + ":" + date));
                        try {
                            executeMap.put("patient_register_service_id", patientRegisterId);
                            this.orderMessageService.sendMessage(executeMap, false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.insertNotification(patientRegisterId);
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(rvo.getBeginTime());
                    calendar.add(13, r.nextInt(58) + 1);
                    executeMap.put("registerId", rvo.getId());
                    executeMap.put("updateDate", new Date());
                    executeMap.put("beginTime", calendar.getTime());
                    count += this.registerServiceDao.updateSysRegisterStatusCancel(executeMap);
                    LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000028", (String)("\u8ba2\u5355\u8868\u4e3b\u952e" + rvo.getId() + ":" + date));
                }
            }
            if (!"yes".equals(operRepeat) || !"yes".equals(repeat) || isRepeatvo != null) continue;
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            String weekday = c.get(7) + "";
            this.operTemplate("del", registerServiceVo, weekday, date, time, null);
        }
        return count;
    }

    public void insertRegister(RegisterServiceVo registerServiceVo, String time, String date) {
        HashMap<String, Object> doctorInfo = new HashMap<String, Object>();
        Date begin_time = DateUtils.StrToDate((String)time, (String)"time");
        Date end_time = new Date(begin_time.getTime() + 900000L);
        doctorInfo.put("id", IdGen.uuid());
        doctorInfo.put("doctorId", registerServiceVo.getSysDoctorId());
        doctorInfo.put("sys_hospital_id", registerServiceVo.getSysHospitalId());
        doctorInfo.put("date", date);
        doctorInfo.put("begin_time", begin_time);
        doctorInfo.put("end_time", end_time);
        doctorInfo.put("price", registerServiceVo.getPrice());
        doctorInfo.put("deposit", "50");
        doctorInfo.put("service_type", registerServiceVo.getServiceType());
        doctorInfo.put("create_date", new Date());
        doctorInfo.put("locationId", registerServiceVo.getLocationId());
        doctorInfo.put("status", "0");
        doctorInfo.put("repeatFlag", registerServiceVo.getRepeatFlag());
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("0");
        statusList.add("1");
        queryMap.put("statusList", statusList);
        queryMap.put("date", date);
        queryMap.put("time", begin_time);
        queryMap.put("sysDoctorId", registerServiceVo.getSysDoctorId());
        List<RegisterServiceVo> rlist = this.registerServiceDao.getRegisterListByInfo(queryMap);
        if (rlist.size() == 0) {
            this.registerServiceDao.insertSysRegisterServiceExecute(doctorInfo);
        }
    }

    public HashMap<String, Object> getRegisterServiceInfo(String registerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registerId", registerId);
        map = this.registerServiceDao.getSysRegisterServiceInfo(map);
        return map;
    }

    public Date getOrderCreateDate(String patientRegistId) {
        HashMap<String, String> executeMap = new HashMap<String, String>();
        executeMap.put("patientRegisterService", patientRegistId);
        List<PatientRegisterServiceVo> patientList = this.patientRegisterServiceDao.findPageRegisterServiceByPatient(executeMap);
        if (patientList.size() > 0) {
            Date orderCreateDate = patientList.get(0).getCreateDate();
            return orderCreateDate;
        }
        return null;
    }

    public void deleteRegister(String id) {
        Random r = new Random();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        RegisterServiceVo vo = this.registerServiceDao.getRegisterById(map);
        HashMap<String, Object> excute = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(vo.getBeginTime());
        calendar.add(13, r.nextInt(58) + 1);
        excute.put("registerId", id);
        excute.put("updateDate", new Date());
        excute.put("beginTime", calendar.getTime());
        this.registerServiceDao.updateSysRegisterStatusCancel(excute);
    }

    public List<RegisterTemplateServiceVo> getRegisterTemplate(RegisterTemplateServiceVo registerTemplate) {
        return this.registerTemplateServiceDao.getRegisterTemplate(registerTemplate);
    }

    public List<Date> getDatesWithRegisters(String doctorId, String locationId, Date from, Integer days) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("doctorId", doctorId);
        params.put("locationId", locationId);
        params.put("from", DateUtils.DateToStr((Date)from, (String)"date"));
        Calendar c = Calendar.getInstance();
        c.setTime(from);
        c.add(5, 7);
        params.put("to", DateUtils.DateToStr((Date)c.getTime(), (String)"date"));
        List<Date> dates = this.registerServiceDao.findDatesWithRegisters(params);
        return dates;
    }

    public List<RegisterServiceVo> getRegisterListByInfo(Map<String, Object> params) {
        return this.registerServiceDao.getRegisterListByInfo(params);
    }

    public void generateDoctorDataVoList(List<HashMap<String, Object>> list, List<HashMap<String, Object>> doctorDataVoList) {
        if (list != null && !list.isEmpty()) {
            for (Map map : list) {
                HashMap dataMap = new HashMap();
                dataMap.put("doctorId", map.get("id"));
                dataMap.put("doctorName", map.get("doctorName"));
                dataMap.put("hospitalName", StringUtils.isNotNull((String)((String)map.get("ascriptionHospitalName"))) ? map.get("ascriptionHospitalName") : map.get("hospital"));
                dataMap.put("begin_time", map.get("begin_time"));
                dataMap.put("position1", map.get("position1"));
                dataMap.put("position2", map.get("position2"));
                List<HashMap<String, Object>> doctorInfo = this.registerServiceDao.getDoctorVisitInfoById((String)map.get("id"));
                ArrayList formatInfo = new ArrayList();
                for (Map map2 : doctorInfo) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String latest_time = sdf.format((Date)map2.get("latest_time"));
                    String pat1 = "yyyy-MM-dd HH:mm";
                    String pat2 = "HH:mm";
                    try {
                        SimpleDateFormat sdf1 = new SimpleDateFormat(pat1);
                        SimpleDateFormat sdf2 = new SimpleDateFormat(pat2);
                        Date d = sdf1.parse(latest_time);
                        info.put("latest_time", sdf2.format(d));
                        info.put("availableDate", (String)map2.get("availableDate"));
                        info.put("begin_time", (String)map2.get("begin_time"));
                        info.put("name", (String)map2.get("name"));
                        info.put("position", (String)map2.get("position"));
                        info.put("date", (String)map2.get("date"));
                        info.put("location", (String)map2.get("location"));
                        info.put("location_id", (String)map2.get("location_id"));
                        info.put("available_time", (String)map2.get("available_time"));
                        info.put("service_type", (String)map2.get("service_type"));
                        info.put("shot_time", (String)map2.get("shot_time"));
                        formatInfo.add(info);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                dataMap.put("visitInfo", formatInfo);
                String doctorId = (String)map.get("id");
                String string = (String)map.get("sysHospitalId");
                Object departmentLevel1Obj = map.get("department_level1");
                dataMap.put("expertise", this.doctorInfoService.getDoctorExpertiseById(doctorId, string, departmentLevel1Obj == null ? null : (String)departmentLevel1Obj));
                Object departmentLevel2Obj = map.get("department_level2");
                boolean departmentLevel2IsEmpty = StringUtils.isEmpty((CharSequence)(departmentLevel2Obj == null ? "" : (String)departmentLevel2Obj));
                String departmentFullName = departmentLevel1Obj == null ? null : departmentLevel1Obj + (departmentLevel2IsEmpty ? "" : "  " + departmentLevel2Obj);
                dataMap.put("departmentFullName", departmentFullName);
                dataMap.put("career_time", String.valueOf((new Date().getTime() - ((Date)map.get("careerTime")).getTime()) / 86400000L / 365L + 1L));
                dataMap.put("fans_number", map.get("fansNumber"));
                if (map.get("availableDate") != null) {
                    Date date = new Date();
                    SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                    String value = df1.format(date);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    Date date1 = null;
                    Date date2 = (Date)map.get("availableDate");
                    try {
                        date1 = df.parse(value);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    long time1 = date1.getTime();
                    long time2 = date2.getTime();
                    long newValue = time2 - time1;
                    long day = newValue / 86400000L;
                    if (day >= 0L) {
                        dataMap.put("available_time", day);
                    } else {
                        dataMap.put("available_time", "-1");
                    }
                } else {
                    dataMap.put("available_time", "-1");
                }
                doctorDataVoList.add(dataMap);
            }
        }
    }

    private Map<String, Object> compareRegisterTime(String doctorId, String date, String locationId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysDoctorId", doctorId);
        map.put("date", date);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("0");
        statusList.add("1");
        map.put("statusList", statusList);
        List<RegisterServiceVo> temp = this.registerServiceDao.getRegisterListByInfo(map);
        ArrayList<String> distimeList = new ArrayList<String>();
        ArrayList<String> beginTimeList = new ArrayList<String>();
        ArrayList<String> comList = new ArrayList<String>();
        String time = new String();
        Object price = null;
        String serverType = "";
        for (RegisterServiceVo rsv : temp) {
            time = DateUtils.DateToStr((Date)rsv.getBeginTime(), (String)"time");
            if (rsv.getLocationId().equals(locationId)) {
                if ("0".equals(rsv.getStatus())) {
                    if ("0".equals(rsv.getRepeatFlag()) || "1".equals(rsv.getRepeatFlag())) {
                        beginTimeList.add("3S|X" + time + "S|X" + rsv.getRepeatFlag());
                    } else {
                        beginTimeList.add("6S|X" + time);
                    }
                }
                if ("1".equals(rsv.getStatus())) {
                    if ("0".equals(rsv.getRepeatFlag()) || "1".equals(rsv.getRepeatFlag())) {
                        beginTimeList.add("5S|X" + time + "S|X" + rsv.getRepeatFlag());
                    } else {
                        beginTimeList.add("4S|X" + time);
                    }
                }
                if (!"0".equals(rsv.getRepeatFlag()) && !"1".equals(rsv.getRepeatFlag())) continue;
                comList.add(time);
                continue;
            }
            distimeList.add(time);
        }
        map.put("price", price);
        map.put("serverType", serverType);
        map.put("success", "success");
        map.put("timeList", beginTimeList);
        map.put("distimeList", distimeList);
        return map;
    }

    private Map<String, Object> getDateList(RegisterServiceVo vo, String date, String time, String repeat) {
        ArrayList<String> dateList = new ArrayList<String>();
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        dateList.add(date);
        if (!"no".equals(repeat) && repeat != null && !"".equals(repeat)) {
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            String weekday = c.get(7) + "";
            RegisterTemplateServiceVo rvo = this.operTemplate("get", vo, weekday, date, time, null);
            if (rvo != null) {
                Date today;
                int i;
                retmap.put("repeat", "yes");
                if ("0".equals(rvo.getRepeatInterval())) {
                    c.setTime(temp);
                    for (i = 0; i < 6; ++i) {
                        c.add(6, 7);
                        today = c.getTime();
                        dateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                    }
                }
                if ("1".equals(rvo.getRepeatInterval())) {
                    c.setTime(temp);
                    for (i = 0; i < 3; ++i) {
                        c.add(6, 14);
                        today = c.getTime();
                        dateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                    }
                }
            } else {
                c.setTime(temp);
                for (int i = 0; i < 6; ++i) {
                    c.add(6, 7);
                    Date today = c.getTime();
                    dateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                }
            }
        }
        retmap.put("dateList", dateList);
        return retmap;
    }

    public Map<String, Object> getDoctorAppointments4Doctor(Map<String, Object> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String doctorId = (String)params.get("doctorId");
        String dateStr = (String)params.get("date");
        Date date = DateUtils.StrToDate((String)dateStr, (String)"date");
        String DateToStr = DateUtils.DateToStr((Date)date);
        int week = DateUtils.dayForWeek((String)DateToStr);
        String dayWeek = DateUtils.getDayWeek((int)week);
        HashMap<String, Object> dataInfo = new HashMap<String, Object>();
        dataInfo.put("doctorId", doctorId);
        dataInfo.put("date", date);
        String locationId = (String)params.get("locationId");
        dataInfo.put("location_id", locationId);
        StringBuffer bf = new StringBuffer();
        bf.append(DateToStr.substring(0, 10));
        bf.append("  " + dayWeek).toString();
        response.put("date", bf);
        dataInfo.put("user", "doctor");
        List<HashMap<String, Object>> appointmentVoList = this.registerServiceDao.findAllAppointmentInfoByDoctor(dataInfo);
        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000030", (String)("doctorId:" + doctorId + "date:" + date));
        ArrayList<String> locationIdList = new ArrayList<String>();
        ArrayList dataMapList = new ArrayList();
        for (Map map : appointmentVoList) {
            String theLocationId = (String)map.get("location_id");
            if (locationIdList.contains(theLocationId)) continue;
            locationIdList.add(theLocationId);
        }
        for (String string : locationIdList) {
            HashMap dataMap = new HashMap();
            ArrayList available_time = new ArrayList();
            for (Map map : appointmentVoList) {
                HashMap<String, Object> timeMap = new HashMap<String, Object>();
                String location_id = (String)map.get("location_id");
                if (string.equals(location_id)) {
                    dataMap.put("hospitalId", map.get("sys_hospital_id"));
                    dataMap.put("hospitalName", map.get("hospitalName"));
                    dataMap.put("location", map.get("location"));
                    dataMap.put("locationId", map.get("location_id"));
                    dataMap.put("price", map.get("price"));
                    dataMap.put("service_type", map.get("service_type"));
                    timeMap.put("register_service_id", map.get("id"));
                    Object beginTime = map.get("begin_time");
                    timeMap.put("begin_time", beginTime);
                    if ("0".equals(map.get("repeatFlag")) || "1".equals(map.get("repeatFlag"))) {
                        timeMap.put("repeat", true);
                    } else {
                        timeMap.put("repeat", false);
                    }
                    timeMap.put("end_time", map.get("end_time"));
                    timeMap.put("status", map.get("status"));
                    if ("1".equals(map.get("status"))) {
                        HashMap<String, Object> ordermap = new HashMap<String, Object>();
                        ordermap.put("registerServiceId", map.get("id"));
                        HashMap<String, Object> map2 = this.patientRegisterServiceDao.getPatientRegisterInfo(ordermap);
                        if (map2 != null) {
                            timeMap.put("illness", map2.get("illness"));
                            timeMap.put("babyName", map2.get("babyName"));
                            timeMap.put("phone", map2.get("phone"));
                            if (map2.get("birthday") != null) {
                                timeMap.put("birthday", DateUtils.DateToStr((Date)((Date)map2.get("birthday")), (String)"date"));
                            }
                        }
                    }
                    available_time.add(timeMap);
                }
                dataMap.put("available_time", available_time);
            }
            dataMapList.add(dataMap);
        }
        response.put("appointmentList", dataMapList);
        return response;
    }

    private RegisterTemplateServiceVo operTemplate(String operType, RegisterServiceVo vo, String weekday, String date, String time, String operInterval) {
        Date lasttoday;
        Calendar c;
        Date temp;
        ArrayList<String> dateList;
        List<RegisterTemplateServiceVo> list;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("get".equals(operType)) {
            map.put("doctorId", vo.getSysDoctorId());
            map.put("weekday", weekday);
            map.put("time", time);
            List<RegisterTemplateServiceVo> list2 = this.registerTemplateServiceDao.getRegisterTemplateList(map);
            for (RegisterTemplateServiceVo rtvo : list2) {
                if ("1".equals(rtvo.getRepeatInterval()) && "1".equals(operInterval)) {
                    ArrayList<String> dateList2 = new ArrayList<String>();
                    dateList2.add(date);
                    Date temp2 = DateUtils.StrToDate((String)date, (String)"date");
                    Calendar c2 = Calendar.getInstance();
                    c2.setTime(temp2);
                    c2.add(6, -14);
                    Date lasttoday2 = c2.getTime();
                    dateList2.add(DateUtils.DateToStr((Date)lasttoday2, (String)"date"));
                    if (!dateList2.contains(DateUtils.DateToStr((Date)rtvo.getUpdateDate(), (String)"date"))) continue;
                    return rtvo;
                }
                return rtvo;
            }
            return null;
        }
        if ("update".equals(operType) && time != null && !"".equals(time)) {
            map.put("price", vo.getPrice());
            map.put("serverType", vo.getServiceType());
            map.put("doctorId", vo.getSysDoctorId());
            map.put("locationId", vo.getLocationId());
            map.put("weekday", weekday);
            map.put("time", time);
            list = this.registerTemplateServiceDao.getRegisterTemplateList(map);
            if (list != null && list.size() != 0 && "1".equals(list.get(0).getRepeatInterval())) {
                dateList = new ArrayList();
                dateList.add(date);
                temp = DateUtils.StrToDate((String)date, (String)"date");
                c = Calendar.getInstance();
                c.setTime(temp);
                c.add(6, -14);
                lasttoday = c.getTime();
                dateList.add(DateUtils.DateToStr((Date)lasttoday, (String)"date"));
                map.put("updateDateList", dateList);
            }
            this.registerTemplateServiceDao.updateRegisterTemplateByInfo(map);
        }
        if ("add".equals(operType)) {
            map.put("doctorId", vo.getSysDoctorId());
            map.put("locationId", vo.getLocationId());
            map.put("weekday", weekday);
            map.put("price", vo.getPrice());
            map.put("serverType", vo.getServiceType());
            map.put("status", 1);
            map.put("hospitalId", vo.getSysHospitalId());
            map.put("createDate", new Date());
            map.put("updateDate", date);
            map.put("interval", operInterval);
            map.put("time", time);
            this.registerTemplateServiceDao.saveRegisterTemplate(map);
        }
        if ("del".equals(operType) && time != null && !"".equals(time)) {
            map.put("doctorId", vo.getSysDoctorId());
            map.put("locationId", vo.getLocationId());
            map.put("weekday", weekday);
            map.put("time", time);
            list = this.registerTemplateServiceDao.getRegisterTemplateList(map);
            if (list != null && list.size() != 0 && "1".equals(list.get(0).getRepeatInterval())) {
                dateList = new ArrayList<String>();
                dateList.add(date);
                temp = DateUtils.StrToDate((String)date, (String)"date");
                c = Calendar.getInstance();
                c.setTime(temp);
                c.add(6, -14);
                lasttoday = c.getTime();
                dateList.add(DateUtils.DateToStr((Date)lasttoday, (String)"date"));
                map.put("updateDateList", dateList);
            }
            this.registerTemplateServiceDao.deleteRegisterTemplateByinfo(map);
        }
        return null;
    }

    private void update(String id, float price, String serviceType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("price", Float.valueOf(price));
        map.put("serverType", serviceType);
        map.put("updateDate", new Date());
        this.registerServiceDao.updateRegisterService(map);
    }

    private void insertNotification(String patientRegisterId) {
        Notification notification = new Notification();
        notification.setMessage("\u53d6\u6d88\u53f7\u6e90\u5bfc\u81f4\u8ba2\u5355\u88ab\u53d6\u6d88");
        User user = UserUtils.getUser();
        notification.setCreatedBy(user == null ? null : user.getId());
        notification.setCreatedTime(new Date());
        notification.setRelatedId(patientRegisterId);
        notification.setStatus(Notification.STATUS_INITIAL);
        notification.setType(Notification.TYPE_ORDER_REMOVED);
        notification.setUpdatedTime(new Date());
        this.notificationService.saveNotification(notification);
    }

    private void modifyRegisterTemplate(RegisterTemplateServiceVo vo, String date, List<String> timeList) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(DateUtils.StrToDate((String)date, (String)"date"));
        String weekday = c.get(7) + "";
        JSONArray ja = new JSONArray();
        ja.addAll(timeList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("doctorId", vo.getDoctorId());
        map.put("locationId", vo.getLocationId());
        map.put("weekday", weekday);
        List<RegisterTemplateServiceVo> list = this.registerTemplateServiceDao.getRegisterTemplateList(map);
        if (list.size() == 0) {
            if (timeList.size() != 0) {
                map.put("price", vo.getPrice());
                map.put("serverType", vo.getServerType());
                map.put("time", ja.toString());
                map.put("status", 1);
                map.put("hospitalId", vo.getHospitalId());
                map.put("createDate", new Date());
                map.put("updateDate", date);
                map.put("interval", vo.getRepeatInterval());
                this.registerTemplateServiceDao.saveRegisterTemplate(map);
            }
        } else if (timeList.size() == 0) {
            this.registerTemplateServiceDao.deleteRegisterTemplateByinfo(map);
        } else {
            map.put("price", vo.getPrice());
            map.put("serverType", vo.getServerType());
            map.put("time", ja.toString());
            map.put("updateDate", date);
            map.put("interval", vo.getRepeatInterval());
            this.registerTemplateServiceDao.updateRegisterTemplateByInfo(map);
        }
    }

    private void insertMonitor(String register_no, String type, String status) {
        HashMap<String, String> monitorMap = new HashMap<String, String>();
        monitorMap.put("id", IdGen.uuid());
        monitorMap.put("register_no", register_no);
        monitorMap.put("status", status);
        monitorMap.put("types", type);
        this.messageService.insertMonitorExecute(monitorMap);
    }

    private void generateDoctorDataVoListByDate(List<HashMap<String, Object>> list, List<HashMap<String, Object>> doctorDataVoList, Date dateInfo) {
        if (list != null && !list.isEmpty()) {
            for (Map map : list) {
                HashMap dataMap = new HashMap();
                dataMap.put("doctorId", map.get("id"));
                dataMap.put("doctorName", map.get("doctorName"));
                dataMap.put("hospitalName", map.get("hospital"));
                dataMap.put("begin_time", map.get("begin_time"));
                dataMap.put("position1", map.get("position1"));
                dataMap.put("position2", map.get("position2"));
                HashMap<String, Object> dataInputMap = new HashMap<String, Object>();
                dataInputMap.put("doctorId", map.get("id"));
                dataInputMap.put("date", dateInfo);
                List<HashMap<String, Object>> doctorInfo = this.registerServiceDao.getDoctorVisitInfoByIdAndDate(dataInputMap);
                ArrayList<Map> formatInfo = new ArrayList<Map>();
                for (Map map2 : doctorInfo) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String latest_time = sdf.format((Date)map2.get("latest_time"));
                    String pat1 = "yyyy-MM-dd HH:mm";
                    String pat2 = "HH:mm";
                    try {
                        SimpleDateFormat sdf1 = new SimpleDateFormat(pat1);
                        SimpleDateFormat sdf2 = new SimpleDateFormat(pat2);
                        Date d = null;
                        d = sdf1.parse(latest_time);
                        map2.put("latest_time", sdf2.format(d));
                        formatInfo.add(map2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                dataMap.put("visitInfo", formatInfo);
                String doctorId = (String)map.get("id");
                String string = (String)map.get("sysHospitalId");
                dataMap.put("expertise", this.doctorInfoService.getDoctorExpertiseById(doctorId, string, null));
                dataMap.put("departmentFullName", this.hospitalInfoService.getDepartmentFullName(doctorId, string));
                dataMap.put("career_time", String.valueOf((new Date().getTime() - ((Date)map.get("careerTime")).getTime()) / 86400000L / 365L + 1L));
                dataMap.put("fans_number", map.get("fansNumber"));
                HashMap<String, Object> recentlyDateMap = this.findRecentlyDateAppDate((String)map.get("id"));
                if (recentlyDateMap != null && recentlyDateMap.get("availableDate") != null) {
                    Date date = new Date();
                    SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                    String value = df1.format(date);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    Date date1 = null;
                    Date date2 = (Date)recentlyDateMap.get("availableDate");
                    try {
                        date1 = df.parse(value);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    long time1 = date1.getTime();
                    long time2 = date2.getTime();
                    long newValue = time2 - time1;
                    long day = newValue / 86400000L;
                    if (day >= 0L) {
                        dataMap.put("available_time", day);
                    } else {
                        dataMap.put("available_time", "-1");
                    }
                } else {
                    dataMap.put("available_time", "-1");
                }
                doctorDataVoList.add(dataMap);
            }
        }
    }

    public Map<String, Object> GetDoctorVisitInfoByLocation(Map<String, Object> params) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String doctorId = (String)params.get("doctorId");
        String hospitalName = (String)params.get("hospitalName");
        String location_id = (String)params.get("location_id");
        String status = (String)params.get("status");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("doctorId", doctorId);
        data.put("hospitalName", hospitalName);
        data.put("location_id", location_id);
        data.put("status", status);
        List<HashMap<String, Object>> doctorVisitInfo = this.getDoctorVisitInfoByLocation(data);
        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000031", (String)("doctorId:" + doctorId + "location_id:" + location_id));
        ArrayList visitInfo = new ArrayList();
        for (Map map : doctorVisitInfo) {
            HashMap dataMap = new HashMap();
            dataMap.put("date", map.get("date"));
            visitInfo.add(dataMap);
        }
        response.put("dateList", visitInfo);
        if (doctorVisitInfo != null && doctorVisitInfo.size() > 0) {
            response.put("kindlyReminder", doctorVisitInfo.get(0).get("kindlyReminder"));
        }
        return response;
    }

    public String getVisitTimeById(Map map) {
        return this.registerServiceDao.getVisitTimeById(map);
    }

    public List<HashMap<String, Object>> getDoctorVisitInfoById(String id) {
        return this.registerServiceDao.getDoctorVisitInfoById(id);
    }

    public List<HashMap<String, Object>> getDoctorVisitInfoByIdAndDate(HashMap<String, Object> map) {
        return this.registerServiceDao.getDoctorVisitInfoByIdAndDate(map);
    }

    public List<HashMap<String, Object>> getDoctorVisitInfo(String id) {
        return this.registerServiceDao.getDoctorVisitInfo(id);
    }

    public RegisterServiceVo getRegisterById(Map map) {
        return this.registerServiceDao.getRegisterById(map);
    }

    public void batchInsertRegister(List<HashMap<String, Object>> excuteList) {
        this.registerServiceDao.batchInsertRegister(excuteList);
    }

    public List<RegisterTemplateServiceVo> getRegisterTemplateList(Map<String, Object> executeMap) {
        return this.registerTemplateServiceDao.getRegisterTemplateList(executeMap);
    }

    public void updateRegisterTemplateByInfo(Map<String, Object> executeMap) {
        this.registerTemplateServiceDao.updateRegisterTemplateByInfo(executeMap);
    }

    public int findDoctorRegisterServiceByData(HashMap<String, Object> hashMap) {
        return this.registerServiceDao.findDoctorRegisterServiceByData(hashMap);
    }

    public HashMap<String, Object> getCooperationHospitalTypeBySrsId(String register_service_id) {
        return this.registerServiceDao.getCooperationHospitalTypeBySrsId(register_service_id);
    }

    public Map<String, Object> getEarliestVisiteInfo(String doctorId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        List<HashMap<String, Object>> doctorInfo = this.registerServiceDao.getDoctorVisitInfoById(doctorId);
        ArrayList formatInfo = new ArrayList();
        for (Map map : doctorInfo) {
            HashMap<String, String> info = new HashMap<String, String>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String latest_time = sdf.format((Date)map.get("latest_time"));
            String pat1 = "yyyy-MM-dd HH:mm";
            String pat2 = "HH:mm";
            try {
                SimpleDateFormat sdf1 = new SimpleDateFormat(pat1);
                SimpleDateFormat sdf2 = new SimpleDateFormat(pat2);
                Date d = sdf1.parse(latest_time);
                info.put("latest_time", sdf2.format(d));
                info.put("availableDate", (String)map.get("availableDate"));
                info.put("begin_time", (String)map.get("begin_time"));
                info.put("name", (String)map.get("name"));
                info.put("position", (String)map.get("position"));
                info.put("date", (String)map.get("date"));
                info.put("location", (String)map.get("location"));
                info.put("location_id", (String)map.get("location_id"));
                info.put("available_time", (String)map.get("available_time"));
                info.put("service_type", (String)map.get("service_type"));
                info.put("shot_time", (String)map.get("shot_time"));
                formatInfo.add(info);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dataMap.put("visitInfo", formatInfo);
        return dataMap;
    }

    public Page<RegisterStoreVo> findCanAppointmentPage(Page<RegisterStoreVo> page, RegisterStoreVo vo) {
        return this.registerStoreDao.findPage(page, vo);
    }
}

