/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.order.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.DateUtils;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.order.dao.RegisterStoreDao;
import com.cxqm.xiaoerke.modules.order.dao.RegisterStoreTemplateDao;
import com.cxqm.xiaoerke.modules.order.entity.RegisterServiceVo;
import com.cxqm.xiaoerke.modules.order.entity.RegisterStoreTemplateVo;
import com.cxqm.xiaoerke.modules.order.entity.RegisterStoreVo;
import com.cxqm.xiaoerke.modules.order.service.RegisterStoreService;
import com.cxqm.xiaoerke.modules.order.service.impl.RegisterServiceImpl;
import com.cxqm.xiaoerke.modules.sys.entity.DoctorLocationVo;
import com.cxqm.xiaoerke.modules.sys.service.DoctorLocationService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class RegisterStoreServiceImpl
implements RegisterStoreService {
    @Autowired
    private RegisterStoreDao registerStoreDao;
    @Autowired
    private DoctorLocationService doctorLocationService;
    @Autowired
    private RegisterStoreTemplateDao registerStoreTemplateDao;

    public Page<RegisterStoreVo> findPage(Page<RegisterStoreVo> page, RegisterStoreVo registerStoreVo) {
        return this.registerStoreDao.findPage(page, registerStoreVo);
    }

    public RegisterStoreVo findByPrimaryKey(String id) {
        if (id != null && !id.equals("")) {
            return this.registerStoreDao.selectByPrimaryKey(id);
        }
        return null;
    }

    private boolean insertRegisterStore(RegisterStoreVo registerStoreVo) {
        if (registerStoreVo != null) {
            registerStoreVo.setId(IdGen.uuid());
            registerStoreVo.setDelFlag("0");
            registerStoreVo.setCreateDate(new Date());
            this.registerStoreDao.insert(registerStoreVo);
            return true;
        }
        return false;
    }

    private boolean insertTemplate(RegisterStoreVo vo, String date, String time, String operInterval) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("doctorId", vo.getSysDoctorId());
        map.put("time", time);
        map.put("doctorId", vo.getSysDoctorId());
        map.put("locationId", vo.getLocationId());
        map.put("price", vo.getPrice());
        map.put("serverType", vo.getServiceType());
        map.put("status", 1);
        map.put("hospitalId", vo.getSysHospitalId());
        map.put("createDate", new Date());
        map.put("updateDate", date);
        map.put("interval", operInterval);
        map.put("weekDay", vo.getWeekDay());
        map.put("repeatFlag", operInterval);
        this.registerStoreTemplateDao.saveRegisterTemplate(map);
        return true;
    }

    private RegisterStoreTemplateVo getTemplate(RegisterStoreVo vo, String weekday, String date, String time, String operInterval) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("doctorId", vo.getSysDoctorId());
        map.put("weekday", weekday);
        map.put("time", time);
        List<RegisterStoreTemplateVo> list = this.registerStoreTemplateDao.getRegisterTemplateList(map);
        for (RegisterStoreTemplateVo rtvo : list) {
            if ("1".equals(rtvo.getRepeatInterval()) && "1".equals(operInterval)) {
                ArrayList<String> dateList = new ArrayList<String>();
                dateList.add(date);
                Date temp = DateUtils.StrToDate((String)date, (String)"date");
                Calendar c = Calendar.getInstance();
                c.setTime(temp);
                c.add(6, -14);
                Date lasttoday = c.getTime();
                dateList.add(DateUtils.DateToStr((Date)lasttoday, (String)"date"));
                if (!dateList.contains(DateUtils.DateToStr((Date)rtvo.getUpdateDate(), (String)"date"))) continue;
                return rtvo;
            }
            return rtvo;
        }
        return null;
    }

    private boolean updateTemplate(RegisterStoreVo vo, String weekDay, String date, String time, String operInterval) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (time == null || "".equals(time)) {
            return false;
        }
        map.put("price", vo.getPrice());
        map.put("serverType", vo.getServiceType());
        map.put("doctorId", vo.getSysDoctorId());
        map.put("locationId", vo.getLocationId());
        map.put("weekday", weekDay);
        map.put("time", time);
        List<RegisterStoreTemplateVo> list = this.registerStoreTemplateDao.getRegisterTemplateList(map);
        if (list != null && list.size() != 0 && "1".equals(list.get(0).getRepeatInterval())) {
            ArrayList<String> dateList = new ArrayList<String>();
            dateList.add(date);
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            c.add(6, -14);
            Date lasttoday = c.getTime();
            dateList.add(DateUtils.DateToStr((Date)lasttoday, (String)"date"));
            map.put("updateDateList", dateList);
        }
        this.registerStoreTemplateDao.updateRegisterTemplateByInfo(map);
        return true;
    }

    private boolean delTemplate(RegisterStoreVo vo, String date, String time, String operInterval) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (time == null || "".equals(time)) {
            return false;
        }
        map.put("price", vo.getPrice());
        map.put("serverType", vo.getServiceType());
        map.put("doctorId", vo.getSysDoctorId());
        map.put("locationId", vo.getLocationId());
        map.put("time", time);
        List<RegisterStoreTemplateVo> list = this.registerStoreTemplateDao.getRegisterTemplateList(map);
        if (list != null && list.size() != 0 && "1".equals(list.get(0).getRepeatInterval())) {
            ArrayList<String> dateList = new ArrayList<String>();
            dateList.add(date);
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            c.add(6, -14);
            Date lasttoday = c.getTime();
            dateList.add(DateUtils.DateToStr((Date)lasttoday, (String)"date"));
            map.put("updateDateList", dateList);
        }
        this.registerStoreTemplateDao.deleteRegisterTemplateByinfo(map);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> addRegister(RegisterStoreVo registerStoreVo, List<String> timeList, String operInterval) {
        Class<RegisterServiceImpl> clazz = RegisterServiceImpl.class;
        synchronized (RegisterServiceImpl.class) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> retmap = new HashMap<String, String>();
            map.put("sysDoctorId", registerStoreVo.getSysDoctorId());
            if (registerStoreVo == null || registerStoreVo.getSysDoctorId() == null || registerStoreVo.getSysDoctorId().equals("")) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return retmap;
            }
            if (timeList == null || timeList.size() == 0) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return retmap;
            }
            if (operInterval == null || operInterval.equals("")) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return retmap;
            }
            for (String timeStr : timeList) {
                String[] timeArray = timeStr.split("_");
                if (timeArray == null || timeArray.length != 2) continue;
                Date temp = DateUtils.StrToDate((String)timeArray[0], (String)"date");
                Calendar c = Calendar.getInstance();
                c.setTime(temp);
                if ("no".equals(operInterval)) {
                    map.put("date", timeArray[0]);
                    Date today = c.getTime();
                    registerStoreVo.setDate(today);
                    registerStoreVo.setAmOrPm(Integer.valueOf(timeArray[1]));
                    registerStoreVo.setRepeatFlag("2");
                    registerStoreVo.setRepeatFlag(operInterval);
                    this.insertRegisterStore(registerStoreVo);
                    continue;
                }
                if (!"1".equals(operInterval) && !"0".equals(operInterval)) continue;
                registerStoreVo.setRepeatFlag(operInterval);
                for (int i = 0; i < 4; ++i) {
                    c.add(6, 7 * i);
                    if ("1".equals(operInterval) && (i == 1 || i == 3)) {
                        c.setTime(temp);
                        continue;
                    }
                    Date today = c.getTime();
                    registerStoreVo.setDate(today);
                    registerStoreVo.setAmOrPm(Integer.valueOf(timeArray[1]));
                    this.insertRegisterStore(registerStoreVo);
                    c.setTime(temp);
                }
                registerStoreVo.setWeekDay(String.valueOf(c.get(7)));
                this.insertTemplate(registerStoreVo, timeArray[0], timeArray[1], operInterval);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return retmap;
        }
    }

    public void deleteRegister(String id) {
        this.registerStoreDao.deleteByPrimaryKey(id);
    }

    public int userRegisterInfo(String id) {
        return this.registerStoreDao.userRegisterInfo(id);
    }

    public Map<String, Object> returnRegisterInfo(String doctorId, String pageFlag) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        List dlvlist = this.doctorLocationService.getDoctorLocationInfo(doctorId);
        if (dlvlist != null && dlvlist.size() != 0) {
            DoctorLocationVo doctorLocationVo = (DoctorLocationVo)dlvlist.get(0);
            RegisterStoreVo vo = new RegisterStoreVo();
            vo.setSysDoctorId(doctorLocationVo.getSysDoctorId());
            vo.setSysHospitalId(doctorLocationVo.getSysHospitalId());
            vo.setDoctorName(doctorLocationVo.getDoctorName());
            vo.setHospitalName(doctorLocationVo.getHospital());
            vo.setLocation(doctorLocationVo.getLocation());
            vo.setLocationId(doctorLocationVo.getId());
            ArrayList<String> dateList = new ArrayList<String>();
            ArrayList<String> dateListCondition = new ArrayList<String>();
            Calendar nowCalendar = Calendar.getInstance();
            nowCalendar.setTime(new Date());
            int weekday = 0;
            weekday = nowCalendar.get(7) == 1 ? 7 : nowCalendar.get(7) - 1;
            int displayDays = 8 - weekday;
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            if (Integer.parseInt(pageFlag) > 0) {
                cal.add(6, 7 * (Integer.parseInt(pageFlag) - 1) + displayDays);
                displayDays = 7;
            }
            Date firstDay = cal.getTime();
            for (int i = 0; i < displayDays; ++i) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(firstDay);
                ((Calendar)calendar).add(5, i);
                Date date = calendar.getTime();
                int dayForWeek = 1;
                dayForWeek = calendar.get(7) == 1 ? 7 : calendar.get(7) - 1;
                String[] weekDays = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u65e5"};
                String date_ = DateUtils.DateToStr((Date)date, (String)"date");
                dateListCondition.add(date_);
                dateList.add(date_ + "(" + weekDays[dayForWeek - 1] + ")");
            }
            Map<String, Object> retmap = this.compareRegisterTime(doctorId, dateListCondition, vo.getLocationId());
            vo.setPrice((Float)retmap.get("price"));
            vo.setServiceType((String)retmap.get("serverType"));
            retMap.put("dateList", dateList);
            retMap.put("locationList", dlvlist);
            retMap.put("registerStoreVo", vo);
            retMap.put("repeatFlag", retmap.get("repeatFlag"));
            retMap.put("intervalFlag", retmap.get("intervalFlag"));
            retMap.put("timeList", retmap.get("timeList"));
            retMap.put("distimeList", retmap.get("distimeList"));
            return retMap;
        }
        return null;
    }

    public List<RegisterStoreVo> getRegisterListByInfo(Map<String, Object> params) {
        return this.registerStoreDao.getRegisterListByInfo(params);
    }

    public List<RegisterStoreVo> findNoDelRegisterAppointmentList(RegisterStoreVo vo) {
        return this.registerStoreDao.findNoDelRegisterAppointmentList(vo);
    }

    private Map<String, Object> compareRegisterTime(String doctorId, List<String> dateList, String locationId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysDoctorId", doctorId);
        map.put("dateList", dateList);
        List<RegisterStoreVo> temp = this.registerStoreDao.getRegisterListByInfo(map);
        ArrayList<String> distimeList = new ArrayList<String>();
        ArrayList<String> beginTimeList = new ArrayList<String>();
        ArrayList comList = new ArrayList();
        Object price = null;
        String serverType = "";
        for (RegisterStoreVo rsv : temp) {
            int amOrPm = rsv.getAmOrPm();
            if (rsv.getLocationId().equals(locationId)) {
                if (rsv.getTotal() == rsv.getAvailableAmount()) {
                    if ("0".equals(rsv.getRepeatFlag()) || "1".equals(rsv.getRepeatFlag())) {
                        beginTimeList.add("3S|X" + DateUtils.DateToStr((Date)rsv.getDate(), (String)"date") + "_" + amOrPm + "S|X" + rsv.getRepeatFlag());
                    } else {
                        beginTimeList.add("6S|X" + DateUtils.DateToStr((Date)rsv.getDate(), (String)"date") + "_" + amOrPm);
                    }
                }
                if (rsv.getTotal() <= rsv.getAvailableAmount()) continue;
                if ("0".equals(rsv.getRepeatFlag()) || "1".equals(rsv.getRepeatFlag())) {
                    beginTimeList.add("5S|X" + DateUtils.DateToStr((Date)rsv.getDate(), (String)"date") + "_" + amOrPm + "S|X" + rsv.getRepeatFlag());
                    continue;
                }
                beginTimeList.add("4S|X" + DateUtils.DateToStr((Date)rsv.getDate(), (String)"date") + "_" + amOrPm);
                continue;
            }
            distimeList.add(DateUtils.DateToStr((Date)rsv.getDate(), (String)"date") + "_" + amOrPm);
        }
        map.put("price", price);
        map.put("serverType", serverType);
        map.put("success", "success");
        map.put("timeList", beginTimeList);
        map.put("distimeList", distimeList);
        return map;
    }

    public JSONObject getRegisterTime(String doctorId, String pageFlag, String locationId) {
        ArrayList<String> dateList = new ArrayList<String>();
        ArrayList<String> dateListCondition = new ArrayList<String>();
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setTime(new Date());
        int weekday = 0;
        weekday = nowCalendar.get(7) == 1 ? 7 : nowCalendar.get(7) - 1;
        int displayDays = 8 - weekday;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if (Integer.parseInt(pageFlag) > 0) {
            cal.add(6, 7 * (Integer.parseInt(pageFlag) - 1) + displayDays);
            displayDays = 7;
        }
        Date firstDay = cal.getTime();
        for (int i = 0; i < displayDays; ++i) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(firstDay);
            ((Calendar)calendar).add(5, i);
            Date date = calendar.getTime();
            int dayForWeek = 1;
            dayForWeek = calendar.get(7) == 1 ? 7 : calendar.get(7) - 1;
            String[] weekDays = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u65e5"};
            String date_ = DateUtils.DateToStr((Date)date, (String)"date");
            dateListCondition.add(date_);
            dateList.add(date_ + "(" + weekDays[dayForWeek - 1] + ")");
        }
        JSONObject result = new JSONObject();
        Map<String, Object> retmap = this.compareRegisterTime(doctorId, dateListCondition, locationId);
        result.put((Object)"price", retmap.get("price"));
        result.put((Object)"serverType", retmap.get("serverType"));
        result.put((Object)"repeatFlag", retmap.get("repeatFlag"));
        result.put((Object)"intervalFlag", retmap.get("intervalFlag"));
        result.put((Object)"success", (Object)"success");
        result.put((Object)"timeList", retmap.get("timeList"));
        result.put((Object)"distimeList", retmap.get("distimeList"));
        result.put((Object)"dateList", dateList);
        return result;
    }

    public void updateRegister(RegisterStoreVo registerStoreVo, String time, String date, String operRepeat) {
        Map<String, Object> retMap = this.getDateList(registerStoreVo, date, time, operRepeat);
        List insertDateList = (List)retMap.get("dateList");
        String repeat = (String)retMap.get("repeat");
        if ("yes".equals(operRepeat) && "yes".equals(repeat)) {
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            String weekday = c.get(7) + "";
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sysDoctorId", registerStoreVo.getSysDoctorId());
            map.put("amOrPm", time);
            map.put("dateList", insertDateList);
            List<RegisterStoreVo> rsvlist = this.registerStoreDao.getRegisterListByInfo(map);
            for (RegisterStoreVo vo : rsvlist) {
                this.update(vo.getId(), registerStoreVo.getPrice().floatValue(), registerStoreVo.getServiceType());
            }
            this.updateTemplate(registerStoreVo, weekday, date, time, null);
        } else {
            this.update(registerStoreVo.getId(), registerStoreVo.getPrice().floatValue(), registerStoreVo.getServiceType());
        }
    }

    public String findEffectRegisterStore(String timeParam, String locationId, String doctorId, String operRepeat) {
        String[] timeArray = timeParam.split(";");
        StringBuffer sb = new StringBuffer("");
        for (String time : timeArray) {
            String[] timeStr = time.split("_");
            if (timeStr == null || timeStr.length != 2) {
                return null;
            }
            RegisterServiceVo vo = new RegisterServiceVo();
            vo.setLocationId(locationId);
            vo.setSysDoctorId(doctorId);
            RegisterStoreVo rvo = new RegisterStoreVo();
            rvo.setSysDoctorId(doctorId);
            rvo.setLocationId(locationId);
            List dateList = new ArrayList();
            Map<String, Object> retMap = this.getDateList(rvo, timeStr[0], timeStr[1], operRepeat);
            dateList = (List)retMap.get("dateList");
            String repeat = (String)retMap.get("repeat");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sysDoctorId", doctorId);
            map.put("locationId", locationId);
            map.put("dateList", dateList);
            map.put("amOrPm", timeStr[1]);
            List<RegisterStoreVo> rsList = this.registerStoreDao.getAppoinmentListByInfo(map);
            RegisterStoreVo isRepeatvo = null;
            for (RegisterStoreVo rsvo : rsList) {
                if (!timeStr[0].equals(DateUtils.DateToStr((Date)rsvo.getDate(), (String)"date"))) continue;
                if (!"0".equals(rsvo.getRepeatFlag()) && !"1".equals(rsvo.getRepeatFlag())) {
                    isRepeatvo = rsvo;
                    continue;
                }
                if ("yes".equals(operRepeat)) continue;
                isRepeatvo = rsvo;
            }
            if (isRepeatvo != null) {
                String amOrPm = isRepeatvo.getAmOrPm().equals("1") ? "\u4e0a\u5348" : "\u4e0b\u5348";
                sb.append(DateUtils.DateToStr((Date)isRepeatvo.getDate(), (String)"date") + amOrPm + "\u7684\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6");
                continue;
            }
            for (RegisterStoreVo rsvo : rsList) {
                if (!"0".equals(rsvo.getRepeatFlag()) && !"1".equals(rvo.getRepeatFlag())) continue;
                String amOrPm = rsvo.getAmOrPm().equals("1") ? "\u4e0a\u5348" : "\u4e0b\u5348";
                sb.append(DateUtils.DateToStr((Date)rsvo.getDate(), (String)"date") + amOrPm + "\u7684\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6");
            }
        }
        return sb.toString();
    }

    public int deleteRegisterStores(RegisterStoreVo registerStoreVo, List<String> timeList, String operRepeat, String deleteBy) {
        int count = 0;
        Random r = new Random();
        for (String time : timeList) {
            String[] timeStr = time.split("_");
            if (timeStr == null || timeStr.length != 2) {
                return count;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            List dateList = new ArrayList();
            Map<String, Object> retMap = this.getDateList(registerStoreVo, timeStr[0], timeStr[1], operRepeat);
            dateList = (List)retMap.get("dateList");
            String repeat = (String)retMap.get("repeat");
            map.put("dateList", dateList);
            map.put("sysDoctorId", registerStoreVo.getSysDoctorId());
            map.put("locationId", registerStoreVo.getLocationId());
            map.put("amOrPm", timeStr[1]);
            List<RegisterStoreVo> rsList = this.registerStoreDao.getRegisterListByInfo(map);
            RegisterStoreVo isRepeatvo = null;
            ArrayList delList = new ArrayList();
            for (RegisterStoreVo rvo : rsList) {
                if (!timeStr[0].equals(DateUtils.DateToStr((Date)rvo.getDate(), (String)"date"))) continue;
                if (!"0".equals(rvo.getRepeatFlag()) && !"1".equals(rvo.getRepeatFlag())) {
                    isRepeatvo = rvo;
                    continue;
                }
                if ("yes".equals(operRepeat)) continue;
                isRepeatvo = rvo;
            }
            if (isRepeatvo != null) {
                if (isRepeatvo.getAvailableAmount() == isRepeatvo.getTotal()) {
                    count += this.registerStoreDao.deleteByPrimaryKey(isRepeatvo.getId());
                }
            } else {
                for (RegisterStoreVo rsvo : rsList) {
                    if (!"0".equals(rsvo.getRepeatFlag()) && !"1".equals(rsvo.getRepeatFlag())) continue;
                    count += this.registerStoreDao.deleteByPrimaryKey(rsvo.getId());
                }
            }
            if (!"yes".equals(operRepeat) || !"yes".equals(repeat) || isRepeatvo != null) continue;
            Date temp = DateUtils.StrToDate((String)timeStr[0], (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            this.delTemplate(registerStoreVo, timeStr[0], timeStr[1], null);
        }
        return count;
    }

    private Map<String, Object> getDateList(RegisterStoreVo vo, String date, String time, String repeat) {
        ArrayList<String> dateList = new ArrayList<String>();
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        dateList.add(date);
        if (!"no".equals(repeat) && repeat != null && !"".equals(repeat)) {
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            String weekday = c.get(7) + "";
            RegisterStoreTemplateVo rvo = this.getTemplate(vo, weekday, date, time, null);
            if (rvo != null) {
                Date today;
                int i;
                retmap.put("repeat", "yes");
                if ("0".equals(rvo.getRepeatInterval())) {
                    c.setTime(temp);
                    for (i = 0; i < 6; ++i) {
                        c.add(6, 7);
                        today = c.getTime();
                        dateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                    }
                }
                if ("1".equals(rvo.getRepeatInterval())) {
                    c.setTime(temp);
                    for (i = 0; i < 3; ++i) {
                        c.add(6, 14);
                        today = c.getTime();
                        dateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                    }
                }
            } else {
                c.setTime(temp);
                for (int i = 0; i < 6; ++i) {
                    c.add(6, 7);
                    Date today = c.getTime();
                    dateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                }
            }
        }
        retmap.put("dateList", dateList);
        return retmap;
    }

    private void update(String id, float price, String serviceType) {
        RegisterStoreVo registerStoreVo = new RegisterStoreVo();
        registerStoreVo.setId(id);
        registerStoreVo.setPrice(Float.valueOf(price));
        registerStoreVo.setServiceType(serviceType);
        registerStoreVo.setUpdateDate(new Date());
        this.registerStoreDao.updateRegisterStore(registerStoreVo);
    }
}

