/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.order.service.impl;

import com.cxqm.xiaoerke.common.utils.DateUtils;
import com.cxqm.xiaoerke.common.web.Servlets;
import com.cxqm.xiaoerke.modules.order.dao.ConsultPhoneRegisterTemplateDao;
import com.cxqm.xiaoerke.modules.order.dao.SysConsultPhoneServiceDao;
import com.cxqm.xiaoerke.modules.order.entity.ConsulPhonetDoctorRelationVo;
import com.cxqm.xiaoerke.modules.order.entity.ConsultPhoneRegisterTemplateVo;
import com.cxqm.xiaoerke.modules.order.entity.SysConsultPhoneServiceVo;
import com.cxqm.xiaoerke.modules.order.service.ConsultPhonePatientService;
import com.cxqm.xiaoerke.modules.order.service.PhoneConsultDoctorRelationService;
import com.cxqm.xiaoerke.modules.order.service.SysConsultPhoneService;
import com.cxqm.xiaoerke.modules.sys.utils.LogUtils;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysConsultPhoneServiceImpl
implements SysConsultPhoneService {
    @Autowired
    SysConsultPhoneServiceDao sysConsultPhoneServiceDao;
    @Autowired
    ConsultPhoneRegisterTemplateDao consultPhoneRegisterTemplateDao;
    @Autowired
    ConsultPhonePatientService consultPhonePatientService;
    @Autowired
    private PhoneConsultDoctorRelationService phoneConsultDoctorRelationService;

    public Map<String, Object> getDoctorConsultDate(HashMap<String, Object> dataMap) {
        List<HashMap<String, Object>> resultList = this.sysConsultPhoneServiceDao.getConsultDateList(dataMap);
        HashMap<String, Object> response = new HashMap<String, Object>();
        LinkedList consultDateList = new LinkedList();
        if (resultList != null && !resultList.isEmpty()) {
            for (HashMap<String, Object> map : resultList) {
                HashMap<String, String> consultDate = new HashMap<String, String>();
                consultDate.put("date", (String)map.get("date"));
                consultDateList.add(consultDate);
            }
        }
        response.put("dateList", consultDateList);
        return response;
    }

    public Map<String, Object> getDoctorConsultDateInfo(HashMap<String, Object> dataMap) {
        List<HashMap<String, Object>> resultList = this.sysConsultPhoneServiceDao.getConsultDateInfoList(dataMap);
        HashMap<String, Object> response = new HashMap<String, Object>();
        LinkedList consultDateList = new LinkedList();
        if (resultList != null && !resultList.isEmpty()) {
            for (HashMap<String, Object> map : resultList) {
                HashMap<String, String> consultDate = new HashMap<String, String>();
                consultDate.put("date", (String)map.get("date"));
                consultDateList.add(consultDate);
            }
        }
        response.put("dateList", consultDateList);
        return response;
    }

    public Integer getCount() {
        return this.sysConsultPhoneServiceDao.finCountOfService();
    }

    public Map<String, Object> doctorConsultPhoneOfDay(Map<String, Object> params) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String doctorId = (String)params.get("doctorId");
        Date date = DateUtils.formatDate(params);
        String DateToStr = DateUtils.DateToStr((Date)date);
        int week = 0;
        try {
            week = DateUtils.dayForWeek((String)DateToStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String dayWeek = DateUtils.getDayWeek((int)week);
        StringBuffer bf = new StringBuffer();
        bf.append(DateToStr.substring(0, 10));
        bf.append("  " + dayWeek).toString();
        response.put("date", bf.toString());
        HashMap<String, Object> dataInfo = new HashMap<String, Object>();
        dataInfo.put("doctorId", doctorId);
        dataInfo.put("date", date);
        List<HashMap<String, Object>> resultList = this.sysConsultPhoneServiceDao.findConsultPhoneTimeListByDoctorAndDate(dataInfo);
        LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"00000030", (String)("\u533b\u751f\u4e3b\u952e\uff1a" + doctorId + "date:" + date));
        SimpleDateFormat formart = new SimpleDateFormat("HH:mm");
        LinkedList consultPhoneTimeList = new LinkedList();
        if (resultList != null && !resultList.isEmpty()) {
            for (HashMap<String, Object> map : resultList) {
                HashMap<String, Object> consultPhoneTime = new HashMap<String, Object>();
                consultPhoneTime.put("price", (String)map.get("price"));
                consultPhoneTime.put("id", (Integer)map.get("id"));
                consultPhoneTime.put("data", DateToStr);
                consultPhoneTime.put("begin_time", (String)map.get("begin_time"));
                try {
                    Date start = formart.parse((String)map.get("begin_time"));
                    Date now = formart.parse(formart.format(new Date()));
                    if (date.getTime() >= new Date().getTime()) {
                        consultPhoneTime.put("state", (String)map.get("state"));
                    } else if (start.getTime() > now.getTime()) {
                        consultPhoneTime.put("state", (String)map.get("state"));
                    } else {
                        consultPhoneTime.put("state", "1");
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                consultPhoneTime.put("end_time", (String)map.get("end_time"));
                consultPhoneTime.put("serviceType", (String)map.get("serviceType"));
                consultPhoneTime.put("repeatFlag", (String)map.get("repeatFlag"));
                consultPhoneTimeList.add(consultPhoneTime);
            }
        }
        response.put("consultPhoneTimeList", consultPhoneTimeList);
        return response;
    }

    public JSONObject getRegisterTime(String doctorId, String date) {
        JSONObject result = new JSONObject();
        Map<String, Object> retmap = this.getSysConsultPhoneServiceListInfo(doctorId, date);
        result.put((Object)"price", retmap.get("price"));
        result.put((Object)"serverType", retmap.get("serverType"));
        result.put((Object)"repeatFlag", retmap.get("repeatFlag"));
        result.put((Object)"intervalFlag", retmap.get("intervalFlag"));
        result.put((Object)"success", (Object)"success");
        result.put((Object)"beginTimeList", retmap.get("beginTimeList"));
        return result;
    }

    public Map<String, Object> getRegisterInfo(String doctorId, String pageFlag) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList<String> dateList = new ArrayList<String>();
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(6, 7 * Integer.parseInt(pageFlag));
        Date firstDay = c.getTime();
        for (int i = 0; i < 7; ++i) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(firstDay);
            ((Calendar)calendar).add(5, i);
            Date date = calendar.getTime();
            int dayForWeek = 0;
            dayForWeek = calendar.get(7) == 1 ? 7 : calendar.get(7) - 1;
            String[] weekDays = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u65e5"};
            String date_ = DateUtils.DateToStr((Date)date, (String)"date");
            dateList.add(date_ + "(" + weekDays[dayForWeek - 1] + ")");
        }
        ConsulPhonetDoctorRelationVo paramVo = new ConsulPhonetDoctorRelationVo();
        paramVo.setDoctorId(doctorId);
        List list = this.phoneConsultDoctorRelationService.getPhoneConsultDoctorRelationByInfo(paramVo);
        String phoneConsultFlag = "";
        ConsulPhonetDoctorRelationVo cvo = new ConsulPhonetDoctorRelationVo();
        if (list.size() == 0) {
            phoneConsultFlag = "no";
            cvo.setDoctorId(doctorId);
        } else {
            phoneConsultFlag = "yes";
        }
        Map<String, Object> retmap = this.getSysConsultPhoneServiceListInfo(doctorId, DateUtils.DateToStr((Date)firstDay, (String)"date"));
        if (list.size() == 0) {
            returnMap.put("consulPhonetDoctorRelationVo", cvo);
        } else {
            returnMap.put("consulPhonetDoctorRelationVo", list.get(0));
            returnMap.put("serverLength", ((ConsulPhonetDoctorRelationVo)list.get(0)).getServerLength());
        }
        returnMap.put("dateList", dateList);
        returnMap.put("phoneConsultFlag", phoneConsultFlag);
        returnMap.put("serverType", retmap.get("serverType"));
        returnMap.put("success", "success");
        returnMap.put("beginTimeList", retmap.get("beginTimeList"));
        return returnMap;
    }

    private Map<String, Object> getSysConsultPhoneServiceListInfo(String doctorId, String date) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("doctorId", doctorId);
        paramMap.put("date", date);
        List<SysConsultPhoneServiceVo> spsvList = this.sysConsultPhoneServiceDao.findSysConsultPhoneByInfo(paramMap);
        ArrayList<String> beginTimeList = new ArrayList<String>();
        String time = new String();
        String serverType = "";
        for (SysConsultPhoneServiceVo rsv : spsvList) {
            time = DateUtils.DateToStr((Date)rsv.getBegintime(), (String)"time");
            if ("0".equals(rsv.getState())) {
                if ("0".equals(rsv.getRepeatFlag())) {
                    beginTimeList.add("3S|X" + time);
                } else if ("2".equals(rsv.getRepeatFlag())) {
                    beginTimeList.add("1S|X" + time);
                }
            }
            if (!"1".equals(rsv.getState())) continue;
            if ("0".equals(rsv.getRepeatFlag())) {
                beginTimeList.add("4S|X" + time);
                continue;
            }
            if (!"2".equals(rsv.getRepeatFlag())) continue;
            beginTimeList.add("2S|X" + time);
        }
        map.put("price", null);
        map.put("serverType", serverType);
        map.put("success", "success");
        map.put("beginTimeList", beginTimeList);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> addRegisters(SysConsultPhoneServiceVo vo, List<String> timeList, String date, String operInterval) throws Exception {
        Class<SysConsultPhoneServiceImpl> clazz = SysConsultPhoneServiceImpl.class;
        synchronized (SysConsultPhoneServiceImpl.class) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, String> retmap = new HashMap<String, String>();
            ArrayList<String> insertDateList = new ArrayList<String>();
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add("0");
            statusList.add("1");
            map.put("sysDoctorId", vo.getSysDoctorId());
            map.put("statusList", statusList);
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            String weekday = c.get(7) + "";
            if ("no".equals(operInterval)) {
                map.put("date", date);
            } else if ("1".equals(operInterval) || "0".equals(operInterval)) {
                insertDateList.add(date);
                for (int i = 0; i < 3; ++i) {
                    c.add(6, 7);
                    if ("1".equals(operInterval) && (i == 0 || i == 2)) continue;
                    Date today = c.getTime();
                    insertDateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                }
                map.put("dateList", insertDateList);
            }
            StringBuffer sb = new StringBuffer("");
            int countRepeat = 0;
            int countUsed = 0;
            int countRegister = 0;
            for (String time : timeList) {
                ArrayList<SysConsultPhoneServiceVo> insertFlagList = new ArrayList<SysConsultPhoneServiceVo>();
                ArrayList<SysConsultPhoneServiceVo> updateList = new ArrayList<SysConsultPhoneServiceVo>();
                ArrayList<String> updateDateList = new ArrayList<String>();
                map.put("time", time);
                List<SysConsultPhoneServiceVo> rsvlist = this.sysConsultPhoneServiceDao.findSysConsultPhoneByInfo(map);
                for (SysConsultPhoneServiceVo tvo : rsvlist) {
                    insertFlagList.add(tvo);
                    if (!"0".equals(tvo.getState())) continue;
                    updateDateList.add(DateUtils.DateToStr((Date)tvo.getDate(), (String)"date"));
                    updateList.add(tvo);
                }
                if (insertFlagList.size() == 0) {
                    if ("no".equals(operInterval)) {
                        vo.setRepeatFlag("2");
                        this.insertRegister(vo, time, date);
                    } else {
                        vo.setRepeatFlag(operInterval);
                        ConsultPhoneRegisterTemplateVo rtsv = this.operTemplate("get", vo, weekday, date, time, operInterval);
                        if (rtsv != null) {
                            if ("1".equals(rtsv.getRepeatInterval()) && "1".equals(operInterval)) {
                                for (String dt : insertDateList) {
                                    if (updateDateList.contains(dt)) continue;
                                    this.insertRegister(vo, time, dt);
                                }
                                this.operTemplate("update", vo, weekday, date, time, operInterval);
                            } else {
                                ++countRepeat;
                                if ("1".equals(rtsv.getRepeatInterval())) {
                                    sb.append(time + "\u7684\u53f7\u6e90\u5df2\u88ab\u8bbe\u7f6e\u9694\u5468\u91cd\u590d\uff01\n");
                                } else {
                                    sb.append(time + "\u7684\u53f7\u6e90\u5df2\u88ab\u8bbe\u7f6e\u6bcf\u5468\u91cd\u590d\uff01\n");
                                }
                            }
                        } else {
                            for (String dt : insertDateList) {
                                if (updateDateList.contains(dt)) continue;
                                this.insertRegister(vo, time, dt);
                            }
                            this.operTemplate("add", vo, weekday, date, time, operInterval);
                        }
                    }
                } else {
                    for (SysConsultPhoneServiceVo tvo : insertFlagList) {
                        if ("1".equals(tvo.getState())) {
                            ++countRegister;
                            sb.append(DateUtils.DateToStr((Date)tvo.getDate(), (String)"date") + "(" + DateUtils.DateToStr((Date)tvo.getBegintime(), (String)"time") + ")\u7684\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6\n");
                            continue;
                        }
                        ++countUsed;
                        sb.append(DateUtils.DateToStr((Date)tvo.getDate(), (String)"date") + "(" + DateUtils.DateToStr((Date)tvo.getBegintime(), (String)"time") + ")\u7684\u53f7\u6e90\u5df2\u88ab\u5360\u7528\n");
                    }
                }
                if (!"".equals(sb.toString())) continue;
                for (SysConsultPhoneServiceVo rsv : updateList) {
                    this.update(rsv.getId(), vo.getPrice(), vo.getServicetype());
                }
            }
            StringBuffer sbf = new StringBuffer("");
            if (countRepeat != 0) {
                sbf.append(countRepeat + "\u4e2a\u53f7\u6e90\u5df2\u88ab\u8bbe\u7f6e\u91cd\u590d<br/>");
            }
            if (countRegister != 0) {
                sbf.append(countRegister + "\u4e2a\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6<br/>");
            }
            if (countUsed != 0) {
                sbf.append(countUsed + "\u4e2a\u53f7\u6e90\u5df2\u88ab\u5360\u7528<br/>");
            }
            retmap.put("doctor", sbf.toString());
            retmap.put("backend", sb.toString());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return retmap;
        }
    }

    private void insertRegister(SysConsultPhoneServiceVo registerVo, String time, String date) {
        Date begin_time = DateUtils.StrToDate((String)time, (String)"time");
        ConsulPhonetDoctorRelationVo rvo = new ConsulPhonetDoctorRelationVo();
        rvo.setDoctorId(registerVo.getSysDoctorId());
        List relationList = this.phoneConsultDoctorRelationService.getPhoneConsultDoctorRelationByInfo(rvo);
        if (relationList != null && relationList.size() != 0) {
            Date end_time = new Date(begin_time.getTime() + (long)(((ConsulPhonetDoctorRelationVo)relationList.get(0)).getServerLength() * 60 * 1000));
            registerVo.setEndtime(end_time);
        }
        registerVo.setDate(DateUtils.StrToDate((String)date, (String)"date"));
        registerVo.setBegintime(begin_time);
        registerVo.setCreatedate(new Date());
        registerVo.setState("0");
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("0");
        statusList.add("1");
        queryMap.put("statusList", statusList);
        queryMap.put("date", date);
        queryMap.put("time", begin_time);
        queryMap.put("sysDoctorId", registerVo.getSysDoctorId());
        List<SysConsultPhoneServiceVo> rlist = this.sysConsultPhoneServiceDao.findSysConsultPhoneByInfo(queryMap);
        if (rlist.size() == 0) {
            this.sysConsultPhoneServiceDao.insertSelective(registerVo);
        }
    }

    private void update(Integer id, String price, String serviceType) {
        SysConsultPhoneServiceVo svo = new SysConsultPhoneServiceVo();
        svo.setId(id);
        svo.setPrice(price);
        svo.setServicetype(serviceType);
        svo.setUpdatedate(new Date());
        this.sysConsultPhoneServiceDao.updateByPrimaryKeySelective(svo);
    }

    private ConsultPhoneRegisterTemplateVo operTemplate(String operType, SysConsultPhoneServiceVo vo, String weekday, String date, String time, String operInterval) {
        Date lasttoday;
        Calendar c;
        Date temp;
        ArrayList<String> dateList;
        List<ConsultPhoneRegisterTemplateVo> list;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("get".equals(operType)) {
            map.put("doctorId", vo.getSysDoctorId());
            map.put("weekday", weekday);
            map.put("time", time);
            List<ConsultPhoneRegisterTemplateVo> list2 = this.consultPhoneRegisterTemplateDao.getRegisterTemplateList(map);
            for (ConsultPhoneRegisterTemplateVo rtvo : list2) {
                if ("1".equals(rtvo.getRepeatInterval()) && "1".equals(operInterval)) {
                    ArrayList<String> dateList2 = new ArrayList<String>();
                    dateList2.add(date);
                    Date temp2 = DateUtils.StrToDate((String)date, (String)"date");
                    Calendar c2 = Calendar.getInstance();
                    c2.setTime(temp2);
                    c2.add(6, -14);
                    Date lasttoday2 = c2.getTime();
                    dateList2.add(DateUtils.DateToStr((Date)lasttoday2, (String)"date"));
                    if (!dateList2.contains(DateUtils.DateToStr((Date)rtvo.getUpdateDate(), (String)"date"))) continue;
                    return rtvo;
                }
                return rtvo;
            }
            return null;
        }
        if ("update".equals(operType) && time != null && !"".equals(time)) {
            map.put("price", vo.getPrice());
            map.put("serverType", vo.getServicetype());
            map.put("doctorId", vo.getSysDoctorId());
            map.put("weekday", weekday);
            map.put("time", time);
            list = this.consultPhoneRegisterTemplateDao.getRegisterTemplateList(map);
            if (list != null && list.size() != 0 && "1".equals(list.get(0).getRepeatInterval())) {
                dateList = new ArrayList();
                dateList.add(date);
                temp = DateUtils.StrToDate((String)date, (String)"date");
                c = Calendar.getInstance();
                c.setTime(temp);
                c.add(6, -14);
                lasttoday = c.getTime();
                dateList.add(DateUtils.DateToStr((Date)lasttoday, (String)"date"));
                map.put("updateDateList", dateList);
            }
            this.consultPhoneRegisterTemplateDao.updateRegisterTemplateByInfo(map);
        }
        if ("add".equals(operType)) {
            map.put("doctorId", vo.getSysDoctorId());
            map.put("weekday", weekday);
            map.put("price", vo.getPrice());
            map.put("serverType", vo.getServicetype());
            map.put("status", 1);
            map.put("createDate", new Date());
            map.put("updateDate", date);
            map.put("interval", operInterval);
            map.put("time", time);
            this.consultPhoneRegisterTemplateDao.saveRegisterTemplate(map);
        }
        if ("del".equals(operType) && time != null && !"".equals(time)) {
            map.put("doctorId", vo.getSysDoctorId());
            map.put("weekday", weekday);
            map.put("time", time);
            list = this.consultPhoneRegisterTemplateDao.getRegisterTemplateList(map);
            if (list != null && list.size() != 0 && "1".equals(list.get(0).getRepeatInterval())) {
                dateList = new ArrayList<String>();
                dateList.add(date);
                temp = DateUtils.StrToDate((String)date, (String)"date");
                c = Calendar.getInstance();
                c.setTime(temp);
                c.add(6, -14);
                lasttoday = c.getTime();
                dateList.add(DateUtils.DateToStr((Date)lasttoday, (String)"date"));
                map.put("updateDateList", dateList);
            }
            this.consultPhoneRegisterTemplateDao.deleteRegisterTemplateByinfo(map);
        }
        return null;
    }

    private Map<String, Object> getDateList(SysConsultPhoneServiceVo vo, String date, String time, String repeat) {
        ArrayList<String> dateList = new ArrayList<String>();
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        dateList.add(date);
        if ("yes".equals(repeat) && repeat != null && !"".equals(repeat)) {
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            String weekday = c.get(7) + "";
            ConsultPhoneRegisterTemplateVo rvo = this.operTemplate("get", vo, weekday, date, time, null);
            if (rvo != null) {
                Date today;
                int i;
                retmap.put("repeat", "yes");
                if ("0".equals(rvo.getRepeatInterval())) {
                    c.setTime(temp);
                    for (i = 0; i < 6; ++i) {
                        c.add(6, 7);
                        today = c.getTime();
                        dateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                    }
                }
                if ("1".equals(rvo.getRepeatInterval())) {
                    c.setTime(temp);
                    for (i = 0; i < 3; ++i) {
                        c.add(6, 14);
                        today = c.getTime();
                        dateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                    }
                }
            } else {
                c.setTime(temp);
                for (int i = 0; i < 6; ++i) {
                    c.add(6, 7);
                    Date today = c.getTime();
                    dateList.add(DateUtils.DateToStr((Date)today, (String)"date"));
                }
            }
        }
        retmap.put("dateList", dateList);
        return retmap;
    }

    public String judgeRepeatEffect(String date, String timeParam, String doctorId, String operRepeat) {
        String[] timeArray = timeParam.split(";");
        StringBuffer sb = new StringBuffer("");
        for (String time : timeArray) {
            SysConsultPhoneServiceVo vo = new SysConsultPhoneServiceVo();
            vo.setSysDoctorId(doctorId);
            SysConsultPhoneServiceVo rvo = new SysConsultPhoneServiceVo();
            rvo.setSysDoctorId(doctorId);
            List dateList = new ArrayList();
            Map<String, Object> retMap = this.getDateList(rvo, date, time, operRepeat);
            dateList = (List)retMap.get("dateList");
            String repeat = (String)retMap.get("repeat");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("doctorId", doctorId);
            map.put("dateList", dateList);
            map.put("status", "1");
            map.put("time", time);
            List<SysConsultPhoneServiceVo> rsList = this.sysConsultPhoneServiceDao.findSysConsultPhoneByInfo(map);
            SysConsultPhoneServiceVo isRepeatvo = null;
            for (SysConsultPhoneServiceVo rsvo : rsList) {
                if (!date.equals(DateUtils.DateToStr((Date)rsvo.getDate(), (String)"date"))) continue;
                if (!"0".equals(rsvo.getRepeatFlag()) && !"1".equals(rsvo.getRepeatFlag())) {
                    isRepeatvo = rsvo;
                    continue;
                }
                if ("yes".equals(operRepeat)) continue;
                isRepeatvo = rsvo;
            }
            if (isRepeatvo != null) {
                sb.append(DateUtils.DateToStr((Date)isRepeatvo.getDate(), (String)"date") + DateUtils.DateToStr((Date)isRepeatvo.getBegintime(), (String)"time") + "\u7684\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6");
                continue;
            }
            for (SysConsultPhoneServiceVo rsvo : rsList) {
                if (!"0".equals(rsvo.getRepeatFlag()) && !"1".equals(rvo.getRepeatFlag())) continue;
                sb.append(DateUtils.DateToStr((Date)rsvo.getDate(), (String)"date") + DateUtils.DateToStr((Date)rsvo.getBegintime(), (String)"time") + "\u7684\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6");
            }
        }
        return sb.toString();
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteRegisters(SysConsultPhoneServiceVo registerServiceVo, List<String> timeList, String date, String operRepeat) throws Exception {
        int count = 0;
        Random r = new Random();
        for (String time : timeList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List dateList = new ArrayList();
            Map<String, Object> retMap = this.getDateList(registerServiceVo, date, time, operRepeat);
            dateList = (List)retMap.get("dateList");
            String repeat = (String)retMap.get("repeat");
            map.put("dateList", dateList);
            map.put("doctorId", registerServiceVo.getSysDoctorId());
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add("0");
            statusList.add("1");
            map.put("statusList", statusList);
            map.put("time", time);
            List<SysConsultPhoneServiceVo> rsList = this.sysConsultPhoneServiceDao.findSysConsultPhoneByInfo(map);
            SysConsultPhoneServiceVo svo = null;
            for (SysConsultPhoneServiceVo rvo : rsList) {
                if (!date.equals(DateUtils.DateToStr((Date)rvo.getDate(), (String)"date"))) continue;
                if ("2".equals(rvo.getRepeatFlag())) {
                    svo = rvo;
                    continue;
                }
                if (!"no".equals(operRepeat)) continue;
                svo = rvo;
            }
            if (svo != null) {
                this.delRegister(svo);
            } else {
                for (SysConsultPhoneServiceVo rvo : rsList) {
                    if (!"0".equals(rvo.getRepeatFlag()) && !"1".equals(rvo.getRepeatFlag())) continue;
                    this.delRegister(rvo);
                }
            }
            if (!"yes".equals(operRepeat) || !"yes".equals(repeat) || svo != null) continue;
            Date temp = DateUtils.StrToDate((String)date, (String)"date");
            Calendar c = Calendar.getInstance();
            c.setTime(temp);
            String weekday = c.get(7) + "";
            this.operTemplate("del", registerServiceVo, weekday, date, time, null);
        }
        return count;
    }

    private Float delRegister(SysConsultPhoneServiceVo vo) throws Exception {
        Float price = Float.valueOf(0.0f);
        try {
            if ("1".equals(vo.getState())) {
                HashMap<String, Integer> executeMap1 = new HashMap<String, Integer>();
                executeMap1.put("registerId", vo.getId());
                List orderList = this.consultPhonePatientService.getConsultPhoneRegisterListByInfo(executeMap1);
                Integer orderId = (Integer)((Map)orderList.get(0)).get("id");
                price = this.consultPhonePatientService.cancelOrder(orderId, "\u8fd0\u7ef4" + UserUtils.getUser().getName() + "\u5220\u9664", "2");
            } else if ("0".equals(vo.getState())) {
                this.sysConsultPhoneServiceDao.cancelOrder(vo.getId(), "2");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception();
        }
        return price;
    }

    public List<ConsultPhoneRegisterTemplateVo> getRegisterTemplateList(Map<String, Object> executeMap) {
        return this.consultPhoneRegisterTemplateDao.getRegisterTemplateList(executeMap);
    }

    public List<SysConsultPhoneServiceVo> findSysConsultPhoneByInfo(Map<String, Object> map) {
        List<SysConsultPhoneServiceVo> list = this.sysConsultPhoneServiceDao.findSysConsultPhoneByInfo(map);
        return list;
    }

    public HashMap<String, Object> findSysConsultPhoneServiceByCRSIdExecute(HashMap<String, Object> hashMap) {
        return this.sysConsultPhoneServiceDao.findSysConsultPhoneServiceByCRSIdExecute(hashMap);
    }

    public Map<String, Object> getSysPhoneConsultInfo(Integer id) {
        SysConsultPhoneServiceVo vo = this.sysConsultPhoneServiceDao.selectByPrimaryKey(id);
        HashMap<String, Object> response = new HashMap<String, Object>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat format1 = new SimpleDateFormat("HH:mm");
        if (vo != null) {
            response.put("consultDate", format.format(vo.getDate()) + format1.format(vo.getBegintime()) + format1.format(vo.getEndtime()));
        }
        return response;
    }

    public void batchInsertConsultPhoneRegister(List<HashMap<String, Object>> excuteList) {
        this.sysConsultPhoneServiceDao.batchInsertConsultPhoneRegister(excuteList);
    }
}

