/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.plan.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.DateUtils;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.modules.cms.entity.Article;
import com.cxqm.xiaoerke.modules.cms.entity.ArticleData;
import com.cxqm.xiaoerke.modules.cms.entity.Category;
import com.cxqm.xiaoerke.modules.cms.service.ArticleDataService;
import com.cxqm.xiaoerke.modules.cms.service.ArticleService;
import com.cxqm.xiaoerke.modules.cms.utils.BirthdayToAgeUtils;
import com.cxqm.xiaoerke.modules.plan.dao.NutritionManagementDao;
import com.cxqm.xiaoerke.modules.plan.entity.NutritionEvaluate;
import com.cxqm.xiaoerke.modules.plan.entity.PlanInfo;
import com.cxqm.xiaoerke.modules.plan.service.NutritionManagementService;
import com.cxqm.xiaoerke.modules.plan.service.PlanInfoService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class NutritionManagementServiceImpl
implements NutritionManagementService {
    @Autowired
    private ArticleService articleService;
    @Autowired
    private ArticleDataService articleDataService;
    @Autowired
    private NutritionManagementDao nutritionManagementDao;
    @Autowired
    private PlanInfoService planInfoService;

    public HashMap<String, Object> getRecipes(String birthday) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        long days = BirthdayToAgeUtils.getDays((String)birthday, (String)DateUtils.DateToStr((Date)new Date(), (String)"date"));
        long year = days / 365L;
        long month = (days - 365L * year) / 30L;
        long months = year * 12L + month;
        String ageRange = "";
        String categoryId = "";
        if (months >= 12L && months <= 24L) {
            ageRange = "1";
            categoryId = "12d7f889ca4e496ba1b9238f054fba33";
        } else if (months >= 25L && months <= 36L) {
            ageRange = "2";
            categoryId = "7bd10ecdd8594656ab3b91a84a28672f";
        } else {
            ageRange = "outofage";
        }
        Article article = new Article();
        Category category = new Category();
        Calendar cal = Calendar.getInstance();
        category.setId(categoryId);
        article.setKeywords(ageRange + (cal.get(7) - 1));
        article.setCategory(category);
        Page page = this.articleService.findPage(new Page(1, 30), article, true);
        for (int i = 0; i < page.getList().size(); ++i) {
            HashMap articleMap = new HashMap();
            articleMap.put("id", ((Map)page.getList().get(i)).get("id"));
            articleMap.put("keywords", ((Map)page.getList().get(i)).get("keywords"));
            articleMap.put("description", ((Map)page.getList().get(i)).get("description"));
            articleMap.put("title", ((Map)page.getList().get(i)).get("title"));
            articleMap.put("createDate", ((Map)page.getList().get(i)).get("createDate"));
            articleMap.put("serverDate", System.currentTimeMillis());
            ArticleData articleData = (ArticleData)this.articleDataService.get((String)((Map)page.getList().get(i)).get("id"));
            articleMap.put("content", articleData.getContent());
            String keywords = (String)((Map)page.getList().get(i)).get("keywords");
            if (keywords.contains("am") && !keywords.contains("amp")) {
                returnMap.put("am", articleMap);
                continue;
            }
            if (keywords.contains("amp")) {
                returnMap.put("amp", articleMap);
                continue;
            }
            if (keywords.contains("mm") && !keywords.contains("mmp")) {
                returnMap.put("mm", articleMap);
                continue;
            }
            if (keywords.contains("mmp")) {
                returnMap.put("mmp", articleMap);
                continue;
            }
            if (!keywords.contains("pm")) continue;
            returnMap.put("pm", articleMap);
        }
        return returnMap;
    }

    public HashMap<String, Object> getTodayRead() {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Article article = new Article();
        Category category = new Category();
        category.setId("14b49addb6f44711b3a5dda5319ced6c");
        article.setCategory(category);
        Page page = new Page(1, 30);
        page.setOrderBy("create_date desc");
        Page pageList = this.articleService.findPage(page, article, true);
        if (pageList.getCount() != 0L) {
            HashMap habitArticleMap = new HashMap();
            habitArticleMap.put("id", ((Map)pageList.getList().get(0)).get("id"));
            habitArticleMap.put("title", ((Map)pageList.getList().get(0)).get("title"));
            habitArticleMap.put("habitArticleCategoryId", "14b49addb6f44711b3a5dda5319ced6c");
            returnMap.put("habitArticleMap", habitArticleMap);
        }
        category.setId("1e00f247ad5a4c3eac0cd57fe6a8e398");
        article.setCategory(category);
        pageList = this.articleService.findPage(page, article, true);
        if (pageList.getCount() != 0L) {
            HashMap safeArticleMap = new HashMap();
            safeArticleMap.put("id", ((Map)pageList.getList().get(0)).get("id"));
            safeArticleMap.put("title", ((Map)pageList.getList().get(0)).get("title"));
            safeArticleMap.put("safeArticleCategoryId", "1e00f247ad5a4c3eac0cd57fe6a8e398");
            returnMap.put("safeArticleMap", safeArticleMap);
        }
        return returnMap;
    }

    public void saveUpdateEvaluate(Map<String, Object> params) {
        String userId = (String)params.get("userId");
        params.put("createTime", new Date());
        List<NutritionEvaluate> list = this.nutritionManagementDao.getEvaluateListByInfo(params);
        NutritionEvaluate nutritionEvaluate = new NutritionEvaluate();
        if (StringUtils.isNotNull((String)((String)params.get("oilSalt")))) {
            nutritionEvaluate.setOilSalt((String)params.get("oilSalt"));
        }
        if (StringUtils.isNotNull((String)((String)params.get("vegetables")))) {
            nutritionEvaluate.setVegetables((String)params.get("vegetables"));
        }
        if (StringUtils.isNotNull((String)((String)params.get("millet")))) {
            nutritionEvaluate.setMillet((String)params.get("millet"));
        }
        if (StringUtils.isNotNull((String)((String)params.get("potato")))) {
            nutritionEvaluate.setPotato((String)params.get("potato"));
        }
        if (StringUtils.isNotNull((String)((String)params.get("milk")))) {
            nutritionEvaluate.setMilk((String)params.get("milk"));
        }
        if (StringUtils.isNotNull((String)((String)params.get("meat")))) {
            nutritionEvaluate.setMeat((String)params.get("meat"));
        }
        if (StringUtils.isNotNull((String)((String)params.get("fishEggs")))) {
            nutritionEvaluate.setFishEggs((String)params.get("fishEggs"));
        }
        if (StringUtils.isNotNull((String)((String)params.get("water")))) {
            nutritionEvaluate.setWater((String)params.get("water"));
        }
        if (list.size() == 0) {
            nutritionEvaluate.setCreateTime(new Date());
            nutritionEvaluate.setCreateBy(userId);
            nutritionEvaluate.setUserId(userId);
            this.nutritionManagementDao.insertSelective(nutritionEvaluate);
        } else {
            nutritionEvaluate.setId(list.get(0).getId());
            nutritionEvaluate.setUpdateTime(new Date());
            nutritionEvaluate.setUpdateBy(userId);
            this.nutritionManagementDao.updateByPrimaryKeySelective(nutritionEvaluate);
        }
    }

    public Map<String, Object> getEvaluate(Map<String, Object> params) {
        String flag = (String)params.get("flag");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if ("index".equals(flag)) {
            ArrayList<Date> dateList = new ArrayList<Date>();
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.set(5, cal.get(5) - 1);
            Date yesterday = cal.getTime();
            dateList.add(new Date());
            dateList.add(yesterday);
            params.put("dateList", dateList);
            List<NutritionEvaluate> list = this.nutritionManagementDao.getEvaluateListByInfo(params);
            String todayflag = "";
            HashMap<String, String> yestodayEvaluateMap = new HashMap<String, String>();
            for (NutritionEvaluate ne : list) {
                if (DateUtils.DateToStr((Date)new Date(), (String)"date").equals(DateUtils.DateToStr((Date)ne.getCreateTime(), (String)"date"))) {
                    todayflag = "yes";
                }
                if (!DateUtils.DateToStr((Date)yesterday, (String)"date").equals(DateUtils.DateToStr((Date)ne.getCreateTime(), (String)"date"))) continue;
                yestodayEvaluateMap.put("oilSalt", ne.getOilSalt());
                yestodayEvaluateMap.put("vegetables", ne.getVegetables());
                yestodayEvaluateMap.put("millet", ne.getMillet());
                yestodayEvaluateMap.put("potato", ne.getPotato());
                yestodayEvaluateMap.put("meat", ne.getMeat());
                yestodayEvaluateMap.put("fishEggs", ne.getFishEggs());
                yestodayEvaluateMap.put("milk", ne.getMilk());
                yestodayEvaluateMap.put("water", ne.getWater());
            }
            if (StringUtils.isNotNull((String)todayflag)) {
                returnMap.put("td", "yes");
            } else if (yestodayEvaluateMap.size() == 0) {
                returnMap.put("ytn", "yes");
            } else {
                returnMap.put("yty", yestodayEvaluateMap);
            }
        } else if ("evaluate".equals(flag)) {
            params.put("createTime", new Date());
            List<NutritionEvaluate> list = this.nutritionManagementDao.getEvaluateListByInfo(params);
            HashMap<String, String> todayEvaluateMap = new HashMap<String, String>();
            for (NutritionEvaluate ne : list) {
                todayEvaluateMap.put("oilSalt", ne.getOilSalt());
                todayEvaluateMap.put("vegetables", ne.getVegetables());
                todayEvaluateMap.put("millet", ne.getMillet());
                todayEvaluateMap.put("potato", ne.getPotato());
                todayEvaluateMap.put("meat", ne.getMeat());
                todayEvaluateMap.put("fishEggs", ne.getFishEggs());
                todayEvaluateMap.put("milk", ne.getMilk());
                todayEvaluateMap.put("water", ne.getWater());
            }
            returnMap.put("todayEvaluateMap", todayEvaluateMap);
        }
        return returnMap;
    }

    public Map<String, Object> updateSendWechatMessage(Map<String, Object> param) {
        param.put("planTemplateId", 2);
        param.put("status", "ongoing");
        List list = this.planInfoService.getPlanInfoByUserId(param);
        for (Map map : list) {
            PlanInfo planInfo = new PlanInfo();
            planInfo.setId(Long.valueOf(String.valueOf(map.get("id"))));
            planInfo.setNotice((String)param.get("flag"));
            this.planInfoService.updatePlanInfoById(planInfo);
        }
        return null;
    }

    public void reEvaluate(String userId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("createTime", new Date());
        List<NutritionEvaluate> list = this.nutritionManagementDao.getEvaluateListByInfo(params);
        if (list.size() > 0) {
            NutritionEvaluate nutritionEvaluate = new NutritionEvaluate();
            nutritionEvaluate.setFishEggs("");
            nutritionEvaluate.setMeat("");
            nutritionEvaluate.setMilk("");
            nutritionEvaluate.setOilSalt("");
            nutritionEvaluate.setPotato("");
            nutritionEvaluate.setVegetables("");
            nutritionEvaluate.setMillet("");
            nutritionEvaluate.setWater("");
            nutritionEvaluate.setId(list.get(0).getId());
            nutritionEvaluate.setUpdateTime(new Date());
            nutritionEvaluate.setUpdateBy(userId);
            this.nutritionManagementDao.updateByPrimaryKeySelective(nutritionEvaluate);
        }
    }
}

