/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.wechat.service.impl;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.utils.EmojiFilter;
import com.cxqm.xiaoerke.common.utils.ReceiveXmlProcess;
import com.cxqm.xiaoerke.common.utils.WechatUtil;
import com.cxqm.xiaoerke.modules.sys.entity.Article;
import com.cxqm.xiaoerke.modules.sys.entity.MongoLog;
import com.cxqm.xiaoerke.modules.sys.entity.NewsMessage;
import com.cxqm.xiaoerke.modules.sys.entity.ReceiveXmlEntity;
import com.cxqm.xiaoerke.modules.sys.entity.TextMessage;
import com.cxqm.xiaoerke.modules.sys.entity.WechatBean;
import com.cxqm.xiaoerke.modules.sys.service.MongoDBService;
import com.cxqm.xiaoerke.modules.sys.service.SystemService;
import com.cxqm.xiaoerke.modules.sys.utils.LogUtils;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import com.cxqm.xiaoerke.modules.wechat.dao.WechatInfoDao;
import com.cxqm.xiaoerke.modules.wechat.entity.WechatAttention;
import com.cxqm.xiaoerke.modules.wechat.service.WechatDoctorCoreService;
import com.cxqm.xiaoerke.modules.wechat.service.util.MessageUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class WechatDoctorCoreServiceImpl
implements WechatDoctorCoreService {
    @Autowired
    private WechatInfoDao wechatInfoDao;
    @Autowired
    private MongoDBService<WechatAttention> mongoDBService;
    @Autowired
    private MongoDBService<MongoLog> mongoLogService;
    @Autowired
    private SystemService systemService;
    private String mongoEnabled = Global.getConfig((String)"mongo.enabled");

    public String processDoctorRequest(HttpServletRequest request) throws IOException {
        String respMessage = null;
        StringBuffer sb = new StringBuffer();
        ServletInputStream is = request.getInputStream();
        InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        String s = "";
        while ((s = br.readLine()) != null) {
            sb.append(s);
        }
        String xml = sb.toString();
        ReceiveXmlEntity xmlEntity = new ReceiveXmlProcess().getMsgEntity(xml);
        String msgType = xmlEntity.getMsgType();
        if (xmlEntity.getMsgType().equals("event")) {
            if (msgType.equals("event")) {
                String marketer;
                String openId;
                String EventKey;
                String eventType = xmlEntity.getEvent();
                if (eventType.equals("SCAN")) {
                    EventKey = xmlEntity.getEventKey();
                    Date updateDate = new Date();
                    openId = xmlEntity.getFromUserName();
                    marketer = EventKey.replace("qrscene_", "");
                    HashMap<String, Object> updateTimeMap = new HashMap<String, Object>();
                    updateTimeMap.put("openId", openId);
                    updateTimeMap.put("updateTime", updateDate);
                    updateTimeMap.put("doctorMarketer", marketer);
                    this.wechatInfoDao.updateAttentionInfo(updateTimeMap);
                }
                if (eventType.equals("subscribe")) {
                    EventKey = xmlEntity.getEventKey();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    openId = xmlEntity.getFromUserName();
                    marketer = EventKey.replace("qrscene_", "");
                    map.put("openId", openId);
                    map.put("marketer", marketer);
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    map.put("id", id);
                    map.put("status", "0");
                    Map parameter = this.systemService.getWechatParameter();
                    String token = (String)parameter.get("token");
                    WechatBean wechatBean = WechatUtil.getWechatName((String)token, (String)openId);
                    map.put("nickname", EmojiFilter.coverEmoji((String)wechatBean.getNickname()));
                    int attentionNum = this.wechatInfoDao.checkAttention(map);
                    if (attentionNum > 0) {
                        map.put("ispay", 0);
                    } else {
                        map.put("ispay", 1);
                    }
                    this.wechatInfoDao.insertAttentionInfo(map);
                    if ("true".equalsIgnoreCase(this.mongoEnabled)) {
                        WechatAttention attention = new WechatAttention();
                        attention.setId(id);
                        attention.setDate(new Date());
                        attention.setMarketer(marketer);
                        attention.setNickname(wechatBean.getNickname());
                        attention.setOpenid(openId);
                        attention.setStatus("0");
                        this.mongoDBService.insert((Object)attention);
                        MongoLog mongoLog = new MongoLog();
                        mongoLog.setId(id);
                        mongoLog.setCreate_date(new Date());
                        mongoLog.setCreate_by(UserUtils.getUser().getId());
                        mongoLog.setTitle("00000001");
                        mongoLog.setIsPay((String)map.get("ispay"));
                        mongoLog.setNickname(wechatBean.getNickname());
                        mongoLog.setOpen_id(openId);
                        mongoLog.setMarketer(marketer);
                        mongoLog.setStatus((String)map.get("status"));
                        this.mongoLogService.insert((Object)mongoLog);
                    }
                    HttpSession session = request.getSession();
                    session.setAttribute("openId", (Object)xmlEntity.getFromUserName());
                    String st = "";
                    TextMessage textMessage = new TextMessage();
                    textMessage.setToUserName(xmlEntity.getFromUserName());
                    textMessage.setFromUserName(xmlEntity.getToUserName());
                    textMessage.setCreateTime(new Date().getTime());
                    textMessage.setMsgType("text");
                    textMessage.setFuncFlag(0);
                    LogUtils.saveLog((HttpServletRequest)request, (String)"00000092");
                    st = "\u533b\u751f\u60a8\u597d\uff0c\u5b9d\u5927\u592b\u4e13\u5bb6\u7248\uff0c\u4e13\u4e3a\u60a8\u7cbe\u5fc3\u6253\u9020\uff0c\u8ba9\u6211\u4eec\u4e00\u8d77\u7528\u81ea\u5df1\u7684\u4e13\u4e1a\u80fd\u529b\u6765\u5e2e\u52a9\u66f4\u591a\u4eba\uff01\u5982\u9700\u5e2e\u52a9\u8bf7\u81f4\u7535:400-623-7120.";
                    textMessage.setContent(st);
                    respMessage = MessageUtil.textMessageToXml(textMessage);
                    WechatUtil.sendMsgToWechat((String)token, (String)xmlEntity.getFromUserName(), (String)st);
                } else if (eventType.equals("unsubscribe")) {
                    HttpSession session = request.getSession();
                    session.setAttribute("openId", (Object)xmlEntity.getFromUserName());
                    LogUtils.saveLog((HttpServletRequest)request, (String)"00000088");
                    String EventKey2 = xmlEntity.getEventKey();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String openId2 = xmlEntity.getFromUserName();
                    map.put("openId", openId2);
                    String marketer2 = EventKey2.replace("qrscene_", "");
                    map.put("marketer", marketer2);
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    map.put("id", id);
                    map.put("status", "1");
                    this.wechatInfoDao.insertAttentionInfo(map);
                    if ("true".equalsIgnoreCase(this.mongoEnabled)) {
                        WechatAttention attention = new WechatAttention();
                        attention.setId(id);
                        attention.setDate(new Date());
                        attention.setMarketer(marketer2);
                        attention.setOpenid(openId2);
                        attention.setStatus("1");
                        this.mongoDBService.insert((Object)attention);
                        MongoLog mongoLog = new MongoLog();
                        mongoLog.setId(id);
                        mongoLog.setCreate_date(new Date());
                        mongoLog.setCreate_by(UserUtils.getUser().getId());
                        mongoLog.setTitle("00000087");
                        mongoLog.setOpen_id(openId2);
                        mongoLog.setMarketer(marketer2);
                        mongoLog.setStatus((String)map.get("status"));
                        this.mongoLogService.insert((Object)mongoLog);
                    }
                } else if (eventType.equals("LOCATION")) {
                    LogUtils.saveLog((HttpServletRequest)request, (String)"00000093");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", UUID.randomUUID().toString().replaceAll("-", ""));
                    map.put("latitude", xmlEntity.getLatitude());
                    map.put("precision", xmlEntity.getPrecision());
                    map.put("createTime", xmlEntity.getCreateTime());
                    map.put("openid", xmlEntity.getFromUserName());
                    map.put("longitude", xmlEntity.getLongitude());
                    this.wechatInfoDao.insertCustomerLocation(map);
                } else if (eventType.equals("CLICK") && "38".equals(xmlEntity.getEventKey())) {
                    ArrayList<Article> articleList = new ArrayList<Article>();
                    NewsMessage newsMessage = new NewsMessage();
                    newsMessage.setToUserName(xmlEntity.getFromUserName());
                    newsMessage.setFromUserName(xmlEntity.getToUserName());
                    newsMessage.setCreateTime(new Date().getTime());
                    newsMessage.setMsgType("news");
                    newsMessage.setFuncFlag(0);
                    Article article = new Article();
                    article.setTitle("\u5b9d\u5927\u592b\u4e13\u5bb6\u7248\u529f\u80fd\u4ecb\u7ecd");
                    article.setDescription("\u533b\u751f\u5927\u5927,\u5411\u60a8\u8bb2\u8bb2\u5b9d\u5927\u592b\u4e13\u5bb6\u7248\u5982\u4f55\u4f7f\u7528!");
                    article.setPicUrl("http://xiaoerke-doctor-pic.oss-cn-beijing.aliyuncs.com/%E7%BC%A9%E7%95%A5%E5%9B%BE.png");
                    article.setUrl("http://url.cn/28OjeMa");
                    articleList.add(article);
                    newsMessage.setArticleCount(articleList.size());
                    newsMessage.setArticles(articleList);
                    respMessage = MessageUtil.newsMessageToXml(newsMessage);
                }
            }
        } else {
            TextMessage textMessage = new TextMessage();
            textMessage.setToUserName(xmlEntity.getFromUserName());
            textMessage.setFromUserName(xmlEntity.getToUserName());
            textMessage.setCreateTime(new Date().getTime());
            textMessage.setMsgType("transfer_customer_service");
            textMessage.setFuncFlag(0);
            respMessage = MessageUtil.textMessageToXml(textMessage);
        }
        return respMessage;
    }
}

