/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.wechat.service.impl;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.utils.DateUtils;
import com.cxqm.xiaoerke.common.utils.EmojiFilter;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.ReceiveXmlProcess;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.common.utils.WechatUtil;
import com.cxqm.xiaoerke.modules.consult.entity.BabyCoinRecordVo;
import com.cxqm.xiaoerke.modules.consult.entity.BabyCoinVo;
import com.cxqm.xiaoerke.modules.consult.entity.ConsultSession;
import com.cxqm.xiaoerke.modules.consult.entity.ConsultSessionPropertyVo;
import com.cxqm.xiaoerke.modules.consult.entity.OperationPromotionStatusVo;
import com.cxqm.xiaoerke.modules.consult.entity.OperationPromotionVo;
import com.cxqm.xiaoerke.modules.consult.service.BabyCoinService;
import com.cxqm.xiaoerke.modules.consult.service.ConsultSessionPropertyService;
import com.cxqm.xiaoerke.modules.consult.service.ConsultSessionService;
import com.cxqm.xiaoerke.modules.consult.service.OperationPromotionService;
import com.cxqm.xiaoerke.modules.consult.service.SessionRedisCache;
import com.cxqm.xiaoerke.modules.interaction.dao.PatientRegisterPraiseDao;
import com.cxqm.xiaoerke.modules.member.service.MemberService;
import com.cxqm.xiaoerke.modules.sys.entity.Article;
import com.cxqm.xiaoerke.modules.sys.entity.MongoLog;
import com.cxqm.xiaoerke.modules.sys.entity.NewsMessage;
import com.cxqm.xiaoerke.modules.sys.entity.ReceiveXmlEntity;
import com.cxqm.xiaoerke.modules.sys.entity.SysPropertyVoWithBLOBsVo;
import com.cxqm.xiaoerke.modules.sys.entity.TextMessage;
import com.cxqm.xiaoerke.modules.sys.entity.WechatBean;
import com.cxqm.xiaoerke.modules.sys.service.ActivityService;
import com.cxqm.xiaoerke.modules.sys.service.MongoDBService;
import com.cxqm.xiaoerke.modules.sys.service.SysPropertyServiceImpl;
import com.cxqm.xiaoerke.modules.sys.service.SystemService;
import com.cxqm.xiaoerke.modules.sys.service.UtilService;
import com.cxqm.xiaoerke.modules.sys.utils.LogUtils;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import com.cxqm.xiaoerke.modules.wechat.dao.WechatAttentionDao;
import com.cxqm.xiaoerke.modules.wechat.dao.WechatInfoDao;
import com.cxqm.xiaoerke.modules.wechat.entity.HealthRecordMsgVo;
import com.cxqm.xiaoerke.modules.wechat.entity.SpecificChannelInfoVo;
import com.cxqm.xiaoerke.modules.wechat.entity.SpecificChannelRuleVo;
import com.cxqm.xiaoerke.modules.wechat.entity.SysWechatAppintInfoVo;
import com.cxqm.xiaoerke.modules.wechat.entity.TraceElementsVo;
import com.cxqm.xiaoerke.modules.wechat.entity.WechatAttention;
import com.cxqm.xiaoerke.modules.wechat.service.WechatAttentionService;
import com.cxqm.xiaoerke.modules.wechat.service.WechatPatientCoreService;
import com.cxqm.xiaoerke.modules.wechat.service.impl.TraceElementsServiceImpl;
import com.cxqm.xiaoerke.modules.wechat.service.util.MessageUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class WechatPatientCoreServiceImpl
implements WechatPatientCoreService {
    @Autowired
    private WechatInfoDao wechatInfoDao;
    @Autowired
    private WechatAttentionDao wechatAttentionDao;
    @Autowired
    private SystemService systemService;
    @Autowired
    private ConsultSessionService consultConversationService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private MongoDBService<WechatAttention> mongoDBService;
    @Autowired
    private MongoDBService<MongoLog> mongoLogService;
    @Autowired
    private MongoDBService<HealthRecordMsgVo> healthRecordMsgVoMongoDBService;
    @Autowired
    private MemberService memberService;
    private String mongoEnabled = Global.getConfig((String)"mongo.enabled");
    @Autowired
    private PatientRegisterPraiseDao patientRegisterPraiseDao;
    @Autowired
    private WechatAttentionService wechatAttentionService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private BabyCoinService babyCoinService;
    @Autowired
    private MongoDBService<SpecificChannelRuleVo> specificChannelRuleMongoDBService;
    @Autowired
    private MongoDBService<SpecificChannelInfoVo> specificChannelInfoMongoDBService;
    @Autowired
    private OperationPromotionService operationPromotionService;
    @Autowired
    private SysPropertyServiceImpl sysPropertyService;
    @Autowired
    private SessionRedisCache sessionRedisCache;
    @Autowired
    private TraceElementsServiceImpl traceElementsService;
    @Autowired
    private ConsultSessionPropertyService consultSessionPropertyService;
    private Map<String, OperationPromotionVo> keywordMap;
    private static ExecutorService threadExecutor = Executors.newSingleThreadExecutor();

    public String processPatientRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        System.out.println("processPatientRequest===================================");
        String respMessage = "";
        SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo = this.sysPropertyService.querySysProperty();
        ReceiveXmlEntity xmlEntity = new ReceiveXmlProcess().getMsgEntity(this.getXmlDataFromWechat(request));
        String msgType = xmlEntity.getMsgType();
        String openId = xmlEntity.getFromUserName();
        if (msgType.equals("event")) {
            Map userWechatParam = this.sessionRedisCache.getWeChatParamFromRedis("user");
            String token = (String)userWechatParam.get("token");
            String eventType = xmlEntity.getEvent();
            if (eventType.equals("SCAN")) {
                this.updateAttentionInfo(xmlEntity);
                this.specificChanneldeal(xmlEntity, token);
                respMessage = this.processScanEvent(xmlEntity, "oldUser", request, response, sysPropertyVoWithBLOBsVo);
            } else if (eventType.equals("subscribe")) {
                respMessage = this.processSubscribeEvent(xmlEntity, request, response, sysPropertyVoWithBLOBsVo);
            } else if (eventType.equals("unsubscribe")) {
                this.processUnSubscribeEvent(xmlEntity, request);
            } else if (eventType.equals("CLICK")) {
                respMessage = this.processClickMenuEvent(xmlEntity, request, response);
            } else if (eventType.equals("kf_close_session")) {
                respMessage = this.processCloseEvent(xmlEntity, request, response);
            } else if (eventType.equals("LOCATION")) {
                this.processGetLocationEvent(xmlEntity, request);
            }
        } else {
            Map userWechatParam = this.sessionRedisCache.getWeChatParamFromRedis("user");
            String token = (String)userWechatParam.get("token");
            try {
                if (this.keywordRecovery(xmlEntity, token, OperationPromotionStatusVo.KEY_WORD) || this.nonRealTimeCheck(sysPropertyVoWithBLOBsVo.getWhitelist(), xmlEntity, token)) {
                    return "success";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String customerService = Global.getConfig((String)"wechat.customservice");
            if ("false".equals(customerService)) {
                processConsultMessageThread thread = new processConsultMessageThread(xmlEntity);
                threadExecutor.execute(thread);
                return "";
            }
            if ("true".equals(customerService)) {
                respMessage = this.transferToCustomer(xmlEntity);
            }
        }
        return respMessage;
    }

    private void traceElementsDetection(ReceiveXmlEntity xmlEntity, String token) {
        String EventKey = xmlEntity.getEventKey();
        if (!StringUtils.isNotNull((String)EventKey)) {
            return;
        }
        String QRCode = EventKey.replace("qrscene_", "");
        if (QRCode.contains("PD_WLYS_")) {
            String openId = xmlEntity.getFromUserName();
            TraceElementsVo traceElementsVo = this.traceElementsService.selectByOpenid(openId);
            String userNo = DateUtils.formatDateToStr((Date)new Date(), (String)"yyyy MMdd");
            if (null == traceElementsVo) {
                traceElementsVo = new TraceElementsVo();
                traceElementsVo.setOpenid(openId);
                traceElementsVo.setUserNo(userNo);
                traceElementsVo.setCreateTime(new Date());
                this.traceElementsService.insertSelective(traceElementsVo);
            }
            WechatUtil.sendMsgToWechat((String)token, (String)openId, (String)("\u68c0\u6d4b\u7f16\u7801:" + DateUtils.formatDateToStr((Date)traceElementsVo.getCreateTime(), (String)"yyyy MMdd") + " " + String.format("%04d", traceElementsVo.getId()) + "\n\n\u6b64\u7f16\u7801\u662f\u68c0\u6d4b\u60a8\u5b9d\u5b9d\u5fae\u91cf\u5143\u7d20\u7684\u552f\u4e00\u7f16\u7801\uff0c\u8bf7\u5c06\u7f16\u7801\u6807\u6ce8\u5728\u68c0\u6d4b\u6837\u672c\u4e0a\uff0c\u4ee5\u4fbf\u60a8\u80fd\u5373\u65f6\u63a5\u6536\u5230\u68c0\u6d4b\u7ed3\u679c\uff01[\u7231\u5fc3]"));
        }
    }

    private String getXmlDataFromWechat(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        ServletInputStream is = null;
        try {
            is = request.getInputStream();
            InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String processScanEvent(ReceiveXmlEntity xmlEntity, String userType, HttpServletRequest request, HttpServletResponse response, SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo) {
        HashMap<String, String> param1;
        String toOpenId;
        Boolean value;
        String EventKey = xmlEntity.getEventKey();
        System.out.println(EventKey + "EventKey=========================================");
        Article article = new Article();
        ArrayList<Article> articleList = new ArrayList<Article>();
        NewsMessage newsMessage = new NewsMessage();
        newsMessage.setToUserName(xmlEntity.getFromUserName());
        newsMessage.setFromUserName(xmlEntity.getToUserName());
        newsMessage.setCreateTime(new Date().getTime());
        newsMessage.setMsgType("news");
        newsMessage.setFuncFlag(0);
        if (EventKey.indexOf("doc") > -1) {
            Map<String, Object> map = this.wechatInfoDao.getDoctorInfo(EventKey.replace("doc", ""));
            article.setTitle("\u60a8\u5df2\u7ecf\u6210\u529f\u5173\u6ce8" + map.get("hospitalName") + map.get("name") + "\u533b\u751f\uff0c\u70b9\u51fb\u5373\u53ef\u9884\u7ea6");
            article.setDescription("");
            article.setPicUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/images/attentionDoc.jpg");
            article.setUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/appoint#/doctorAppointment/" + map.get("id") + ",,,,,doctorShare,,");
            articleList.add(article);
        }
        if (EventKey.indexOf("month") > -1) {
            if (userType.equals("newUser")) {
                value = this.activityService.judgeActivityValidity(EventKey.replace("qrscene_", ""));
                if (!value.booleanValue()) {
                    article.setTitle("\u6708\u5361");
                    article.setDescription("\u611f\u8c22\u60a8\u5173\u6ce8\u5b9d\u5927\u592b\u7efc\u5408\u80b2\u513f\u670d\u52a1\u5e73\u53f0\uff0c\u5b9d\u5927\u592b\u73b0\u5bf9\u65b0\u7528\u6237\u63a8\u51fa\u6708\u5361\u670d\u52a1\u3002");
                    article.setPicUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/images/Follow.jpg");
                    article.setUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/wechatInfo/getUserWechatMenId?url=21");
                    articleList.add(article);
                    this.memberService.insertMemberSendMessage(xmlEntity.getFromUserName(), "1");
                } else if (value.booleanValue()) {
                    article.setTitle("\u6d3b\u52a8\u5df2\u8fc7\u671f\uff0c\u8d60\u9001\u5468\u4f1a\u5458");
                    article.setDescription("\u60a8\u597d\uff0c\u6b64\u6d3b\u52a8\u5df2\u8fc7\u671f\uff0c\u4e0d\u8fc7\u522b\u62c5\u5fc3\uff0c\u60a8\u4ecd\u53ef\u53c2\u52a0\u514d\u8d39\u4f53\u9a8c\u5b9d\u5927\u592b\u77ed\u671f\u4f1a\u5458\u670d\u52a1");
                    article.setPicUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/images/Follow.jpg");
                    article.setUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/wechatInfo/getUserWechatMenId?url=20");
                    articleList.add(article);
                }
            } else if (userType.equals("oldUser")) {
                article.setDescription("\u611f\u8c22\u60a8\u5173\u6ce8\u5b9d\u5927\u592b\u7efc\u5408\u80b2\u513f\u670d\u52a1\u5e73\u53f0\uff0c\u672c\u6b21\u6d3b\u52a8\u53ea\u9488\u5bf9\u65b0\u5173\u6ce8\u7528\u6237\uff0c\u8bf7\u628a\u8fd9\u4efd\u5e78\u8fd0\u5206\u4eab\u7ed9\u60a8\u8eab\u8fb9\u7684\u5b9d\u5b9d\u5427\uff01\u518d\u6b21\u611f\u8c22\u60a8\u5bf9\u5b9d\u5927\u592b\u7684\u652f\u6301\u4e0e\u4fe1\u4efb\uff01\n\n\u70b9\u51fb\u8fdb\u5165\uff0c\u5168\u65b0\u90d1\u7389\u5de7\u7389\u513f\u7ecf\u514d\u8d39\u67e5\u9605\uff01");
                articleList.add(article);
                article.setUrl("");
            }
        } else if (EventKey.indexOf("quarter") > -1) {
            if (userType.equals("newUser")) {
                value = this.activityService.judgeActivityValidity(EventKey.replace("qrscene_", ""));
                if (!value.booleanValue()) {
                    article.setTitle("\u5b63\u5361");
                    article.setDescription("\u611f\u8c22\u60a8\u5173\u6ce8\u5b9d\u5927\u592b\u7efc\u5408\u80b2\u513f\u670d\u52a1\u5e73\u53f0\uff0c\u5b9d\u5927\u592b\u73b0\u5bf9\u65b0\u7528\u6237\u63a8\u51fa\u5b63\u5361\u670d\u52a1\u3002");
                    article.setPicUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/images/Follow.jpg");
                    article.setUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/wechatInfo/getUserWechatMenId?url=22");
                    articleList.add(article);
                    this.memberService.insertMemberSendMessage(xmlEntity.getFromUserName(), "1");
                } else if (value.booleanValue()) {
                    article.setTitle("\u6d3b\u52a8\u5df2\u8fc7\u671f\uff0c\u8d60\u9001\u5468\u4f1a\u5458");
                    article.setDescription("\u60a8\u597d\uff0c\u6b64\u6d3b\u52a8\u5df2\u8fc7\u671f\uff0c\u4e0d\u8fc7\u522b\u62c5\u5fc3\uff0c\u60a8\u4ecd\u53ef\u53c2\u52a0\u514d\u8d39\u4f53\u9a8c\u5b9d\u5927\u592b\u77ed\u671f\u4f1a\u5458\u670d\u52a1");
                    article.setPicUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/images/Follow.jpg");
                    article.setUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/wechatInfo/getUserWechatMenId?url=20");
                    articleList.add(article);
                }
            } else if (userType.equals("oldUser")) {
                article.setDescription("\u611f\u8c22\u60a8\u5173\u6ce8\u5b9d\u5927\u592b\u7efc\u5408\u80b2\u513f\u670d\u52a1\u5e73\u53f0\uff0c\u672c\u6b21\u6d3b\u52a8\u53ea\u9488\u5bf9\u65b0\u5173\u6ce8\u7528\u6237\uff0c\u8bf7\u628a\u8fd9\u4efd\u5e78\u8fd0\u5206\u4eab\u7ed9\u60a8\u8eab\u8fb9\u7684\u5b9d\u5b9d\u5427\uff01\u518d\u6b21\u611f\u8c22\u60a8\u5bf9\u5b9d\u5927\u592b\u7684\u652f\u6301\u4e0e\u4fe1\u4efb\uff01\n\n\u70b9\u51fb\u8fdb\u5165\uff0c\u5168\u65b0\u90d1\u7389\u5de7\u7389\u513f\u7ecf\u514d\u8d39\u67e5\u9605");
                article.setUrl("http://baodf.com/titan/wechatInfo/fieldwork/wechat/author?url=http://baodf.com/titan/wechatInfo/getUserWechatMenId?url=4");
                articleList.add(article);
            }
        } else if (EventKey.indexOf("xuanjianghuodong_zhengyuqiao_saoma") > -1) {
            article.setDescription("\u60a8\u597d\uff0c\u6b22\u8fce\u5173\u6ce8\uff01\n\n\u70b9\u51fb\u8fdb\u5165\u5b9d\u5927\u592b-\u90d1\u7389\u5de7\u80b2\u513f\u7ecf\uff0c\u4e00\u8d77\u4ea4\u6d41\u5b66\u4e60\u80b2\u513f\u5065\u5eb7\u7ba1\u7406\u77e5\u8bc6\uff01");
            article.setUrl("http://baodf.com/titan/wechatInfo/fieldwork/wechat/author?url=http://baodf.com/titan/wechatInfo/getUserWechatMenId?url=4");
            articleList.add(article);
        } else if (EventKey.indexOf("FQBTG") > -1) {
            article.setTitle("\u9632\u72ac\u5b9d,\u4e00\u4efd\u6e29\u99a8\u7684\u5b89\u5168\u4fdd\u969c");
            article.setDescription("\u53ea\u898119.8\u5143\uff0c\u6253\u72c2\u72ac\u75ab\u82d7\u6700\u9ad8\u53ef\u83b7\u5f97\u4e92\u52a9\u8865\u8d341000\u5143\u3002\u4e0d\u5e78\u60a3\u72c2\u72ac\u75c5\u53ef\u83b7\u5f97\u4e92\u52a9\u8865\u8d345\u4e07\u5143\uff01");
            article.setPicUrl("http://oss-cn-beijing.aliyuncs.com/xiaoerke-article-pic/FQBTGXX.png");
            article.setUrl(sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "/wechatInfo/fieldwork/wechat/author?url=http://s251.baodf.com/keeper/wechatInfo/getUserWechatMenId?url=26");
            articleList.add(article);
        } else {
            String url;
            Map parameter;
            if (EventKey.indexOf("homepage_qualityservices_kuaizixun") > -1) {
                TextMessage textMessage = new TextMessage();
                textMessage.setToUserName(xmlEntity.getFromUserName());
                textMessage.setFromUserName(xmlEntity.getToUserName());
                textMessage.setCreateTime(new Date().getTime());
                textMessage.setMsgType("text");
                textMessage.setFuncFlag(0);
                textMessage.setContent("1\u3001\u70b9\u51fb\u5de6\u4e0b\u89d2\u201c\u5c0f\u952e\u76d8\u201d\u8f93\u5165\u6587\u5b57\u6216\u8bed\u97f3,\u5373\u53ef\u54a8\u8be2\u75be\u75c5\u6216\u4fdd\u5065\u95ee\u9898\t\t\n 2\u3001\u514d\u8d39\u5728\u7ebf\u54a8\u8be2\u65f6\u95f4:\n\u5c0f\u513f\u5185\u79d1:   24\u5c0f\u65f6\u5168\u5929\n\u5c0f\u513f\u76ae\u80a4\u79d1:   9:00~22:00\n\u8425\u517b\u4fdd\u5065\u79d1:   9:00~22:00\n\u5c0f\u513f\u5176\u4ed6\u4e13\u79d1:(\u5916\u79d1\u3001\u773c\u79d1\u3001\u8033\u9f3b\u5589\u79d1\u3001\u53e3\u8154\u79d1\u3001\u9884\u9632\u4fdd\u5065\u79d1\u3001\u4e2d\u533b\u79d1)   19:00~21:00 \n\u5987\u4ea7\u79d1   19:00~22:00");
                return MessageUtil.textMessageToXml(textMessage);
            }
            if (EventKey.indexOf("homepage_qualityservices_mingyimianzhen") > -1) {
                article.setTitle("\u540d\u533b\u9762\u8bca");
                article.setDescription("\u4e09\u7532\u533b\u9662\u513f\u79d1\u4e13\u5bb6\uff0c\u7ebf\u4e0a\u51c6\u65f6\u9884\u7ea6\uff0c\u7ebf\u4e0b\u51c6\u65f6\u5c31\u8bca\u3002");
                article.setPicUrl("http://xiaoerke-pc-baodf-pic.oss-cn-beijing.aliyuncs.com/gw%2Fmingyimianzhen");
                article.setUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/firstPage/appoint");
                articleList.add(article);
            } else if (EventKey.indexOf("homepage_qualityservices_mingyidianhua") > -1) {
                article.setTitle("\u540d\u533b\u7535\u8bdd");
                article.setDescription("\u6743\u5a01\u513f\u79d1\u4e13\u5bb6\uff0c10\u5206\u949f\u901a\u8bdd\uff0c\u4e2a\u6027\u5316\u5c31\u8bca\u548c\u5eb7\u590d\u6307\u5bfc\u3002");
                article.setPicUrl("http://xiaoerke-pc-baodf-pic.oss-cn-beijing.aliyuncs.com/gw%2Fmingyidianhua");
                article.setUrl(sysPropertyVoWithBLOBsVo.getTitanWebUrl() + "/titan/firstPage/phoneConsult");
                articleList.add(article);
            } else if (EventKey.indexOf("qrscene_12") > -1 || EventKey.indexOf("qrscene_13") > -1) {
                toOpenId = xmlEntity.getFromUserName();
                param1 = new HashMap();
                param1.put("openid", toOpenId);
                boolean sendsucmes = false;
                System.out.println(sendsucmes + "sendsucmes=============sendsucmes============================");
                if (sendsucmes) {
                    article.setTitle("\u606d\u559c\u60a8");
                    article.setDescription("\u60a8\u5df2\u6210\u529f\u9886\u523020\u4e07\u4fdd\u969c\uff0c\u5206\u4eab1\u4e2a\u597d\u53cb\uff0c\u63d0\u53472\u4e07\u4fdd\u969c\uff0c\u6700\u9ad8\u53ef\u4eab\u53d740\u4e07\u4fdd\u969c\u3002\n\n\u70b9\u51fb\u8fdb\u5165\uff0c\u7acb\u5373\u5206\u4eab\uff01");
                    article.setPicUrl("http://xiaoerke-wxapp-pic.oss-cn-hangzhou.aliyuncs.com/protectumbrella%2Fprotectumbrella");
                    article.setUrl("http://s251.baodf.com/keeper/wechatInfo/fieldwork/wechat/author?url=http://s251.baodf.com/keeper/wechatInfo/getUserWechatMenId?url=31");
                    articleList.add(article);
                }
            } else if (EventKey.indexOf("qrscene_99") > -1) {
                String openId = xmlEntity.getFromUserName();
                String marketer = EventKey.replace("qrscene_", "");
                StringBuffer sbf = new StringBuffer("12");
                HashMap map = new HashMap();
                HashMap<String, String> openIdMap = new HashMap<String, String>();
                openIdMap.put("openId", openId);
                Object openIdAndPhoneList = null;
            } else if (EventKey.indexOf("qrscene_15") > -1 || EventKey.startsWith("150")) {
                Integer openLevel = Integer.parseInt(Global.getConfig((String)"OPEN_LEVEL"));
                parameter = this.systemService.getWechatParameter();
                String token = (String)parameter.get("token");
                if (EventKey.indexOf("150100000") > -1) {
                    String st = "\u6b22\u8fce\u806a\u660e\u7684\u4f60\u6765\u5230\u201c\u5b9d\u5927\u592b\u201d\uff0c\u5411\u4f60\u63a8\u8350\u5b9d\u5b9d\u5965\u8fd0\u5927\u95ef\u5173\u6e38\u620f\uff0c<a href='http://s68.baodf.com/titan/appoint#/userEvaluate'>\u8d76\u7d27\u73a9\u8d77\u6765\u5427\uff01</a>";
                    WechatUtil.sendMsgToWechat((String)token, (String)xmlEntity.getFromUserName(), (String)st);
                }
            } else if (EventKey.indexOf("yufangjiezhong") > -1) {
                sendHasCardDoctorWechatMessage thread = new sendHasCardDoctorWechatMessage(EventKey, xmlEntity);
                threadExecutor.execute(thread);
            } else if (EventKey.indexOf("PD_TPCB") > -1) {
                LogUtils.saveLog((String)"TPCB_GZTS", (String)xmlEntity.getFromUserName());
                url = sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "keeper/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "keeper/wechatInfo/getUserWechatMenId?url=44";
                parameter = this.systemService.getWechatParameter();
                String token = (String)parameter.get("token");
                WechatUtil.sendMsgToWechat((String)token, (String)xmlEntity.getFromUserName(), (String)("2016\u5e74\u5e74\u672b\u4f60\u548c\u5b9d\u5b9d\u4f1a\u53d1\u751f\u4ec0\u4e48\uff1f\uff1f\n\u54c8\u54c8\u54c8\uff0c\u597d\u641e\u7b11\n\n<a href='" + url + "'>\u6765\u641e\u4e8b\u60c5\u5427>></a>"));
            } else if (EventKey.indexOf("PD_YQKFC") > -1) {
                LogUtils.saveLog((String)"TPCB_GZTS", (String)xmlEntity.getFromUserName());
                url = sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "keeper/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "keeper/wechatInfo/getUserWechatMenId?url=44";
                parameter = this.systemService.getWechatParameter();
                String token = (String)parameter.get("token");
                WechatUtil.sendMsgToWechat((String)token, (String)xmlEntity.getFromUserName(), (String)"\u70b9\u51fb\u5de6\u4e0b\u89d2\u5c0f\u952e\u76d8\uff0c\u8d76\u5feb\u54a8\u8be2\u5427~");
            }
        }
        toOpenId = xmlEntity.getFromUserName();
        param1 = new HashMap<String, String>();
        param1.put("openid", toOpenId);
        if (articleList.size() == 0) {
            return "";
        }
        newsMessage.setArticleCount(articleList.size());
        newsMessage.setArticles(articleList);
        String respMessage = MessageUtil.newsMessageToXml(newsMessage);
        return respMessage;
    }

    public String addUserType(String id) {
        Map parameter = this.systemService.getWechatParameter();
        String token = (String)parameter.get("token");
        String url = "https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging?access_token=" + token;
        String jsonData = "{\"openid_list\":[\"" + id + "\"],\"tagid\" : 105}";
        String reJson = this.post(url, jsonData, "POST");
        System.out.println(reJson);
        JSONObject jb = JSONObject.fromObject((Object)reJson);
        String errmsg = jb.getString("errmsg");
        if (errmsg.equals("ok")) {
            return "ok";
        }
        return errmsg;
    }

    public String post(String strURL, String params, String type) {
        System.out.println(strURL);
        System.out.println(params);
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod(type);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            out.append(params);
            out.flush();
            out.close();
            int length = connection.getContentLength();
            InputStream is = connection.getInputStream();
            if (length != -1) {
                byte[] data = new byte[length];
                byte[] temp = new byte[512];
                int readLen = 0;
                int destPos = 0;
                while ((readLen = is.read(temp)) > 0) {
                    System.arraycopy(temp, 0, data, destPos, readLen);
                    destPos += readLen;
                }
                String result = new String(data, "UTF-8");
                System.out.println(result);
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String processSubscribeEvent(ReceiveXmlEntity xmlEntity, HttpServletRequest request, HttpServletResponse response, SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo) {
        Map parameter = this.systemService.getWechatParameter();
        String token = (String)parameter.get("token");
        String EventKey = xmlEntity.getEventKey();
        String marketer = "";
        if (StringUtils.isNotNull((String)EventKey)) {
            marketer = EventKey.replace("qrscene_", "");
        }
        this.babyCoinHandler(xmlEntity, token, marketer);
        this.insertAttentionInfo(xmlEntity, token, marketer);
        this.specificChanneldeal(xmlEntity, token);
        return this.sendSubScribeMessage(xmlEntity, request, response, marketer, token, sysPropertyVoWithBLOBsVo);
    }

    private synchronized void specificChanneldeal(ReceiveXmlEntity xmlEntity, String token) {
        String EventKey = xmlEntity.getEventKey();
        String eventType = xmlEntity.getEvent();
        String openid = xmlEntity.getFromUserName();
        SysWechatAppintInfoVo sysWechatAppintInfoVo = new SysWechatAppintInfoVo();
        sysWechatAppintInfoVo.setOpen_id(openid);
        SysWechatAppintInfoVo wechatAttentionVo = this.wechatAttentionService.findAttentionInfoByOpenId(sysWechatAppintInfoVo);
        Query queryDate = new Query();
        List ruleList = this.specificChannelRuleMongoDBService.queryList(queryDate);
        for (SpecificChannelRuleVo vo : ruleList) {
            if (!EventKey.contains(vo.getQrcode())) continue;
            queryDate = new Query();
            Criteria criteria = Criteria.where((String)"openid").is((Object)openid);
            queryDate.addCriteria((CriteriaDefinition)criteria);
            queryDate.with(new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "date")})).limit(1);
            List infoList = this.specificChannelInfoMongoDBService.queryList(queryDate);
            if (infoList.size() == 0) {
                WechatUtil.sendMsgToWechat((String)token, (String)openid, (String)vo.getDocuments());
                BabyCoinVo babyCoin = new BabyCoinVo();
                babyCoin.setOpenId(openid);
                babyCoin = this.babyCoinService.selectByBabyCoinVo(babyCoin);
                if (null == babyCoin || null == babyCoin.getCash()) {
                    babyCoin = new BabyCoinVo();
                    babyCoin.setCash(vo.getBabyCoin());
                    babyCoin.setCreateBy(openid);
                    babyCoin.setCreateTime(new Date());
                    babyCoin.setOpenId(openid);
                    babyCoin.setNickName(wechatAttentionVo.getWechat_name());
                    BabyCoinVo lastBabyCoinUser = new BabyCoinVo();
                    lastBabyCoinUser.setCreateTime(new Date());
                    lastBabyCoinUser = this.babyCoinService.selectByBabyCoinVo(lastBabyCoinUser);
                    if (lastBabyCoinUser == null || lastBabyCoinUser.getMarketer() == null) {
                        babyCoin.setMarketer("110000000");
                    } else {
                        babyCoin.setMarketer(String.valueOf(Integer.valueOf(lastBabyCoinUser.getMarketer()) + 1));
                    }
                    this.babyCoinService.insertBabyCoinSelective(babyCoin);
                } else {
                    babyCoin.setCash(vo.getBabyCoin());
                    this.babyCoinService.updateCashByOpenId(babyCoin);
                }
                SpecificChannelInfoVo channelVo = new SpecificChannelInfoVo();
                channelVo.setId(IdGen.uuid());
                channelVo.setBabyCoin(vo.getBabyCoin());
                channelVo.setCreateTime(new Date());
                channelVo.setOpenid(openid);
                channelVo.setQrcode(vo.getQrcode());
                this.specificChannelInfoMongoDBService.insert((Object)channelVo);
                continue;
            }
            WechatUtil.sendMsgToWechat((String)token, (String)openid, (String)vo.getRepeatdocuments());
        }
    }

    private void babyCoinHandler(ReceiveXmlEntity xmlEntity, String token, String marketer) {
        if (marketer.startsWith("110")) {
            SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo = this.sysPropertyService.querySysProperty();
            String newOpenId = xmlEntity.getFromUserName();
            SysWechatAppintInfoVo sysWechatAppintInfoVo = new SysWechatAppintInfoVo();
            sysWechatAppintInfoVo.setOpen_id(newOpenId);
            SysWechatAppintInfoVo wechatAttentionVo = this.wechatAttentionService.findAttentionInfoByOpenId(sysWechatAppintInfoVo);
            if (wechatAttentionVo == null) {
                BabyCoinVo olderUser = new BabyCoinVo();
                String cash = sysPropertyVoWithBLOBsVo.getBabyCoin();
                olderUser.setMarketer(marketer);
                olderUser = this.babyCoinService.selectByBabyCoinVo(olderUser);
                String oldOpenId = olderUser.getOpenId();
                if (olderUser.getInviteNumberMonth() <= 20) {
                    Long preCash = olderUser.getCash();
                    olderUser.setCash(Long.valueOf(cash));
                    olderUser.setInviteNumberMonth(Integer.valueOf(1));
                    this.babyCoinService.updateCashByOpenId(olderUser);
                    Long afterCash = preCash + Long.valueOf(cash);
                    BabyCoinRecordVo babyCoinRecordVo = new BabyCoinRecordVo();
                    babyCoinRecordVo.setBalance(Double.valueOf(sysPropertyVoWithBLOBsVo.getBabyCoin()).doubleValue());
                    babyCoinRecordVo.setCreateTime(new Date());
                    babyCoinRecordVo.setCreateBy(oldOpenId);
                    babyCoinRecordVo.setOpenId(oldOpenId);
                    babyCoinRecordVo.setSource("invitePresent");
                    int recordflag = this.babyCoinService.insertBabyCoinRecord(babyCoinRecordVo);
                    if (recordflag == 0) {
                        throw new RuntimeException("\u5b9d\u5b9d\u5e01\u63d2\u5165\u5f02\u5e38");
                    }
                    String content = "\u606d\u559c\u60a8\u83b7\u5f974\u6b21\u514d\u8d39\u54a8\u8be2\u513f\u79d1\u4e13\u5bb6\u7684\u673a\u4f1a\u3002\n\u70b9\u51fb\u5de6\u4e0b\u89d2\u5c0f\u952e\u76d8\uff0c\u5373\u53ef\u54a8\u8be2\u533b\u751f\u3002";
                    WechatUtil.sendMsgToWechat((String)token, (String)newOpenId, (String)content);
                    WechatBean wechatBean = WechatUtil.getWechatName((String)token, (String)newOpenId);
                    String newUserNickName = wechatBean.getNickname();
                    if (StringUtils.isNull((String)newUserNickName)) {
                        newUserNickName = wechatAttentionVo != null && wechatAttentionVo.getWechat_name() != null ? wechatAttentionVo.getWechat_name() : "\u4e86\u4e00\u4f4d\u670b\u53cb";
                    }
                    LogUtils.saveLog((String)("\u8001\u7528\u6237\u5269\u4f59\u7684\u5b9d\u5b9d\u5e01\u6570=" + afterCash + "\u9080\u8bf7\u7684\u597d\u53cb\u4e3a\uff1a" + newUserNickName), (String)oldOpenId);
                    String title = "\u606d\u559c\u60a8\u6210\u529f\u9080\u8bf7 " + newUserNickName + " \u52a0\u5165\u5b9d\u5927\u592b\uff0c\u60a8\u7684\u60a8\u7684\u5b9d\u5b9d\u5e01\u5c06\u589e\u52a0" + cash + "\u679a\uff01";
                    String templateId = sysPropertyVoWithBLOBsVo.getTemplateIdYWDTTX();
                    String keyword1 = "\u4e1a\u52a1\u8fdb\u5ea6\uff1a\u60a8\u7684\u5b9d\u5b9d\u5e01\u4f59\u989d\u4e3a " + afterCash + "\u679a";
                    String keyword2 = "\u60a8\u6709" + afterCash / 99L + "\u6b21\u514d\u8d39\u54a8\u8be2\u4e13\u5bb6\u7684\u673a\u4f1a\uff0c\u672c\u6708\u8fd8\u53ef\u9080\u8bf7\u597d\u53cb" + (20 - olderUser.getInviteNumberMonth()) + "\u6b21";
                    String remark = "\u9080\u8bf7\u66f4\u591a\u597d\u53cb\u52a0\u5165>\uff0c\u83b7\u5f97\u66f4\u591a\u673a\u4f1a\uff01";
                    String url = sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "keeper/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "keeper/wechatInfo/getUserWechatMenId?url=42,ZXYQ_YQY_MBXX";
                    String templateInfo = "\"first\": {\"value\":" + title + ",\"color\":\"#FF0000\"},\"keynote1\":{ \"value\":" + keyword1 + ",, \"color\":\"#000000\"},\"keynote2\": { \"value\":" + keyword2 + ", \"color\":\"#000000\" }, \"remark\":{ \"value\":" + remark + ",\"color\":\"#FF0000\"}";
                    WechatUtil.sendTemplateMsgToUser((String)token, (String)oldOpenId, (String)templateId, (String)templateInfo);
                }
            }
        }
    }

    private void insertAttentionInfo(ReceiveXmlEntity xmlEntity, String token, String marketer) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String openId = xmlEntity.getFromUserName();
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        WechatBean wechatBean = WechatUtil.getWechatName((String)token, (String)openId);
        map.put("id", id);
        map.put("status", "0");
        map.put("openId", openId);
        map.put("marketer", marketer);
        map.put("doctorMarketer", marketer);
        map.put("updateTime", new Date());
        map.put("nickname", EmojiFilter.coverEmoji((String)wechatBean.getNickname()));
        int attentionNum = this.wechatInfoDao.checkAttention(map);
        if (attentionNum > 0) {
            map.put("ispay", 0);
        } else {
            map.put("ispay", 1);
        }
        this.wechatInfoDao.insertAttentionInfo(map);
        if ("true".equalsIgnoreCase(this.mongoEnabled)) {
            WechatAttention attention = new WechatAttention();
            attention.setId(id);
            attention.setDate(new Date());
            attention.setMarketer(marketer);
            attention.setNickname(wechatBean.getNickname());
            attention.setOpenid(openId);
            attention.setStatus("0");
            this.mongoDBService.insert((Object)attention);
            MongoLog mongoLog = new MongoLog();
            mongoLog.setId(IdGen.uuid());
            mongoLog.setCreate_by(UserUtils.getUser().getId());
            mongoLog.setCreate_date(new Date());
            mongoLog.setTitle("00000001");
            mongoLog.setIsPay(map.get("ispay").toString());
            mongoLog.setNickname((String)map.get("nickname"));
            mongoLog.setOpen_id(openId);
            mongoLog.setMarketer(marketer);
            mongoLog.setStatus((String)map.get("status"));
            this.mongoLogService.insert((Object)mongoLog);
        }
    }

    private void updateAttentionInfo(ReceiveXmlEntity xmlEntity) {
        String EventKey = xmlEntity.getEventKey();
        Date updateDate = new Date();
        String openId = xmlEntity.getFromUserName();
        String marketer = EventKey.replace("qrscene_", "");
        HashMap<String, Object> updateTimeMap = new HashMap<String, Object>();
        updateTimeMap.put("openId", openId);
        updateTimeMap.put("updateTime", updateDate);
        updateTimeMap.put("doctorMarketer", marketer);
        this.wechatInfoDao.updateAttentionInfo(updateTimeMap);
    }

    private String sendSubScribeMessage(ReceiveXmlEntity xmlEntity, HttpServletRequest request, HttpServletResponse response, String marketer, String token, SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo) {
        HttpSession session = request.getSession();
        session.setAttribute("openId", (Object)xmlEntity.getFromUserName());
        LogUtils.saveLog((HttpServletRequest)request, (String)"00000001");
        String EventKey = xmlEntity.getEventKey();
        if (EventKey.indexOf("xuanjianghuodong_zhengyuqiao_saoma") <= -1 && EventKey.indexOf("baoxian_000001") <= -1 && EventKey.indexOf("YY0016") <= -1 && EventKey.indexOf("YY0018") <= -1) {
            String welcomeMsg = "\u5f88\u9ad8\u5174\u9047\u89c1\u60a8\uff01\u6211\u4eec\u662f\u4e00\u7fa4\u6709\u7231\u53c8\u4e13\u4e1a\u7684\u533b\u751f\u670b\u53cb\u3002\ue022 \n\n\u5728\u8fd9\u91cc\uff0c\u60a8\u53ef\u4ee524H\u968f\u65f6\u54a8\u8be2\u5987\u4ea7\u79d1\u548c\u513f\u79d1\u4e13\u5bb6\uff01\ud83c\udfe5\u79d1\u5ba4\u9f50\u5168\uff0c\u56de\u590d\u8d85\u5feb\uff01\ud83d\ude80 \u70b9\u51fb:<a href='http://mp.weixin.qq.com/s?__biz=MzI2MDAxOTY3OQ==&mid=504236660&idx=1&sn=10d923526047a5276dd9452b7ed1e302&scene=1&srcid=0612OCo7d5ASBoGRr2TDgjfR#rd'>\u54a8\u8be2\u5927\u592b</a> \n\n\u8fd8\u53ef\u4e70\u5230\u5404\u5927\u540d\u724c\u6bcd\u5a74\u4ea7\u54c1\uff0c\u8db3\u4e0d\u51fa\u6237\u4eab\u53d7\u6700\u771f\u3001\u6700\u5feb\u3001\u6700\u4f18\u7684\u5b9e\u60e0\u5546\u54c1\ud83d\udc9d\u3002\u70b9\u51fb\uff1a<a href='https://shop17975201.koudaitong.com/v2/home/4z2f8goy?reft=1477987510078&spm=g305026344&oid=0&sf=wx_sm'>\u7acb\u5373\u8d2d\u4e70</a>\n\n\u66f4\u53ef\u968f\u65f6\u5b66\u4e60\u80b2\u513f\u77e5\u8bc6\ud83d\udc76\uff0c\u548c\u5343\u4e07\u5b9d\u5b9d\u4e00\u540c\u5feb\u4e50\u6210\u957f\ud83d\udc6a\uff01\u70b9\u51fb\uff1a<a href='https://mp.weixin.qq.com/mp/profile_ext?action=home&__biz=MzI2MDAxOTY3OQ==&from=singlemessage&isappinstalled=0&scene=116#wechat_redirect'>\u5b66\u4e60\u77e5\u8bc6</a>";
            WechatUtil.sendMsgToWechat((String)token, (String)xmlEntity.getFromUserName(), (String)welcomeMsg);
        }
        return this.processScanEvent(xmlEntity, "newUser", request, response, sysPropertyVoWithBLOBsVo);
    }

    private void processUnSubscribeEvent(ReceiveXmlEntity xmlEntity, HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setAttribute("openId", (Object)xmlEntity.getFromUserName());
        LogUtils.saveLog((HttpServletRequest)request, (String)"00000002");
        HashMap<String, Object> map = new HashMap<String, Object>();
        String openId = xmlEntity.getFromUserName();
        map.put("openId", openId);
        WechatAttention wechatAttention = new WechatAttention();
        wechatAttention.setOpenid(openId);
        wechatAttention = this.wechatAttentionDao.findMarketerByOpeinid(wechatAttention);
        if (null != wechatAttention) {
            map.put("marketer", wechatAttention.getMarketer());
        }
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        map.put("id", id);
        map.put("status", "1");
        this.wechatInfoDao.insertAttentionInfo(map);
        if ("true".equalsIgnoreCase(this.mongoEnabled)) {
            WechatAttention attention = new WechatAttention();
            attention.setId(id);
            attention.setDate(new Date());
            if (null != wechatAttention) {
                attention.setMarketer(wechatAttention.getMarketer());
            }
            attention.setOpenid(openId);
            attention.setStatus("1");
            this.mongoDBService.insert((Object)attention);
            MongoLog mongoLog = new MongoLog();
            mongoLog.setId(IdGen.uuid());
            mongoLog.setCreate_by(UserUtils.getUser().getId());
            mongoLog.setTitle("00000002");
            mongoLog.setOpen_id((String)map.get("openId"));
            mongoLog.setStatus((String)map.get("status"));
            this.mongoLogService.insert((Object)mongoLog);
        }
    }

    private String processClickMenuEvent(ReceiveXmlEntity xmlEntity, HttpServletRequest request, HttpServletResponse response) {
        String respMessage = "";
        if ("39".equals(xmlEntity.getEventKey())) {
            TextMessage textMessage = new TextMessage();
            textMessage.setToUserName(xmlEntity.getFromUserName());
            textMessage.setFromUserName(xmlEntity.getToUserName());
            textMessage.setCreateTime(new Date().getTime());
            textMessage.setMsgType("text");
            textMessage.setFuncFlag(0);
            String st = "\u60a8\u597d\uff0c\u6211\u662f\u5b9d\u5927\u592b\u4e13\u804c\u533b\u62a4\uff0c\u613f\u4e3a\u60a8\u63d0\u4f9b\u533b\u5b66\u670d\u52a1\uff0c\u534f\u52a9\u9884\u7ea6\u513f\u79d1\u4e13\u5bb6\uff0c\u8bf7\u60a8\u62e8\u6253\uff1a400-623-7120\u3002";
            textMessage.setContent(st);
            respMessage = MessageUtil.textMessageToXml(textMessage);
        } else if ("38".equals(xmlEntity.getEventKey())) {
            HttpSession session = request.getSession();
            session.setAttribute("openId", (Object)xmlEntity.getFromUserName());
            LogUtils.saveLog((HttpServletRequest)request, (String)"00000003");
            Map parameter = this.systemService.getWechatParameter();
            String token = (String)parameter.get("token");
            ArrayList<Article> articleList = new ArrayList<Article>();
            Article article = new Article();
            article.setTitle("\u4e09\u7532\u533b\u9662\u5987\u513f\u4e13\u5bb6    \u54a8\u8be2\u79d2\u56de\u4e0d\u7b49\u5f85");
            article.setDescription("\u5c0f\u513f\u5185\u79d1:       24\u5c0f\u65f6\u5168\u5929 \n\n\u5c0f\u513f\u76ae\u80a4\u79d1/\u4fdd\u5065\u79d1:   8:00 ~ 23:00\n\n\u5987\u4ea7\u79d1:   8:00 ~ 23:00\n\n\u5c0f\u513f\u5176\u4ed6\u4e13\u79d1:   19:00 ~ 21:00\n\n(\u5916\u79d1\u3001\u773c\u79d1\u3001\u8033\u9f3b\u5589\u79d1\u3001\u53e3\u8154\u79d1\u3001\u9884\u9632\u63a5\u79cd\u79d1\u3001\u4e2d\u533b\u79d1)\n\n\u70b9\u51fb\u5de6\u4e0b\u89d2\u952e\u76d8,\u8f93\u5165\u5185\u5bb9\u6216\u8bed\u97f3\u5373\u53ef\u54a8\u8be2");
            article.setPicUrl("http://xiaoerke-wxapp-pic.oss-cn-hangzhou.aliyuncs.com/menu/%E9%A6%96%E9%A1%B5.png");
            article.setUrl("https://mp.weixin.qq.com/s?__biz=MzI2MDAxOTY3OQ==&mid=504236660&idx=1&sn=10d923526047a5276dd9452b7ed1e302&scene=1&srcid=0612OCo7d5ASBoGRr2TDgjfR&key=f5c31ae61525f82ed83c573369e70b8f9b853c238066190fb5eb7b8640946e0a090bbdb47e79b6d2e57b615c44bd82c5&ascene=0&uin=MzM2NjEyMzM1&devicetype=iMac+MacBookPro11%2C4+OSX+OSX+10.11.4+build(15E65)&version=11020201&pass_ticket=dG5W6eOP3JU1%2Fo3JXw19SFBAh1DgpSlQrAXTyirZuj970HMU7TYojM4D%2B2LdJI9n");
            articleList.add(article);
            WechatUtil.senImgMsgToWechat((String)token, (String)xmlEntity.getFromUserName(), articleList);
            this.memberService.sendExtendOldMemberWechatMessage(xmlEntity.getFromUserName());
        } else if ("36".equals(xmlEntity.getEventKey())) {
            ArrayList<Article> articleList = new ArrayList<Article>();
            NewsMessage newsMessage = new NewsMessage();
            newsMessage.setToUserName(xmlEntity.getFromUserName());
            newsMessage.setFromUserName(xmlEntity.getToUserName());
            newsMessage.setCreateTime(new Date().getTime());
            newsMessage.setMsgType("news");
            newsMessage.setFuncFlag(0);
            Article article = new Article();
            article.setTitle("\u54a8\u8be2\u5927\u592b\uff0c\u8bf7\u5173\u6ce8\u6700\u65b0\u516c\u4f17\u8d26\u53f7!");
            article.setDescription("\u516c\u544a\uff1a\u672c\u516c\u4f17\u53f7\u5c06\u4e8e2015\u5e748\u67089\u65e5\u8d77\u505c\u6b62\u670d\u52a1\u3002\u9700\u8981\u54a8\u8be2\u5927\u592b\uff0c\u8bf7\u5988\u5988\u4eec\u8bc6\u522b\u4e8c\u7ef4\u7801\u5173\u6ce8\u6700\u65b0\u7684\u516c\u4f17\u53f7\uff08\u5fae\u4fe1\u53f7\uff1aBaodfWX\uff09\u3002\u4e13\u4e1a\u7684\u5927\u592b\u5728\u7ebf\u7b49\u60a8\u6765\u54a8\u8be2\u54e6\uff01");
            article.setPicUrl("http://mmbiz.qpic.cn/mmbiz/dGa0GvlZMicotZvyd4ZkHKjYe3ERsP5OD0spQbFz1CPTdqqWjrP1s5pr4BpDxvM97NgYNm4PiazfHv37t6kbP9dw/640?wx_fmt=jpeg&wxfrom=5");
            article.setUrl("http://mp.weixin.qq.com/s?__biz=MzI0MjAwNjY0Nw==&mid=208340985&idx=1&sn=2beb0d78fc9097f10d073e182f1cb6c1&scene=0#rd");
            articleList.add(article);
            newsMessage.setArticleCount(articleList.size());
            newsMessage.setArticles(articleList);
            respMessage = MessageUtil.newsMessageToXml(newsMessage);
        }
        return respMessage;
    }

    private String processCloseEvent(ReceiveXmlEntity xmlEntity, HttpServletRequest request, HttpServletResponse response) {
        String respMessage = null;
        String openId = xmlEntity.getFromUserName();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("openid", openId);
        params.put("uuid", UUID.randomUUID().toString().replaceAll("-", ""));
        params.put("starNum1", 0);
        params.put("starNum2", 0);
        params.put("starNum3", 0);
        params.put("doctorId", xmlEntity.getKfAccount());
        params.put("content", "");
        params.put("dissatisfied", null);
        params.put("redPacket", null);
        params.put("evaluateSource", "realtimeConsult");
        this.patientRegisterPraiseDao.saveCustomerEvaluation(params);
        String st = "\u611f\u8c22\u60a8\u5bf9\u6211\u4eec\u7684\u4fe1\u4efb\u4e0e\u652f\u6301\uff0c\u4e3a\u4e86\u4ee5\u540e\u80fd\u66f4\u597d\u7684\u4e3a\u60a8\u670d\u52a1\uff0c\u8bf7\u5bf9\u672c\u6b21\u670d\u52a1\u505a\u51fa\u8bc4\u4ef7\uff01\u3010<a href='http://s68.baodf.com/titan/appoint#/userEvaluate/" + params.get("uuid") + "'>\u6211\u8981\u8bc4\u4ef7</a>\u3011";
        Map parameter = this.systemService.getWechatParameter();
        String token = (String)parameter.get("token");
        WechatUtil.sendMsgToWechat((String)token, (String)openId, (String)st);
        LogUtils.saveLog((HttpServletRequest)request, (String)"00000004");
        return respMessage;
    }

    private void processGetLocationEvent(ReceiveXmlEntity xmlEntity, HttpServletRequest request) {
        LogUtils.saveLog((HttpServletRequest)request, (String)"00000005");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", UUID.randomUUID().toString().replaceAll("-", ""));
        map.put("latitude", xmlEntity.getLatitude());
        map.put("precision", xmlEntity.getPrecision());
        map.put("createTime", xmlEntity.getCreateTime());
        map.put("openid", xmlEntity.getFromUserName());
        map.put("longitude", xmlEntity.getLongitude());
        this.wechatInfoDao.insertCustomerLocation(map);
    }

    private String transferToCustomer(ReceiveXmlEntity xmlEntity) {
        ConsultSession vo = new ConsultSession();
        vo.setUpdateTime(new Date());
        vo.setStatus("0");
        vo.setUserId(xmlEntity.getFromUserName());
        vo.setCreateTime(new Date());
        String title = UUID.randomUUID().toString().replaceAll("-", "");
        vo.setTitle(title);
        vo.setCsUserId("110@BaodfWX");
        this.consultConversationService.saveConsultInfo(vo);
        return "<xml><ToUserName><![CDATA[" + xmlEntity.getFromUserName() + "]]></ToUserName><FromUserName><![CDATA[" + xmlEntity.getToUserName() + "]]></FromUserName><CreateTime><![CDATA[" + new Date().getTime() + "]]></CreateTime><MsgType><![CDATA[transfer_customer_service]]></MsgType>" + "</xml>";
    }

    public boolean findHealthRecordMsgByOpenid(String openid, String type) {
        HealthRecordMsgVo healthRecordMsgVo = new HealthRecordMsgVo();
        healthRecordMsgVo.setOpenId(openid);
        Query queryRecord = new Query();
        Date date = new Date();
        date.setHours(0);
        queryRecord.addCriteria((CriteriaDefinition)Criteria.where((String)"open_id").is((Object)openid).and("create_date").gte((Object)date));
        Long RecordCount = this.healthRecordMsgVoMongoDBService.queryCount(queryRecord);
        return RecordCount != 0L;
    }

    public int insertHealthRecordMsg(HealthRecordMsgVo healthRecordMsgVo) {
        healthRecordMsgVo.setId(IdGen.uuid());
        healthRecordMsgVo.setCreate_date(new Date());
        healthRecordMsgVo.setOpen_id(healthRecordMsgVo.getOpenId());
        healthRecordMsgVo.setOpenId(null);
        return this.healthRecordMsgVoMongoDBService.insert((Object)healthRecordMsgVo);
    }

    public boolean keywordRecovery(ReceiveXmlEntity xmlEntity, String token, OperationPromotionStatusVo type) {
        OperationPromotionVo roleInfo;
        if (null == this.keywordMap) {
            this.keywordMap = this.operationPromotionService.getAllRoleListByKeyword();
        }
        if (null == (roleInfo = this.keywordMap.get(xmlEntity.getContent())) || !roleInfo.getMessageType().equals(type.getVariable())) {
            return false;
        }
        if (StringUtils.isNotNull((String)roleInfo.getReplyText())) {
            WechatUtil.sendMsgToWechat((String)token, (String)xmlEntity.getFromUserName(), (String)roleInfo.getReplyText());
        }
        if (StringUtils.isNotNull((String)roleInfo.getReplyPicId())) {
            for (String mediaId : roleInfo.getReplyPicId().split(",")) {
                if (!StringUtils.isNotNull((String)mediaId)) continue;
                WechatUtil.sendNoTextMsgToWechat((String)token, (String)xmlEntity.getFromUserName(), (String)mediaId, (int)1);
            }
        }
        return true;
    }

    public boolean nonRealTimeCheck(String whitelist, ReceiveXmlEntity xmlEntity, String token) {
        String openid = xmlEntity.getFromUserName();
        SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo = this.sysPropertyService.querySysProperty();
        System.out.println("\u767d\u540d\u5355:" + whitelist);
        System.out.println(whitelist.indexOf(openid) == -1);
        if (StringUtils.isNotNull((String)whitelist) && whitelist.indexOf(openid) == -1) {
            return false;
        }
        ConsultSessionPropertyVo propertyVo = this.consultSessionPropertyService.findConsultSessionPropertyByUserId(openid);
        String path = sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "/keeper/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "/keeper/wechatInfo/getUserWechatMenId?url=40";
        if (propertyVo.getPermTimes() + propertyVo.getMonthTimes() == 0) {
            String payContent = "\u4eb2\u7231\u7684~\u4f60\u672c\u6708\u514d\u8d39\u673a\u4f1a\u5df2\u7528\u5b8c\uff0c\u8bf7\u533b\u751f\u559d\u676f\u8336\uff0c\u7ee7\u7eed\u54a8\u8be2\n\n<a href='" + sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "/keeper/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "/keeper/wechatInfo/getUserWechatMenId?url=35'>>>\u4ed8\u8d39</a>";
            WechatUtil.sendMsgToWechat((String)token, (String)openid, (String)payContent);
            String invatUrl = sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "/keeper/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "/keeper/wechatInfo/getUserWechatMenId?url=42,ZXYQ_YQY_WXCD";
            String bayContent = "\u4ec0\u4e48\uff1f\u54a8\u8be2\u8981\u6536\u8d39\uff1f\n\u4e0d\u6015\uff01\u9080\u8bf7\u4e2a\u597d\u53cb\u52a0\u5165\u5b9d\u5927\u592b\uff0c\u514d\u8d39\u673a\u4f1a\u7acb\u523b\u6709\uff01\n<a href='" + invatUrl + "'>>>\u9080\u8bf7\u597d\u53cb\u8d5a\u673a\u4f1a</a>";
            WechatUtil.sendMsgToWechat((String)token, (String)openid, (String)bayContent);
            String content = "\u95ee\u9898\u4e0d\u7740\u6025\uff1f\n\u8bd5\u8bd5\u7ed9\u533b\u751f\u7559\u8a00\u54a8\u8be2\u5427\uff0c \u533b\u751f\u4f1a\u5c3d\u5feb\u56de\u590d\u54e6\n<a href='" + path + "'>>>\u56fe\u6587\u54a8\u8be2</a>";
            WechatUtil.sendMsgToWechat((String)token, (String)openid, (String)content);
            LogUtils.saveLog((String)"FSS_YHD_RK1_TS", (String)openid);
            return true;
        }
        ConsultSession consultInfo = this.consultConversationService.selectByOpenid(openid);
        if (propertyVo.getMonthTimes() == 4 && propertyVo.getPermTimes() == 0 && consultInfo.getConsultNumber() > 26) {
            String payContent = "\u4eb2\u7231\u7684~\u4f60\u672c\u6708\u514d\u8d39\u673a\u4f1a\u5df2\u7528\u5b8c\uff0c\u8bf7\u533b\u751f\u559d\u676f\u8336\uff0c\u7ee7\u7eed\u54a8\u8be2\n\n<a href='" + sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "/keeper/wechatInfo/fieldwork/wechat/author?url=" + sysPropertyVoWithBLOBsVo.getKeeperWebUrl() + "/keeper/wechatInfo/getUserWechatMenId?url=35'>>>\u4ed8\u8d39</a>";
            WechatUtil.sendMsgToWechat((String)token, (String)openid, (String)payContent);
            String content = "\u4e0d\u60f3\u638f\u94b1\uff1f\n\u6765\u8bd5\u8bd5\u201c\u70b9\u540d\u54a8\u8be2\u201d\u3002\u4f60\u53ef\u6307\u5b9a\u4e13\u5bb6\u533b\u751f\u6216\u66fe\u54a8\u8be2\u8fc7\u7684\u533b\u751f\uff0c \u533b\u751f\u4f1a\u572824h \u5185\u5c3d\u5feb\u5bf9\u60a8\u7684\u63d0\u95ee\u8fdb\u884c\u7b54\u590d\u54e6~\n\uff08\u5982\u6709\u7591\u95ee\uff0c\u53ef\u76f4\u63a5\u62e8\u6253400-6237-120\uff09\n<a href='" + path + "'>>>\u70b9\u540d\u54a8\u8be2\u533b\u751f</a>";
            WechatUtil.sendMsgToWechat((String)token, (String)openid, (String)content);
            LogUtils.saveLog((String)"FSS_YHD_RK3_TS", (String)openid);
            return true;
        }
        return false;
    }

    public void updateKeywordRecovery() {
        this.keywordMap = this.operationPromotionService.getAllRoleListByKeyword();
    }

    public class addUserType
    extends Thread {
        private String toOpenId;

        public addUserType(String toOpenId) {
            this.toOpenId = toOpenId;
        }

        @Override
        public void run() {
            WechatPatientCoreServiceImpl.this.addUserType(this.toOpenId);
        }
    }

    public class sendHasCardDoctorWechatMessage
    extends Thread {
        private String EventKey;
        private ReceiveXmlEntity xmlEntity;

        public sendHasCardDoctorWechatMessage(String EventKey, ReceiveXmlEntity xmlEntity) {
            this.EventKey = EventKey;
            this.xmlEntity = xmlEntity;
        }

        @Override
        public void run() {
            Map parameter = WechatPatientCoreServiceImpl.this.systemService.getWechatParameter();
            String token = (String)parameter.get("token");
            String marketer = this.EventKey.replace("qrscene_", "");
            String[] marketsArr = Global.getConfig((String)"consult.doctor.marketers").split(",");
            List<String> marketsList = Arrays.asList(marketsArr);
            if (marketsList.contains(marketer)) {
                Map doctorMap = WechatPatientCoreServiceImpl.this.consultConversationService.getConsultCountsByDoctorName(marketer);
                StringBuffer consultRelateMsg = new StringBuffer();
                if (StringUtils.isNull((String)doctorMap.get("doctorName").toString())) {
                    doctorMap = WechatPatientCoreServiceImpl.this.consultConversationService.getDoctorInfoByMarketer(marketer);
                }
                consultRelateMsg.append(doctorMap.get("doctorName").toString()).append(" | ");
                consultRelateMsg.append(doctorMap.get("hospitalName").toString()).append(" | ");
                consultRelateMsg.append(doctorMap.get("professional").toString()).append(": ");
                consultRelateMsg.append(doctorMap.get("skill").toString());
                consultRelateMsg.append("\n\n\u70b9\u51fb\u5de6\u4e0b\u89d2\u201c\u5c0f\u952e\u76d8\u201d\u8f93\u5165\u6587\u5b57\u6216\u56fe\u7247\uff0c\u5373\u53ef\u54a8\u8be2\u75be\u75c5\u6216\u4fdd\u5065\u95ee\u9898\u3002\n");
                WechatUtil.sendMsgToWechat((String)token, (String)this.xmlEntity.getFromUserName(), (String)consultRelateMsg.toString());
            }
        }
    }

    public class processConsultMessageThread
    extends Thread {
        private ReceiveXmlEntity xmlEntity;

        public processConsultMessageThread(ReceiveXmlEntity xmlEntity) {
            this.xmlEntity = xmlEntity;
        }

        @Override
        public void run() {
            try {
                System.out.println(this.xmlEntity.getContent());
                SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo = WechatPatientCoreServiceImpl.this.sysPropertyService.querySysProperty();
                if (this.xmlEntity.getMsgType().equals("text")) {
                    this.sendPost(sysPropertyVoWithBLOBsVo.getAngelWebUrl() + "angel/consult/wechat/conversation", "openId=" + this.xmlEntity.getFromUserName() + "&messageType=" + this.xmlEntity.getMsgType() + "&messageContent=" + URLEncoder.encode(this.xmlEntity.getContent(), "UTF-8"));
                } else {
                    this.sendPost(sysPropertyVoWithBLOBsVo.getAngelWebUrl() + "angel/consult/wechat/conversation", "openId=" + this.xmlEntity.getFromUserName() + "&messageType=" + this.xmlEntity.getMsgType() + "&mediaId=" + this.xmlEntity.getMediaId());
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String sendPost(String url, String param) {
            PrintWriter out = null;
            BufferedReader in = null;
            String result = "";
            try {
                String line;
                URL realUrl = new URL(url);
                URLConnection conn = realUrl.openConnection();
                conn.setRequestProperty("accept", "*/*");
                conn.setRequestProperty("connection", "Keep-Alive");
                conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                out = new PrintWriter(conn.getOutputStream());
                out.print(param);
                out.flush();
                in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = in.readLine()) != null) {
                    result = result + line;
                }
            }
            catch (Exception e) {
                System.out.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                e.printStackTrace();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return result;
        }
    }
}

