package com.zthzinfo.aliyun.oss;

import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.springframework.web.multipart.MultipartFile;

public class ExtUtil {
	public static String getExtname(MultipartFile file){
		String contentType = file.getContentType();
		MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
		String ext = "";
		try {
			MimeType mimeType = allTypes.forName(contentType);
			ext = mimeType.getExtension();
			if (ext == null || ext.trim().length() == 0) {
				int lastPointIndex = file.getOriginalFilename().lastIndexOf('.');
				if (lastPointIndex > 0) {
					ext = file.getOriginalFilename().substring(lastPointIndex);
				}
			}
		} catch (MimeTypeException e) {
			e.printStackTrace();
			ext = ".jpg";
		}
		return ext;
	}
}
