/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.bean.BaseErrors;
import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.ParamNotNullError;
import com.cxqm.xiaoerke.common.utils.Des3Util;
import com.cxqm.xiaoerke.common.utils.MD5Util;
import com.cxqm.xiaoerke.common.web.ApiValidateIntercreptorKeyGetter;
import com.cxqm.xiaoerke.common.web.ApiValidateTokenVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ApiValidateInterceptor
extends HandlerInterceptorAdapter {
    private ApiValidateIntercreptorKeyGetter keyGetter;
    private String primariyKey;
    private String dynamicPrimariyKey;
    private String enableDebug;

    public ApiValidateIntercreptorKeyGetter getKeyGetter() {
        return this.keyGetter;
    }

    public void setKeyGetter(ApiValidateIntercreptorKeyGetter keyGetter) {
        this.keyGetter = keyGetter;
    }

    private String getKey(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.primariyKey != null) {
            return this.primariyKey;
        }
        if (this.keyGetter != null) {
            return this.keyGetter.getKey(request, response, handler);
        }
        return null;
    }

    public String getDynamicPrimariyKey() {
        return this.dynamicPrimariyKey;
    }

    public void setDynamicPrimariyKey(String dynamicPrimariyKey) {
        this.dynamicPrimariyKey = dynamicPrimariyKey;
    }

    public String getPrimariyKey() {
        return this.primariyKey;
    }

    public void setPrimariyKey(String primariyKey) {
        this.primariyKey = primariyKey;
    }

    public String getEnableDebug() {
        return this.enableDebug;
    }

    public void setEnableDebug(String enableDebug) {
        this.enableDebug = enableDebug;
    }

    public boolean preHandle(final HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String debug;
        if (this.enableDebug != null && this.enableDebug.equals("1") && (debug = request.getParameter("DEBUG")) != null && debug.equals("1")) {
            return super.preHandle(request, response, handler);
        }
        String tokenByRequest = request.getParameter("token");
        if (tokenByRequest == null || tokenByRequest.trim().length() == 0) {
            throw new BusinessException(BaseErrors.TOKEN_ERROR);
        }
        String timestamp = request.getParameter("timestamp");
        if (timestamp == null || timestamp.trim().length() == 0) {
            throw new BusinessException(BaseErrors.TIMESTAMP_ERROR);
        }
        ArrayList<String> keys = Collections.list(request.getParameterNames());
        keys.remove("token");
        String token = ApiValidateInterceptor.generateToken(this.getKey(request, response, handler), keys, new ParamMap(){

            @Override
            public String getValue(String key) {
                return request.getParameter(key);
            }
        });
        if (!tokenByRequest.equalsIgnoreCase(token)) {
            String source = ApiValidateInterceptor.generateSource(this.getKey(request, response, handler), keys, new ParamMap(){

                @Override
                public String getValue(String key) {
                    return request.getParameter(key);
                }
            });
            System.out.println("source:" + source);
            System.out.println("token:" + token);
            throw new BusinessException(BaseErrors.TOKEN_ERROR);
        }
        return super.preHandle(request, response, handler);
    }

    public static String validateToken(HttpServletRequest request, String PK) {
        Map map = request.getParameterMap();
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry tmp : map.entrySet()) {
            String key = (String)tmp.getKey();
            String[] val = (String[])tmp.getValue();
            if ("sign".equals(key) || val == null || val.length <= 0) continue;
            newMap.put(key, val[0]);
        }
        return ApiValidateInterceptor.validateToken(newMap, PK);
    }

    public static String validateToken(final Map<String, String> param, String PK) {
        String token = ApiValidateInterceptor.generateToken(PK, new ArrayList<String>(param.keySet()), new ParamMap(){

            @Override
            public String getValue(String key) {
                return (String)param.get(key);
            }
        });
        return token;
    }

    public static ApiValidateTokenVo generateToken(String PK, Map<String, String> param) {
        final HashMap<String, String> myParam = new HashMap<String, String>(param);
        ApiValidateTokenVo result = new ApiValidateTokenVo(new Date().getTime());
        myParam.put("timestamp", result.getTimestamp() + "");
        String token = ApiValidateInterceptor.generateToken(PK, new ArrayList<String>(myParam.keySet()), new ParamMap(){

            @Override
            public String getValue(String key) {
                return (String)myParam.get(key);
            }
        });
        result.setToken(token);
        return result;
    }

    public static String generateToken(String PK, Collection<String> keys, ParamMap paramMap) {
        if (PK == null) {
            return null;
        }
        String strOri = ApiValidateInterceptor.generateSource(PK, keys, paramMap);
        String token = MD5Util.MD5Encode(strOri, "utf-8");
        return token;
    }

    public static String generateSource(String PK, Collection<String> keys, ParamMap paramMap) {
        StringBuffer strOri = new StringBuffer();
        ArrayList<String> keysBySort = new ArrayList<String>(keys);
        Collections.sort(keysBySort);
        for (String key : keysBySort) {
            String value = paramMap.getValue(key);
            strOri.append((value == null ? "" : value) + "|");
        }
        strOri.append(PK);
        return strOri.toString();
    }

    public static String genPluginsVerifi(JSONObject dictionary) {
        String PK = dictionary.getString("key");
        String time = String.valueOf(System.currentTimeMillis());
        String token = MD5Util.MD5Encode(time + PK, "utf-8");
        String maxtime = dictionary.getString("maxtime");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("time", (Object)time);
        jsonObject.put("token", (Object)token);
        jsonObject.put("maxtime", (Object)maxtime);
        String info = jsonObject.toJSONString();
        String encodeInfo = null;
        try {
            encodeInfo = Des3Util.encode(info, PK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (encodeInfo != null && encodeInfo.trim().length() > 0) {
            encodeInfo = encodeInfo.replaceAll("\\+", "%2B");
            encodeInfo = encodeInfo.replaceAll("=", "%3D");
        }
        return encodeInfo;
    }

    public static boolean checkoutVerifi(String verifi, String PK) {
        Long offsetTime;
        String source = null;
        try {
            source = Des3Util.decode(verifi, PK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (source == null || source.trim().length() < 0) {
            throw new BusinessException(new ParamNotNullError("source"));
        }
        JSONObject jsonObject = JSON.parseObject((String)source);
        Long time = jsonObject.getLong("time");
        if (time == null) {
            throw new BusinessException(new ParamNotNullError("time"));
        }
        String token = jsonObject.getString("token");
        if (token == null || token.trim().length() <= 0) {
            throw new BusinessException(new ParamNotNullError("token"));
        }
        String ctoken = MD5Util.MD5Encode(time + PK, "utf-8");
        if (!ctoken.equals(token)) {
            throw new BusinessException(BaseErrors.TOKEN_ERROR);
        }
        Long maxtime = jsonObject.getLong("maxtime");
        if (maxtime == null) {
            maxtime = 300000L;
        }
        if ((offsetTime = Long.valueOf(System.currentTimeMillis() - time)) > maxtime) {
            throw new BusinessException(BaseErrors.TIMESTAMP_ERROR);
        }
        return true;
    }

    public static interface ParamMap {
        public String getValue(String var1);
    }
}

