/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.config;

import com.cxqm.xiaoerke.common.filter.LoadProjectPath;
import com.cxqm.xiaoerke.common.utils.PropertiesLoader;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Global {
    public static int RECOMMENDED_FEE = 10;
    private static Global global = new Global();
    private static Map<String, String> map = Maps.newHashMap();
    public static PropertiesLoader propertiesLoader = new PropertiesLoader("system.properties");
    private static Boolean isDebug;
    public static final String SHOW = "1";
    public static final String HIDE = "0";
    public static final String YES = "1";
    public static final String NO = "0";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String USERFILES_BASE_URL = "/userfiles/";

    public static Global getInstance() {
        return global;
    }

    public static String getConfig(String key) {
        String value = map.get(key);
        if (value == null) {
            value = propertiesLoader.getProperty(key);
            map.put(key, value != null ? value : "");
        }
        return value;
    }

    public static boolean isDebug() {
        if (isDebug == null) {
            String isDebugStr = Global.getConfig("isDebug");
            if (isDebug == null) {
                isDebug = false;
            }
            isDebug = "1".equals(isDebugStr);
        }
        return isDebug;
    }

    public static String getHTTPUrlConfig(String key) {
        String url = Global.getConfig(key);
        return LoadProjectPath.getHTTPUrlByScheme(url);
    }

    public static String getUrlConfig(String key, HttpServletRequest request) {
        String url = Global.getConfig(key);
        return LoadProjectPath.getUrlByScheme(request, url);
    }

    public static Integer getIntegerConfig(String key, Integer defaultValue) {
        String str = Global.getConfig(key);
        Integer result = null;
        try {
            result = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        return result;
    }

    public static String getAdminPath() {
        return Global.getConfig("adminPath");
    }

    public static String getFrontPath() {
        return Global.getConfig("frontPath");
    }

    public static String getUrlSuffix() {
        return Global.getConfig("urlSuffix");
    }

    public static Boolean isDemoMode() {
        String dm = Global.getConfig("demoMode");
        return TRUE.equals(dm) || "1".equals(dm);
    }

    public static Object getConst(String field) {
        try {
            return Global.class.getField(field).get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getUserfilesBaseDir() {
        String dir = Global.getConfig("userfiles.basedir");
        if (StringUtils.isBlank((CharSequence)dir)) {
            try {
                dir = "../webapps/backend";
            }
            catch (Exception e) {
                return "";
            }
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        return dir;
    }

    public static Integer getMeetingExpiredSecond() {
        return Global.getIntegerConfig("haoyun.overtime_meeting", 1800);
    }
}

