/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.filter;

import com.cxqm.xiaoerke.common.config.Global;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LoadProjectPath
implements ServletContextListener {
    private static String baseUrl;

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void contextInitialized(ServletContextEvent event) {
        this.loadProjectPath(event);
    }

    public void loadProjectPath(ServletContextEvent event) {
        String baseUrl;
        LoadProjectPath.baseUrl = baseUrl = Global.getConfig("baseUrl");
    }

    public void loadProjectPath(ServletContextEvent event, String path) {
        baseUrl = path;
    }

    public static String getHTTPUrlByScheme(String url) {
        if (url == null) {
            return url;
        }
        if (url.startsWith("http://")) {
            return url;
        }
        if (url.startsWith("https://")) {
            url = url.substring(8);
        }
        if (url.startsWith("//")) {
            url = url.substring(2);
        }
        return "http://" + url;
    }

    public static boolean isHttps(HttpServletRequest request) {
        RequestAttributes requestAttributes;
        if (request == null && (requestAttributes = RequestContextHolder.getRequestAttributes()) != null) {
            request = ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        if (request != null) {
            String proxyScheme = request.getHeader("proxy_protocol");
            if (proxyScheme != null && proxyScheme.equals("https")) {
                return true;
            }
            if (request.getScheme().equals("https")) {
                return true;
            }
        }
        return false;
    }

    public static String getScheme(HttpServletRequest request) {
        boolean isHttps = LoadProjectPath.isHttps(request);
        return isHttps ? "https" : "http";
    }

    public static String getUrlByScheme(HttpServletRequest request, String url) {
        return LoadProjectPath.createUrl(LoadProjectPath.isHttps(request), url);
    }

    public static String createUrl(boolean useHttps, String url) {
        url = LoadProjectPath.removePre(url);
        return (useHttps ? "https" : "http") + "://" + url;
    }

    public static String getBaseurl(HttpServletRequest request) {
        return LoadProjectPath.getUrlByScheme(request, baseUrl);
    }

    public static String getBaseurl(boolean useHttps) {
        return LoadProjectPath.createUrl(useHttps, baseUrl);
    }

    public static String removePre(String url) {
        if (url == null) {
            url = "";
        } else {
            if (url.startsWith("http://")) {
                url = url.substring(7);
            }
            if (url.startsWith("https://")) {
                url = url.substring(8);
            }
            if (url.startsWith("//")) {
                url = url.substring(2);
            }
        }
        return url;
    }

    public static String getBaseUrl2() {
        String url = LoadProjectPath.removePre(baseUrl);
        return "//" + url;
    }
}

