/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.persistence.interceptor;

import com.cxqm.xiaoerke.common.persistence.MyBatisPage;
import com.cxqm.xiaoerke.common.persistence.MysqlDialect;
import com.cxqm.xiaoerke.common.persistence.Page;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PageInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(PageInterceptor.class);
    static int MAPPED_STATEMENT_INDEX = 0;
    static int PARAMETER_INDEX = 1;
    static int ROWBOUNDS_INDEX = 2;
    static int RESULT_HANDLER_INDEX = 3;
    static ExecutorService Pool;
    String dialectClass;
    boolean asyncTotalCount = false;

    public Object intercept(final Invocation invocation) throws Throwable {
        final Executor executor = (Executor)invocation.getTarget();
        Object[] queryArgs = invocation.getArgs();
        final MappedStatement ms = (MappedStatement)queryArgs[MAPPED_STATEMENT_INDEX];
        final Object parameter = queryArgs[PARAMETER_INDEX];
        RowBounds rowBounds = (RowBounds)queryArgs[ROWBOUNDS_INDEX];
        if (rowBounds.getOffset() == 0 && rowBounds.getLimit() == Integer.MAX_VALUE) {
            return invocation.proceed();
        }
        Page pageBounds = new Page(rowBounds);
        final MysqlDialect dialect = new MysqlDialect(ms, parameter, pageBounds);
        final BoundSql boundSql = ms.getBoundSql(parameter);
        queryArgs[PageInterceptor.MAPPED_STATEMENT_INDEX] = this.copyFromNewSql(ms, boundSql, dialect.getPageSQL(), boundSql.getParameterMappings(), parameter);
        queryArgs[PageInterceptor.PARAMETER_INDEX] = parameter;
        queryArgs[PageInterceptor.ROWBOUNDS_INDEX] = new RowBounds(0, Integer.MAX_VALUE);
        Boolean async = pageBounds.getAsyncTotalCount() == null ? this.asyncTotalCount : pageBounds.getAsyncTotalCount();
        Future listFuture = this.call(new Callable<List>(){

            @Override
            public List call() throws Exception {
                return (List)invocation.proceed();
            }
        }, async);
        Future countFuture = null;
        Callable countTask = null;
        if (pageBounds.getCount() != -1L) {
            countTask = new Callable(){

                public Object call() throws Exception {
                    Long count;
                    Cache cache = ms.getCache();
                    if (cache != null && ms.isUseCache() && ms.getConfiguration().isCacheEnabled()) {
                        CacheKey cacheKey = executor.createCacheKey(ms, parameter, new Page(), PageInterceptor.this.copyFromBoundSql(ms, boundSql, dialect.getCountSQL(), boundSql.getParameterMappings(), boundSql.getParameterObject()));
                        count = (Long)cache.getObject((Object)cacheKey);
                        if (count == null) {
                            count = PageInterceptor.getCount(ms, parameter, boundSql, dialect);
                            cache.putObject((Object)cacheKey, (Object)count);
                        }
                    } else {
                        count = PageInterceptor.getCount(ms, parameter, boundSql, dialect);
                    }
                    return count;
                }
            };
            countFuture = this.call(countTask, async);
        }
        return new MyBatisPage((Collection)listFuture.get(), pageBounds.getCount() != -1L ? (Long)countFuture.get() : -1L, pageBounds.getOffset(), pageBounds.getLimit());
    }

    private <T> Future<T> call(Callable callable, boolean async) {
        if (async) {
            return Pool.submit(callable);
        }
        FutureTask future = new FutureTask(callable);
        future.run();
        return future;
    }

    private MappedStatement copyFromNewSql(MappedStatement ms, BoundSql boundSql, String sql, List<ParameterMapping> parameterMappings, Object parameter) {
        BoundSql newBoundSql = this.copyFromBoundSql(ms, boundSql, sql, parameterMappings, parameter);
        return this.copyFromMappedStatement(ms, new BoundSqlSqlSource(newBoundSql));
    }

    private BoundSql copyFromBoundSql(MappedStatement ms, BoundSql boundSql, String sql, List<ParameterMapping> parameterMappings, Object parameter) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, parameterMappings, parameter);
        Field metaParametersField = ReflectionUtils.findField(BoundSql.class, (String)"metaParameters");
        metaParametersField.setAccessible(true);
        ReflectionUtils.setField((Field)metaParametersField, (Object)newBoundSql, (Object)ReflectionUtils.getField((Field)metaParametersField, (Object)boundSql));
        return newBoundSql;
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuffer keyProperties = new StringBuffer();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public void setDialectClass(String dialectClass) {
        logger.debug("dialectClass: {} ", (Object)dialectClass);
        this.dialectClass = dialectClass;
    }

    public void setAsyncTotalCount(boolean asyncTotalCount) {
        logger.debug("asyncTotalCount: {} ", (Object)asyncTotalCount);
        this.asyncTotalCount = asyncTotalCount;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        if (poolMaxSize > 0) {
            logger.debug("poolMaxSize: {} ", (Object)poolMaxSize);
            Pool = Executors.newFixedThreadPool(poolMaxSize);
        } else {
            Pool = Executors.newCachedThreadPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCount(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql, MysqlDialect dialect) throws SQLException {
        String count_sql = dialect.getCountSQL();
        logger.debug("Total count SQL [{}] ", (Object)count_sql);
        logger.debug("Total count Parameters: {} ", parameterObject);
        Connection connection = null;
        PreparedStatement countStmt = null;
        ResultSet rs = null;
        try {
            connection = mappedStatement.getConfiguration().getEnvironment().getDataSource().getConnection();
            countStmt = connection.prepareStatement(count_sql);
            DefaultParameterHandler handler = new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
            handler.setParameters(countStmt);
            rs = countStmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            logger.debug("Total count: {}", (Object)count);
            long l = count;
            return l;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (countStmt != null) {
                        countStmt.close();
                    }
                }
                finally {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
            }
        }
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

