/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.persistence.Page;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

public class FrontUtils {
    public static final String DATE_FORMAT_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";

    private FrontUtils() {
    }

    public static <T> long generatorTotalPage(Page<T> resultPage) {
        int pageSize;
        long count = resultPage.getCount();
        long tmp = count % (long)(pageSize = resultPage.getPageSize()) == 0L ? count / (long)pageSize : count / (long)pageSize + 1L;
        return tmp;
    }

    public static <T> Page<T> generatorPage(String currentPage, String pageSize) {
        int pageNo = StringUtils.isNotBlank((CharSequence)currentPage) ? Integer.valueOf(currentPage) : 1;
        int _pageSize = StringUtils.isNotBlank((CharSequence)pageSize) ? Integer.valueOf(pageSize) : 10;
        Page page = new Page(pageNo, _pageSize);
        return page;
    }

    public static <T> T readJson(String jsonStr, Class<?> collectionClass, Class<?> ... elementClasses) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JavaType javaType = mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
        return (T)mapper.readValue(jsonStr, javaType);
    }

    public static String time2Date(Date time) throws ParseException {
        String date = DateFormatUtils.format((Date)time, (String)DATE_FORMAT_PATTERN);
        return date;
    }

    public static Map<String, String> calculateResult(Map<String, List<String>> map) {
        DecimalFormat df = new DecimalFormat("#.00");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            List<String> list = map.get(key);
            double value = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                value += Double.valueOf(list.get(i)).doubleValue();
            }
            resultMap.put(key, df.format(value / (double)list.size()) + "");
        }
        return resultMap;
    }
}

