/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.utils.Encodes;
import com.robert.vesta.service.bean.Id;
import com.robert.vesta.service.impl.IdServiceImpl;
import com.robert.vesta.service.impl.provider.MachineIdProvider;
import com.robert.vesta.service.impl.provider.PropertyMachineIdProvider;
import com.robert.vesta.service.intf.IdService;
import java.io.Serializable;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
public class IdGen
implements IdGenerator,
SessionIdGenerator {
    private static SecureRandom random = new SecureRandom();
    private static IdService idService;

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static IdService getIdService() {
        if (idService == null) {
            PropertyMachineIdProvider propertyMachineIdProvider = new PropertyMachineIdProvider();
            String config = Global.getConfig("vesta.machine");
            propertyMachineIdProvider.setMachineId(config == null || config.trim().length() == 0 ? 1L : (long)Integer.parseInt(config));
            idService = new IdServiceImpl();
            ((IdServiceImpl)idService).setMachineIdProvider((MachineIdProvider)propertyMachineIdProvider);
            ((IdServiceImpl)idService).init();
        }
        if (idService == null) {
            throw new IllegalArgumentException("\u521d\u59cb\u5316vestaId\u670d\u52a1\u5931\u8d25!");
        }
        return idService;
    }

    public static String vestaId() {
        return IdGen.getIdService().genId() + "";
    }

    public static Date getDateByVestaId(String vestaId) {
        Long vestaIdLong;
        if (vestaId == null) {
            return null;
        }
        try {
            vestaIdLong = Long.parseLong(vestaId);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
        Id id = IdGen.getIdService().expId(vestaIdLong.longValue());
        return IdGen.getIdService().transTime(id.getTime());
    }

    public static long randomLong() {
        return Math.abs(random.nextLong());
    }

    public static String randomBase62(int length) {
        byte[] randomBytes = new byte[length];
        random.nextBytes(randomBytes);
        return Encodes.encodeBase62(randomBytes);
    }

    public static String orderNo() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
        String code = formatter.format(new Date()) + "";
        Double d = Math.random() * 900.0 + 100.0;
        int number = d.intValue();
        return code + number;
    }

    public String getNextId() {
        return IdGen.uuid();
    }

    public Serializable generateId(Session session) {
        return IdGen.uuid();
    }

    public static void main(String[] args) {
        int i;
        for (i = 0; i < 20; ++i) {
            System.out.println(IdGen.vestaId());
        }
        for (i = 0; i < 20; ++i) {
            System.out.println(IdGen.uuid());
        }
    }
}

