/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.Rational;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.GpsDirectory;
import java.io.File;

public class ImageGeo {
    public double lat = 0.0;
    public double lon = 0.0;
    public double alt = 0.0;
    public boolean error = false;

    public ImageGeo(String filename) {
        try {
            this.error = false;
            File jpegFile = new File(filename);
            Metadata metadata = JpegMetadataReader.readMetadata((File)jpegFile);
            GpsDirectory gpsdir = (GpsDirectory)metadata.getDirectory(GpsDirectory.class);
            Rational[] latpart = gpsdir.getRationalArray(2);
            Rational[] lonpart = gpsdir.getRationalArray(4);
            String northing = gpsdir.getString(1);
            String easting = gpsdir.getString(3);
            try {
                this.alt = gpsdir.getDouble(6);
            }
            catch (Exception exception) {
                // empty catch block
            }
            double latsign = 1.0;
            if (northing.equalsIgnoreCase("S")) {
                latsign = -1.0;
            }
            double lonsign = 1.0;
            if (easting.equalsIgnoreCase("W")) {
                lonsign = -1.0;
            }
            this.lat = (Math.abs(latpart[0].doubleValue()) + latpart[1].doubleValue() / 60.0 + latpart[2].doubleValue() / 3600.0) * latsign;
            this.lon = (Math.abs(lonpart[0].doubleValue()) + lonpart[1].doubleValue() / 60.0 + lonpart[2].doubleValue() / 3600.0) * lonsign;
            if (Double.isNaN(this.lat) || Double.isNaN(this.lon)) {
                this.error = true;
            }
        }
        catch (Exception ex) {
            this.error = true;
        }
        System.out.println(filename + ": (" + this.lat + ", " + this.lon + ")");
    }

    public static void main(String[] args) {
        ImageGeo imageGeo = new ImageGeo(ImageGeo.class.getResource("IMAG0068.jpg").getFile());
        System.out.println(imageGeo.lon + "," + imageGeo.lat);
    }
}

