/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.utils.QRCodeFactory;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class MatrixToImageWriter {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    private MatrixToImageWriter() {
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static void writeToFile(BitMatrix matrix, String format, File file, String logUri) throws IOException {
        System.out.println("write to file");
        BufferedImage image = MatrixToImageWriter.toBufferedImage(matrix);
        QRCodeFactory logoConfig = new QRCodeFactory();
        if (logUri != null) {
            image = logoConfig.setMatrixLogo(image, logUri);
        }
        if (!ImageIO.write((RenderedImage)image, format, file)) {
            System.out.println("\u751f\u6210\u56fe\u7247\u5931\u8d25");
            throw new IOException("Could not write an image of format " + format + " to " + file);
        }
        System.out.println("\u56fe\u7247\u751f\u6210\u6210\u529f\uff01");
    }

    public static void writeToStream(BitMatrix matrix, String format, OutputStream stream, String logUri) throws IOException {
        BufferedImage image = MatrixToImageWriter.toBufferedImage(matrix);
        QRCodeFactory logoConfig = new QRCodeFactory();
        if (!ImageIO.write((RenderedImage)(image = logoConfig.setMatrixLogo(image, logUri)), format, stream)) {
            throw new IOException("Could not write an image of format " + format);
        }
    }
}

