/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.objenesis.Objenesis;
import org.springframework.objenesis.ObjenesisStd;

public class SerializationUtil {
    private static Map<Class<?>, Schema<?>> cachedSchema = new ConcurrentHashMap();
    private static Objenesis objenesis = new ObjenesisStd(true);

    private SerializationUtil() {
    }

    private static <T> Schema<T> getSchema(Class<T> cls) {
        RuntimeSchema schema = cachedSchema.get(cls);
        if (schema == null && (schema = RuntimeSchema.createFrom(cls)) != null) {
            cachedSchema.put(cls, (Schema<?>)schema);
        }
        return schema;
    }

    public static <T> byte[] serialize(T obj) {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = SerializationUtil.getSchema(cls);
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            buffer.clear();
        }
    }

    public static <T> T deserialize(byte[] data, Class<T> cls) {
        try {
            Object message = objenesis.newInstance(cls);
            Schema<T> schema = SerializationUtil.getSchema(cls);
            ProtostuffIOUtil.mergeFrom((byte[])data, (Object)message, schema);
            return (T)message;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

