/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.web;

import com.cxqm.xiaoerke.common.bean.BaseErrors;
import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.filter.LoadProjectPath;
import com.cxqm.xiaoerke.common.utils.NeedNotLogin;
import com.cxqm.xiaoerke.common.utils.ShortUrlWithoutLogin;
import com.cxqm.xiaoerke.common.utils.WeixinUtil;
import com.cxqm.xiaoerke.common.web.ILoginValidater;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class LoginValidateInterceptor
extends HandlerInterceptorAdapter {
    private String redirectUrl;
    private String loginUrl;
    private ILoginValidater loginValidater;
    private String baseUrl;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public ILoginValidater getLoginValidater() {
        return this.loginValidater;
    }

    public void setLoginValidater(ILoginValidater loginValidater) {
        this.loginValidater = loginValidater;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    private boolean controllerNeedLogin(Object handler) {
        Method method;
        HandlerMethod handlerMethod;
        HandlerMethod handlerMethod2 = handlerMethod = handler instanceof HandlerMethod ? (HandlerMethod)handler : null;
        if (handlerMethod == null) {
            return true;
        }
        Method mTmp = ((HandlerMethod)handler).getMethod();
        try {
            method = ((HandlerMethod)handler).getBeanType().getMethod(mTmp.getName(), mTmp.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return false;
        }
        NeedNotLogin annotation = method.getAnnotation(NeedNotLogin.class);
        return annotation == null;
    }

    private boolean controllerAjax(Object handler) {
        HandlerMethod handlerMethod;
        HandlerMethod handlerMethod2 = handlerMethod = handler instanceof HandlerMethod ? (HandlerMethod)handler : null;
        if (handlerMethod == null) {
            return true;
        }
        Method mTmp = ((HandlerMethod)handler).getMethod();
        Method method = null;
        try {
            method = ((HandlerMethod)handler).getBeanType().getMethod(mTmp.getName(), mTmp.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return false;
        }
        ResponseBody annotation = method.getAnnotation(ResponseBody.class);
        return annotation == null;
    }

    private ShortUrlWithoutLogin controllerShortUrl(Object handler) {
        HandlerMethod handlerMethod;
        HandlerMethod handlerMethod2 = handlerMethod = handler instanceof HandlerMethod ? (HandlerMethod)handler : null;
        if (handlerMethod == null) {
            return null;
        }
        Method mTmp = ((HandlerMethod)handler).getMethod();
        Method method = null;
        try {
            method = ((HandlerMethod)handler).getBeanType().getMethod(mTmp.getName(), mTmp.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        ShortUrlWithoutLogin annotation = method.getAnnotation(ShortUrlWithoutLogin.class);
        if (annotation != null) {
            return annotation;
        }
        return null;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean controllerNeedLogin = this.controllerNeedLogin(handler);
        if (!controllerNeedLogin) {
            return true;
        }
        ShortUrlWithoutLogin shortUrl = this.controllerShortUrl(handler);
        if (shortUrl != null) {
            String xRemoteApiInvoker = request.getHeader("x-remote-api-invoker");
            String userAgent = request.getHeader("user-agent");
            if (xRemoteApiInvoker != null && xRemoteApiInvoker.equals("openapi") || userAgent == null) {
                response.setContentType("text/html; charset=utf-8");
                PrintWriter out = response.getWriter();
                out.println("<!DOCTYPE html>");
                out.println(String.format("<html><head><title>%s</title></head><body></body></html>", shortUrl.title()));
                response.flushBuffer();
                return false;
            }
        }
        if (this.loginValidater.getCurrentUser() != null) {
            return true;
        }
        boolean controllerAjax = this.controllerAjax(handler);
        if (!controllerAjax) {
            throw new BusinessException(BaseErrors.USER_NOTE_LOGIN);
        }
        String from = request.getRequestURI() + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
        String contextPath = request.getContextPath();
        if (contextPath != null && contextPath.trim().length() > 0) {
            from = from.replaceAll("^" + contextPath, "");
        }
        if (this.getBaseUrl() != null) {
            from = LoadProjectPath.getUrlByScheme(request, this.getBaseUrl()) + from;
        }
        return this.backLogin(request, response, from);
    }

    public boolean backLogin(HttpServletRequest request, HttpServletResponse response, String from) throws Exception {
        if (WeixinUtil.isWeiXin(request, "ignore_wechat")) {
            String redirectUrl = LoadProjectPath.getUrlByScheme(request, this.getRedirectUrl()) + "?from=" + from + "&status=" + WeixinUtil.NOT_JUMP_STATUS;
            String redirectUrlEncode = URLEncoder.encode(redirectUrl, "utf-8");
            String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + this.loginValidater.getAppId() + "&redirect_uri=" + redirectUrlEncode + "&response_type=code&scope=snsapi_userinfo#wechat_redirect";
            response.sendRedirect(url);
            return false;
        }
        String url = this.loginUrl == null ? "/" : LoadProjectPath.getUrlByScheme(request, this.loginUrl);
        String ignore_wechat = request.getParameter("ignore_wechat");
        response.sendRedirect(url + (url.indexOf(63) > 0 ? "&" : "?") + "from=" + URLEncoder.encode(from, "utf-8") + (ignore_wechat != null && ignore_wechat.equals("1") ? "&ignore_wechat=1" : ""));
        return false;
    }
}

