/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.utils;

import com.cxqm.xiaoerke.common.service.BaseService;
import com.cxqm.xiaoerke.common.utils.CacheUtils;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.modules.sys.dao.AreaDao;
import com.cxqm.xiaoerke.modules.sys.dao.MenuDao;
import com.cxqm.xiaoerke.modules.sys.dao.OfficeDao;
import com.cxqm.xiaoerke.modules.sys.dao.RoleDao;
import com.cxqm.xiaoerke.modules.sys.dao.UserDao;
import com.cxqm.xiaoerke.modules.sys.entity.Area;
import com.cxqm.xiaoerke.modules.sys.entity.Menu;
import com.cxqm.xiaoerke.modules.sys.entity.Office;
import com.cxqm.xiaoerke.modules.sys.entity.Role;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.security.SystemAuthorizingRealm;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

public class UserUtilsShiroImpl {
    private static UserDao userDao = SpringContextHolder.getBean(UserDao.class);
    private static RoleDao roleDao = SpringContextHolder.getBean(RoleDao.class);
    private static MenuDao menuDao = SpringContextHolder.getBean(MenuDao.class);
    private static AreaDao areaDao = SpringContextHolder.getBean(AreaDao.class);
    private static OfficeDao officeDao = SpringContextHolder.getBean(OfficeDao.class);
    public static final String USER_CACHE = "userCache";
    public static final String USER_CACHE_ID_ = "id_";
    public static final String USER_CACHE_LOGIN_NAME_ = "ln";
    public static final String USER_CACHE_LIST_BY_OFFICE_ID_ = "oid_";
    public static final String CACHE_ROLE_LIST = "roleList";
    public static final String CACHE_MENU_LIST = "menuList";
    public static final String CACHE_AREA_LIST = "areaList";
    public static final String CACHE_OFFICE_LIST = "officeList";
    public static final String CACHE_OFFICE_ALL_LIST = "officeAllList";

    public static User get(String id) {
        User user = (User)CacheUtils.get(USER_CACHE, USER_CACHE_ID_ + id);
        if (user == null) {
            user = (User)((Object)userDao.get(id));
            if (user == null) {
                return null;
            }
            user.setRoleList(roleDao.findList(new Role(user)));
            CacheUtils.put(USER_CACHE, USER_CACHE_ID_ + user.getId(), user);
            CacheUtils.put(USER_CACHE, USER_CACHE_LOGIN_NAME_ + user.getLoginName(), user);
        }
        return user;
    }

    public static User getByLoginName(String loginName) {
        return UserUtilsShiroImpl.getByLoginName(loginName, true);
    }

    public static User getByLoginName(String loginName, boolean withRole) {
        User user = (User)CacheUtils.get(USER_CACHE, USER_CACHE_LOGIN_NAME_ + loginName);
        if (user == null) {
            user = userDao.getByLoginName(new User(null, loginName));
            if (user == null) {
                return null;
            }
            if (withRole) {
                user.setRoleList(roleDao.findList(new Role(user)));
            }
            CacheUtils.put(USER_CACHE, USER_CACHE_ID_ + user.getId(), user);
            CacheUtils.put(USER_CACHE, USER_CACHE_LOGIN_NAME_ + user.getLoginName(), user);
        }
        return user;
    }

    public static void clearCache() {
        UserUtilsShiroImpl.removeCache(CACHE_ROLE_LIST);
        UserUtilsShiroImpl.removeCache(CACHE_MENU_LIST);
        UserUtilsShiroImpl.removeCache(CACHE_AREA_LIST);
        UserUtilsShiroImpl.removeCache(CACHE_OFFICE_LIST);
        UserUtilsShiroImpl.removeCache(CACHE_OFFICE_ALL_LIST);
        UserUtilsShiroImpl.clearCache(UserUtilsShiroImpl.getUser());
    }

    public static void clearCache(User user) {
        CacheUtils.remove(USER_CACHE, USER_CACHE_ID_ + user.getId());
        CacheUtils.remove(USER_CACHE, USER_CACHE_LOGIN_NAME_ + user.getLoginName());
        CacheUtils.remove(USER_CACHE, USER_CACHE_LOGIN_NAME_ + user.getOldLoginName());
        if (user.getOffice() != null && user.getOffice().getId() != null) {
            CacheUtils.remove(USER_CACHE, USER_CACHE_LIST_BY_OFFICE_ID_ + user.getOffice().getId());
        }
    }

    public static User getUser() {
        SystemAuthorizingRealm.Principal principal = UserUtilsShiroImpl.getPrincipal();
        if (principal != null) {
            User user = UserUtilsShiroImpl.get(principal.getId());
            if (user != null) {
                return user;
            }
            return new User();
        }
        return new User();
    }

    public static List<Role> getRoleList() {
        List<Role> roleList = (List<Role>)UserUtilsShiroImpl.getCache(CACHE_ROLE_LIST);
        if (roleList == null) {
            User user = UserUtilsShiroImpl.getUser();
            if (user.isAdmin()) {
                roleList = roleDao.findAllList(new Role());
            } else {
                Role role = new Role();
                role.getSqlMap().put("dsf", BaseService.dataScopeFilter(user.getCurrentUser(), "o", "u"));
                roleList = roleDao.findList(role);
            }
            UserUtilsShiroImpl.putCache(CACHE_ROLE_LIST, roleList);
        }
        return roleList;
    }

    public static List<Menu> getMenuList() {
        List<Menu> menuList = (List<Menu>)UserUtilsShiroImpl.getCache(CACHE_MENU_LIST);
        if (menuList == null) {
            User user = UserUtilsShiroImpl.getUser();
            if (user.isAdmin()) {
                menuList = menuDao.findAllList(new Menu());
            } else {
                Menu m = new Menu();
                m.setUserId(user.getId());
                menuList = menuDao.findByUserId(m);
            }
            UserUtilsShiroImpl.putCache(CACHE_MENU_LIST, menuList);
        }
        return menuList;
    }

    public static List<Menu> getSpecifiedMenuList(String roleName) {
        List<Menu> menuList = menuDao.findByRoleName(roleName);
        return menuList;
    }

    public static List<Area> getAreaList() {
        List<Area> areaList = (List<Area>)UserUtilsShiroImpl.getCache(CACHE_AREA_LIST);
        if (areaList == null) {
            areaList = areaDao.findAllList(new Area());
            UserUtilsShiroImpl.putCache(CACHE_AREA_LIST, areaList);
        }
        return areaList;
    }

    public static List<Office> getOfficeList() {
        List<Office> officeList = (List<Office>)UserUtilsShiroImpl.getCache(CACHE_OFFICE_LIST);
        if (officeList == null) {
            User user = UserUtilsShiroImpl.getUser();
            if (user.isAdmin()) {
                officeList = officeDao.findAllList(new Office());
            } else {
                Office office = new Office();
                office.getSqlMap().put("dsf", BaseService.dataScopeFilter(user, "a", ""));
                officeList = officeDao.findList(office);
            }
            UserUtilsShiroImpl.putCache(CACHE_OFFICE_LIST, officeList);
        }
        return officeList;
    }

    public static List<Office> getOfficeAllList() {
        List<Office> officeList = (List<Office>)UserUtilsShiroImpl.getCache(CACHE_OFFICE_ALL_LIST);
        if (officeList == null) {
            officeList = officeDao.findAllList(new Office());
        }
        return officeList;
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static SystemAuthorizingRealm.Principal getPrincipal() {
        try {
            Subject subject = SecurityUtils.getSubject();
            SystemAuthorizingRealm.Principal principal = (SystemAuthorizingRealm.Principal)subject.getPrincipal();
            if (principal != null) {
                return principal;
            }
        }
        catch (UnavailableSecurityManagerException unavailableSecurityManagerException) {
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        return null;
    }

    public static Session getSession() {
        try {
            Subject subject = SecurityUtils.getSubject();
            Session session = subject.getSession(false);
            if (session == null) {
                session = subject.getSession();
            }
            if (session != null) {
                return session;
            }
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        return null;
    }

    public static Object getCache(String key) {
        return UserUtilsShiroImpl.getCache(key, null);
    }

    public static Object getCache(String key, Object defaultValue) {
        Object obj = UserUtilsShiroImpl.getSession().getAttribute((Object)key);
        return obj == null ? defaultValue : obj;
    }

    public static void putCache(String key, Object value) {
        UserUtilsShiroImpl.getSession().setAttribute((Object)key, value);
    }

    public static void removeCache(String key) {
        UserUtilsShiroImpl.getSession().removeAttribute((Object)key);
    }
}

