/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.shipservice.bean;

import cn.hutool.core.util.IdUtil;
import com.zthzinfo.shipservice.bean.DelayQueueEvent;
import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayBean
implements Delayed {
    private String id;
    private long delay;
    private long expire;
    private Object data;
    private DelayQueueEvent event;

    public DelayBean(String id) {
        this.id = id;
    }

    public DelayBean(long delay, Object data) {
        this(null, delay, data, null);
    }

    public DelayBean(String id, long delay, Object data, DelayQueueEvent event) {
        this.delay = delay;
        if (id == null) {
            id = IdUtil.simpleUUID();
        }
        this.id = id;
        this.expire = System.currentTimeMillis() + delay;
        this.data = data;
        this.event = event;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelayQueueEvent)) {
            return false;
        }
        return Objects.equals(this.getId(), ((DelayBean)obj).getId());
    }

    public String getId() {
        return this.id;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getExpire() {
        return this.expire;
    }

    public Object getData() {
        return this.data;
    }

    public DelayQueueEvent getEvent() {
        return this.event;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setEvent(DelayQueueEvent event) {
        this.event = event;
    }

    public String toString() {
        return "DelayBean(id=" + this.getId() + ", delay=" + this.getDelay() + ", expire=" + this.getExpire() + ", data=" + this.getData() + ", event=" + (Object)((Object)this.getEvent()) + ")";
    }
}

