/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules;

import com.cxqm.xiaoerke.modules.channelhandler.Bean;
import com.cxqm.xiaoerke.modules.channelhandler.HandlerBeans;
import com.cxqm.xiaoerke.modules.channelhandler.HttpHandler;
import com.cxqm.xiaoerke.modules.channelhandler.TextHandler;
import com.cxqm.xiaoerke.modules.entity.Path;
import com.cxqm.xiaoerke.modules.entity.UserEvent;
import com.cxqm.xiaoerke.modules.util.ClassUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

public class StartService
extends ChannelInitializer<Channel> {
    private UserEvent userEvent;
    private String port;
    private String handPackPath;
    private HandlerBeans handlerBeans = new HandlerBeans();
    private EventLoopGroup workerGroup = new NioEventLoopGroup();
    private ServerBootstrap boot;
    private ChannelPipeline pipeline;
    private Channel channel;

    protected void initChannel(Channel channel) throws Exception {
        this.channel = channel;
        this.pipeline = channel.pipeline();
        this.pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        this.pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        this.pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        this.pipeline.addLast(new ChannelHandler[]{new HttpHandler(this)});
        this.pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/ws", null, false, 131072)});
        this.pipeline.addLast(new ChannelHandler[]{new TextHandler(this)});
    }

    public void start() {
        this.boot = new ServerBootstrap();
        ((ServerBootstrap)this.boot.group(this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)this);
        this.boot.bind((SocketAddress)new InetSocketAddress(this.getPort())).syncUninterruptibly();
        this.loadHander();
    }

    public void end() {
        this.workerGroup.shutdownGracefully();
        System.out.println("websocket\u670d\u52a1\u5173\u95ed=======================================new");
    }

    private void loadHander() {
        List<Class<?>> allClass = ClassUtil.getClasses(this.handPackPath);
        if (allClass == null || allClass.size() == 0) {
            return;
        }
        Map<String, Bean> map = this.handlerBeans.getHandlerBeans();
        for (int i = 0; i < allClass.size(); ++i) {
            Class<?> temp = allClass.get(i);
            Path handler = temp.getAnnotation(Path.class);
            if (handler == null) continue;
            String key = handler.key();
            Object obj = null;
            try {
                obj = temp.newInstance();
            }
            catch (Exception e) {
                System.out.println("loadHander:\u521d\u59cb\u5316bean=" + key + "\u5931\u8d25\uff01");
            }
            if (obj == null) continue;
            Method[] methods = temp.getMethods();
            if (methods == null || methods.length == 0) {
                System.out.println("loadHander:\u521d\u59cb\u5316bean=" + key + "\u83b7\u5f97\u65b9\u6cd5\u5217\u8868\u4e3a\u7a7a\uff01");
                continue;
            }
            Bean bean = new Bean();
            bean.setTager(obj);
            Map<String, Method> beanmethods = bean.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Path pathmethod = methods[j].getAnnotation(Path.class);
                if (pathmethod == null) continue;
                String keymethods = pathmethod.key();
                beanmethods.put(keymethods, methods[j]);
            }
            if (beanmethods.size() == 0) {
                System.out.println("loadHander:\u521d\u59cb\u5316bean=" + key + "\u83b7\u5f97\u5e26\u6ce8\u89e3\u7684\u65b9\u6cd5\u5217\u8868\u4e3a\u7a7a\uff01");
                continue;
            }
            map.put(key, bean);
        }
    }

    public void setPort(String port) {
        this.port = port;
    }

    private int getPort() {
        int def_port = 7619;
        if (this.port != null && this.port.trim().length() > 0) {
            def_port = Integer.valueOf(this.port);
        }
        return def_port;
    }

    public UserEvent getUserEvent() {
        return this.userEvent;
    }

    public void setUserEvent(UserEvent userEvent) {
        this.userEvent = userEvent;
    }

    public HandlerBeans getHandlerBeans() {
        return this.handlerBeans;
    }

    public String getHandPackPath() {
        return this.handPackPath;
    }

    public void setHandPackPath(String handPackPath) {
        this.handPackPath = handPackPath;
    }
}

