/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.channelhandler;

import com.cxqm.xiaoerke.modules.StartService;
import com.cxqm.xiaoerke.modules.util.UrlParam;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.Map;

public class HttpHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private StartService startService;
    public static final AttributeKey<Object> channel_parameter = AttributeKey.valueOf((String)"channel_parameter");

    public HttpHandler(StartService startService) {
        this.startService = startService;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        ctx.fireChannelRead((Object)msg.retain());
        String uri = msg.getUri();
        if (uri == null) {
            System.out.println("WebSocket\u8fde\u63a5:\u7528\u6237\u8fde\u63a5webSocket\u670d\u52a1\u5668uri\u4e3anull\uff01");
            ctx.close();
            return;
        }
        if (uri.trim().length() <= 0) {
            System.out.println("WebSocket\u8fde\u63a5:\u7528\u6237\u8fde\u63a5webSocket\u670d\u52a1\u5668uri\u4e3a\u7a7a\u5b57\u7b26\u4e32\uff01");
            ctx.close();
            return;
        }
        Map<String, String> map = null;
        try {
            map = UrlParam.URLRequest(uri);
        }
        catch (Exception e) {
            System.out.println("WebSocket\u8fde\u63a5:\u89e3\u6790\u7528\u6237\u8fde\u63a5\u53c2\u6570\u65f6\u53d1\u751f\u5f02\u5e38\uff01");
            ctx.close();
            return;
        }
        if (map == null || map.size() <= 0) {
            System.out.println("WebSocket\u8fde\u63a5:\u89e3\u6790\u51fa\u6765\u7528\u6237\u53c2\u6570\u4e3a\u7a7a\uff01");
            ctx.close();
            return;
        }
        String uuid = map.get("i");
        if (uuid == null || uuid.trim().length() <= 0) {
            System.out.println("WebSocket\u8fde\u63a5:\u89e3\u6790\u51fa\u6765\u7528\u6237id\u4e3a\u7a7a\uff01");
            ctx.close();
            return;
        }
        HttpHandler.setParam(ctx, uuid);
        if (this.startService.getUserEvent() != null) {
            this.startService.getUserEvent().userConnect(uuid, ctx.channel());
        }
        System.out.println("WebSocket\u8fde\u63a5:\u7528\u6237\u8fde\u63a5\u6210\u529f\uff0cid=" + uuid);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        String uuid = HttpHandler.getParam(ctx);
        if (this.startService.getUserEvent() != null) {
            this.startService.getUserEvent().userDisconnect(uuid, ctx.channel());
        }
        System.out.println("WebSocket\u8fde\u63a5:\u7528\u6237\u65ad\u5f00\u8fde\u63a5\uff0cid=" + uuid);
    }

    public static void setParam(ChannelHandlerContext ctx, String uuid) {
        Attribute parameter = ctx.channel().attr(channel_parameter);
        parameter.setIfAbsent((Object)uuid);
    }

    public static String getParam(ChannelHandlerContext ctx) {
        Attribute cid = ctx.channel().attr(channel_parameter);
        String str = (String)cid.get();
        return str;
    }
}

