/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.boot.loader.tools.InputStreamSupplier;

final class Digest {
    private Digest() {
    }

    static String sha1(InputStreamSupplier supplier) throws IOException {
        String string;
        DigestInputStream inputStream = new DigestInputStream(supplier.openStream(), MessageDigest.getInstance("SHA-1"));
        try {
            byte[] buffer = new byte[4098];
            while (inputStream.read(buffer) != -1) {
            }
            string = Digest.bytesToHex(inputStream.getMessageDigest().digest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException(ex);
            }
        }
        inputStream.close();
        return string;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        for (byte b : bytes) {
            hex.append(String.format("%02x", b));
        }
        return hex.toString();
    }
}

