/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.common.queue;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WisdomQueue {
    private final Logger log = LoggerFactory.getLogger(WisdomQueue.class);
    private LinkedList<Object> elements = new LinkedList();
    private String name = new String("default");
    private int maxItems = 200;

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized void put(Object obj) {
        int size = this.elements.size();
        if (size < this.maxItems) {
            this.elements.addLast(obj);
            this.notifyAll();
        } else {
            this.log.warn("Dropping item from queue: " + this.name);
        }
    }

    public synchronized Object get() {
        while (this.elements.size() <= 0) {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                this.log.error("Wait() got interrupted");
                continue;
            }
            break;
        }
        return this.elements.removeFirst();
    }

    public synchronized Object poll() {
        return this.elements.poll();
    }

    public synchronized void flush() {
        this.elements.clear();
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public synchronized int size() {
        return this.elements.size();
    }
}

