/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.iwcs.common.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ExportExcelsUtil {
    public static HttpServletResponse headerSet(HttpServletResponse response) {
        response.reset();
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("content-disposition", "attachment;filename=details.xls");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Headers", "*");
        return response;
    }

    public static <T> void exportExcel(Collection<T> dataset, OutputStream out) {
        ExportExcelsUtil.exportExcel(0, 0, 0, "sheet1", null, dataset, out, "yyyy-MM-dd");
    }

    public static <T> void exportExcel(String[] headers, Collection<T> dataset, OutputStream out) {
        ExportExcelsUtil.exportExcel(0, 0, 0, "sheet1", headers, dataset, out, "yyyy-MM-dd");
    }

    public static <T> void exportExcel(List<String> headers, List<String> columns, List<T> dataset, OutputStream out) {
        ExportExcelsUtil.exportExcel(headers, columns, dataset, out, "yyyy-MM-dd");
    }

    public static <T> void exportExcel(String[] headers, Collection<T> dataset, OutputStream out, String pattern) {
        ExportExcelsUtil.exportExcel(0, 0, 0, "sheet1", headers, dataset, out, pattern);
    }

    public static <T> void exportExcel(List<String> headers, List<String> columns, List<T> dataset, OutputStream out, String pattern) {
        ExportExcelsUtil.exportExcel(0, 0, 0, "sheet1", headers, columns, dataset, out, pattern);
    }

    public static <T> void exportExcel(int colSplit, int rowSplit, int dataBeginIndex, String sheetName, String[] headers, Collection<T> dataset, OutputStream out) {
        ExportExcelsUtil.exportExcel(colSplit, rowSplit, dataBeginIndex, sheetName, headers, dataset, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void exportExcel(int colSplit, int rowSplit, int dataBeginIndex, String title, String[] headers, Collection<T> dataset, OutputStream out, String pattern) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        String sheetName = title == null || title.equals("") ? "sheet1" : title;
        HSSFSheet sheet = workbook.createSheet(sheetName);
        try {
            if (colSplit != 0 || rowSplit != 0) {
                sheet.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
            }
            sheet.setDefaultColumnWidth(15);
            HSSFCellStyle style = workbook.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            style.setBorderTop(BorderStyle.THIN);
            style.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)12);
            font.setBold(true);
            style.setFont(font);
            style.setWrapText(true);
            HSSFCellStyle style2 = workbook.createCellStyle();
            style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style2.setBorderBottom(BorderStyle.THIN);
            style2.setBorderLeft(BorderStyle.THIN);
            style2.setBorderRight(BorderStyle.THIN);
            style2.setBorderTop(BorderStyle.THIN);
            style2.setAlignment(HorizontalAlignment.CENTER);
            style2.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont font2 = workbook.createFont();
            font2.setBold(false);
            style2.setFont(font2);
            style2.setWrapText(true);
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            HSSFRow row = sheet.createRow(0);
            for (int i = 0; i < headers.length; ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(style);
                HSSFRichTextString text = new HSSFRichTextString(headers[i]);
                cell.setCellValue((RichTextString)text);
            }
            Iterator<T> it = dataset.iterator();
            int index = 0;
            while (it.hasNext()) {
                Object object;
                row = sheet.createRow(++index);
                T t = it.next();
                if (t instanceof ListOrderedMap || t instanceof HashMap) {
                    ListOrderedMap map = (ListOrderedMap)t;
                    Iterator keys = map.keySet().iterator();
                    int i = 0;
                    while (keys.hasNext()) {
                        HSSFCell cell = row.createCell(i);
                        cell.setCellStyle(style2);
                        String keyname = (String)keys.next();
                        Object keyValue = map.get((Object)keyname);
                        String textValue = null;
                        if (keyValue instanceof byte[]) {
                            row.setHeightInPoints(300.0f);
                            sheet.setColumnWidth(i, 7140);
                            byte[] bsValue = (byte[])keyValue;
                            HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 255, (short)i, index, (short)(i + 1), index + 1);
                            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                            HSSFPicture hSSFPicture = patriarch.createPicture(anchor, workbook.addPicture(bsValue, 5));
                        } else {
                            if (keyValue == null) {
                                keyValue = "";
                            }
                            textValue = keyValue.toString();
                        }
                        if (textValue != null) {
                            HSSFRichTextString richString = new HSSFRichTextString(textValue);
                            HSSFFont font3 = workbook.createFont();
                            richString.applyFont((Font)font3);
                            cell.setCellValue((RichTextString)richString);
                        }
                        ++i;
                    }
                    continue;
                }
                if (t instanceof Object[]) {
                    object = (Object[])t;
                    HSSFFont font3 = workbook.createFont();
                    for (int len = dataBeginIndex; len < ((Object)object).length; ++len) {
                        String textValue = "";
                        if (object[len] != null) {
                            textValue = object[len].toString();
                        }
                        HSSFCell cell = row.createCell(len - dataBeginIndex);
                        cell.setCellStyle(style2);
                        HSSFRichTextString richString = new HSSFRichTextString(textValue);
                        richString.applyFont((Font)font3);
                        cell.setCellValue((RichTextString)richString);
                    }
                    continue;
                }
                if (t instanceof List) {
                    object = (List)t;
                    HSSFFont font3 = workbook.createFont();
                    int size = object.size();
                    for (int len = dataBeginIndex; len < size; ++len) {
                        String textValue = "";
                        if (object.get(len) != null) {
                            textValue = object.get(len).toString();
                        }
                        HSSFCell cell = row.createCell(len - dataBeginIndex);
                        cell.setCellStyle(style2);
                        HSSFRichTextString richString = new HSSFRichTextString(textValue);
                        richString.applyFont((Font)font3);
                        cell.setCellValue((RichTextString)richString);
                    }
                    continue;
                }
                Field[] fields = t.getClass().getDeclaredFields();
                for (short i = 0; i < fields.length; i = (short)((short)(i + 1))) {
                    HSSFCell cell = row.createCell((int)i);
                    cell.setCellStyle(style2);
                    Field field = fields[i];
                    String fieldName = field.getName();
                    String getMethodName = field.getType() == Boolean.TYPE ? fieldName : "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value instanceof byte[]) {
                        row.setHeightInPoints(600.0f);
                        sheet.setColumnWidth((int)i, 14280);
                        byte[] bsValue = (byte[])value;
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 600, i, index, (short)(i + 1), index + 1);
                        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                        HSSFPicture pic = patriarch.createPicture(anchor, workbook.addPicture(bsValue, 5));
                        pic.resize();
                    } else {
                        if (value == null) {
                            value = "";
                        }
                        textValue = value.toString();
                    }
                    if (textValue == null) continue;
                    HSSFRichTextString richString = new HSSFRichTextString(textValue);
                    HSSFFont font3 = workbook.createFont();
                    richString.applyFont((Font)font3);
                    cell.setCellValue((RichTextString)richString);
                }
            }
            workbook.write(out);
            out.flush();
            out.close();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void exportExcel(int colSplit, int rowSplit, int dataBeginIndex, String title, List<String> headers, List<String> columns, List<T> dataList, OutputStream out, String pattern) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        String sheetName = title == null || title.equals("") ? "sheet1" : title;
        HSSFSheet sheet = workbook.createSheet(sheetName);
        try {
            if (colSplit != 0 || rowSplit != 0) {
                sheet.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
            }
            sheet.setDefaultColumnWidth(15);
            HSSFCellStyle style = workbook.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            style.setBorderTop(BorderStyle.THIN);
            style.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)12);
            font.setBold(true);
            style.setFont(font);
            style.setWrapText(true);
            HSSFCellStyle style2 = workbook.createCellStyle();
            style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style2.setBorderBottom(BorderStyle.THIN);
            style2.setBorderLeft(BorderStyle.THIN);
            style2.setBorderRight(BorderStyle.THIN);
            style2.setBorderTop(BorderStyle.THIN);
            style2.setAlignment(HorizontalAlignment.CENTER);
            style2.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont font2 = workbook.createFont();
            font2.setBold(false);
            style2.setFont(font2);
            style2.setWrapText(true);
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            HSSFRow row = sheet.createRow(0);
            for (int i = 0; i < headers.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(style);
                HSSFRichTextString text = new HSSFRichTextString(headers.get(i));
                cell.setCellValue((RichTextString)text);
            }
            for (int index = 0; index < dataList.size(); ++index) {
                T t = dataList.get(index);
                row = sheet.createRow(index + 1);
                short columnIdx = 0;
                for (String column : columns) {
                    short s = columnIdx;
                    columnIdx = (short)(columnIdx + 1);
                    HSSFCell cell = row.createCell((int)s);
                    cell.setCellStyle(style2);
                    Field field = t.getClass().getDeclaredField(column);
                    String fieldName = field.getName();
                    String getMethodName = field.getType() == Boolean.TYPE ? fieldName : "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value instanceof byte[]) {
                        row.setHeightInPoints(600.0f);
                        sheet.setColumnWidth((int)columnIdx, 14280);
                        byte[] bsValue = (byte[])value;
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 600, columnIdx, index, (short)(columnIdx + 1), index + 1);
                        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                        HSSFPicture pic = patriarch.createPicture(anchor, workbook.addPicture(bsValue, 5));
                        pic.resize();
                    } else {
                        if (value == null) {
                            value = "";
                        }
                        textValue = value.toString();
                    }
                    if (textValue == null) continue;
                    HSSFRichTextString richString = new HSSFRichTextString(textValue);
                    HSSFFont font3 = workbook.createFont();
                    richString.applyFont((Font)font3);
                    cell.setCellValue((RichTextString)richString);
                }
            }
            workbook.write(out);
            out.flush();
            out.close();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static HSSFCellStyle getHSSFCellDefaultStyle(HSSFWorkbook workbook) {
        HSSFCellStyle defaultStyle = workbook.createCellStyle();
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontHeightInPoints((short)9);
        defaultFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        defaultStyle.setFont(defaultFont);
        defaultStyle.setWrapText(true);
        return defaultStyle;
    }

    public static HSSFCellStyle getHSSFCellTitleStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont fontTitle = workbook.createFont();
        fontTitle.setFontHeightInPoints((short)18);
        fontTitle.setFontName("\u6977\u4f53");
        fontTitle.setBold(true);
        titleStyle.setFont(fontTitle);
        titleStyle.setWrapText(true);
        return titleStyle;
    }

    public static HSSFCellStyle getTableTitleStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)9);
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setBold(true);
        style.setFont(font);
        style.setWrapText(true);
        return style;
    }

    public static HSSFCellStyle getTableColumnStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font2 = workbook.createFont();
        font2.setBold(false);
        style2.setFont(font2);
        style2.setWrapText(true);
        return style2;
    }

    public static HSSFCellStyle getTableTotalStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font2 = workbook.createFont();
        font2.setBold(false);
        style2.setFont(font2);
        style2.setWrapText(true);
        return style2;
    }
}

