/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.iwcs.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileOperateUtil {
    private static final String REALNAME = "realName";
    private static final String STORENAME = "storeName";
    private static final String SIZE = "size";
    private static final String SUFFIX = "suffix";
    private static final String CONTENTTYPE = "contentType";
    private static final String CREATETIME = "createTime";
    private static final String UPLOADDIR = "uploadDir/";

    private static String rename(String name) {
        Long now = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        Long random = (long)(Math.random() * (double)now.longValue());
        String fileName = now + "" + random;
        if (name.indexOf(".") != -1) {
            fileName = fileName + name.substring(name.lastIndexOf("."));
        }
        return fileName;
    }

    public static String reGenerateNameForStore(String name) {
        return FileOperateUtil.rename(name);
    }

    private static String zipName(String name) {
        String prefix = "";
        prefix = name.indexOf(".") != -1 ? name.substring(0, name.lastIndexOf(".")) : name;
        return prefix + ".zip";
    }

    public static void download(HttpServletRequest request, HttpServletResponse response, String realName, String contentType, String storeName, String folder) throws Exception {
        int bytesRead;
        response.setContentType("text/html;charset=UTF-8");
        request.setCharacterEncoding("UTF-8");
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        String ctxPath = request.getSession().getServletContext().getRealPath("/") + folder;
        String downLoadPath = ctxPath + storeName;
        long fileLength = new File(downLoadPath).length();
        response.setContentType(contentType);
        response.setHeader("Content-disposition", "attachment; filename=" + new String(realName.getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
        response.setHeader("Content-Length", String.valueOf(fileLength));
        bis = new BufferedInputStream(new FileInputStream(downLoadPath));
        bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
        byte[] buff = new byte[2048];
        while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
            bos.write(buff, 0, bytesRead);
        }
        bis.close();
        bos.close();
    }
}

