/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.iwcs.common.utils.idUtils;

public class SnowflakeIdUtil {
    private static SnowflakeIdUtil snowflakeIdUtil;
    private final long twepoch = 1514736000000L;
    private final long workerIdBits = 0L;
    private final long datacenterIdBits = 0L;
    private final long maxWorkerId = 0L;
    private final long maxDatacenterId = 0L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long datacenterIdShift = 12L;
    private final long timestampLeftShift = 12L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    private SnowflakeIdUtil() {
    }

    public static synchronized SnowflakeIdUtil newInstance() {
        if (snowflakeIdUtil == null) {
            snowflakeIdUtil = new SnowflakeIdUtil();
        }
        return snowflakeIdUtil;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1514736000000L << 12 | this.datacenterId << 12 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

