/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.iwcs.common.utils.modubus;

import com.serotonin.modbus4j.BatchRead;
import com.serotonin.modbus4j.BatchResults;
import com.serotonin.modbus4j.ModbusFactory;
import com.serotonin.modbus4j.ModbusMaster;
import com.serotonin.modbus4j.exception.ErrorResponseException;
import com.serotonin.modbus4j.exception.ModbusInitException;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.ip.IpParameters;
import com.serotonin.modbus4j.locator.BaseLocator;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.msg.WriteRegisterRequest;
import com.serotonin.modbus4j.msg.WriteRegisterResponse;

public class Modbus4jUtils {
    static ModbusFactory modbusFactory;
    public static ModbusMaster globMaster;

    public static ModbusMaster getMaster(String ip, int port) throws ModbusInitException {
        ModbusMaster master = null;
        try {
            IpParameters params = new IpParameters();
            params.setHost(ip);
            params.setPort(port);
            master = modbusFactory.createTcpMaster(params, true);
            master.init();
            globMaster = master;
        }
        catch (Exception e) {
            System.out.println("master\u521d\u59cb\u5316\u5f02\u5e38");
        }
        return master;
    }

    public static Boolean readCoilStatus(int slaveId, int offset, String ip, int port) throws ModbusTransportException, ErrorResponseException, ModbusInitException {
        BaseLocator loc = BaseLocator.coilStatus((int)slaveId, (int)offset);
        Boolean value = (Boolean)Modbus4jUtils.getMaster(ip, port).getValue(loc);
        return value;
    }

    public static Boolean readInputStatus(int slaveId, int offset, String ip, int port) throws ModbusTransportException, ErrorResponseException, ModbusInitException {
        BaseLocator loc = BaseLocator.inputStatus((int)slaveId, (int)offset);
        Boolean value = (Boolean)Modbus4jUtils.getMaster(ip, port).getValue(loc);
        return value;
    }

    public static Number readHoldingRegister(int slaveId, int offset, int dataType, String ip, int port) throws ModbusTransportException, ErrorResponseException, ModbusInitException {
        BaseLocator loc = BaseLocator.holdingRegister((int)slaveId, (int)offset, (int)dataType);
        Number value = globMaster != null ? (Number)((Number)globMaster.getValue(loc)) : (Number)((Number)Modbus4jUtils.getMaster(ip, port).getValue(loc));
        return value;
    }

    public static Number readInputRegisters(int slaveId, int offset, int dataType, String ip, int port) throws ModbusTransportException, ErrorResponseException, ModbusInitException {
        BaseLocator loc = BaseLocator.inputRegister((int)slaveId, (int)offset, (int)dataType);
        Number value = (Number)Modbus4jUtils.getMaster(ip, port).getValue(loc);
        return value;
    }

    public static void batchRead(String ip, int port) throws ModbusTransportException, ErrorResponseException, ModbusInitException {
        BatchRead batch = new BatchRead();
        for (int i = 0; i <= 3; ++i) {
            batch.addLocator((Object)i, BaseLocator.holdingRegister((int)1, (int)i, (int)3));
        }
        ModbusMaster master = Modbus4jUtils.getMaster(ip, port);
        batch.setContiguousRequests(false);
        BatchResults results = master.send(batch);
        System.out.println(results.getValue((Object)0));
        System.out.println(results.getValue((Object)1));
    }

    public static void main(String[] args) {
        try {
            Number v031 = Modbus4jUtils.readHoldingRegister(1, 1, 3, "172.16.215.133", 502);
            System.out.println("v031:" + v031);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean writeRegister(int slaveId, int writeOffset, short writeValue, String ip, int port) throws ModbusTransportException, ModbusInitException {
        WriteRegisterRequest request;
        WriteRegisterResponse response;
        if (globMaster == null) {
            globMaster = Modbus4jUtils.getMaster(ip, port);
        }
        return !(response = (WriteRegisterResponse)globMaster.send((ModbusRequest)(request = new WriteRegisterRequest(slaveId, writeOffset, (int)writeValue)))).isException();
    }

    static {
        if (modbusFactory == null) {
            modbusFactory = new ModbusFactory();
        }
    }
}

