/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.iwcs.common.utils.modubus;

import com.serotonin.modbus4j.ModbusFactory;
import com.serotonin.modbus4j.ModbusMaster;
import com.serotonin.modbus4j.exception.ErrorResponseException;
import com.serotonin.modbus4j.exception.ModbusInitException;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.ip.IpParameters;
import com.serotonin.modbus4j.locator.BaseLocator;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.msg.ModbusResponse;
import com.serotonin.modbus4j.msg.WriteCoilRequest;
import com.serotonin.modbus4j.msg.WriteCoilResponse;
import com.serotonin.modbus4j.msg.WriteCoilsRequest;
import com.serotonin.modbus4j.msg.WriteCoilsResponse;
import com.serotonin.modbus4j.msg.WriteRegistersRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Modbus4jWriteUtils {
    static Log log = LogFactory.getLog(Modbus4jWriteUtils.class);
    static ModbusFactory modbusFactory;
    public static ModbusMaster globMaster;

    public static ModbusMaster getMaster(String ip, int port) throws ModbusInitException {
        ModbusMaster tcpMaster = null;
        try {
            IpParameters params = new IpParameters();
            params.setHost(ip);
            params.setPort(port);
            tcpMaster = modbusFactory.createTcpMaster(params, true);
            tcpMaster.init();
            globMaster = tcpMaster;
        }
        catch (ModbusInitException e) {
            System.out.println("master\u521d\u59cb\u5316\u5f02\u5e38");
        }
        return tcpMaster;
    }

    public static boolean writeCoil(int slaveId, int writeOffset, boolean writeValue, String ip, int port) throws ModbusTransportException, ModbusInitException {
        WriteCoilRequest request;
        ModbusMaster tcpMaster = Modbus4jWriteUtils.getMaster(ip, port);
        WriteCoilResponse response = (WriteCoilResponse)tcpMaster.send((ModbusRequest)(request = new WriteCoilRequest(slaveId, writeOffset, writeValue)));
        return !response.isException();
    }

    public static boolean writeCoils(int slaveId, int startOffset, boolean[] bdata, String ip, int port) throws ModbusTransportException, ModbusInitException {
        WriteCoilsRequest request;
        ModbusMaster tcpMaster = Modbus4jWriteUtils.getMaster(ip, port);
        WriteCoilsResponse response = (WriteCoilsResponse)tcpMaster.send((ModbusRequest)(request = new WriteCoilsRequest(slaveId, startOffset, bdata)));
        return !response.isException();
    }

    public static boolean writeRegisters(int slaveId, int startOffset, short[] sdata, String ip, int port) throws ModbusTransportException, ModbusInitException {
        WriteRegistersRequest request;
        ModbusMaster tcpMaster = Modbus4jWriteUtils.getMaster(ip, port);
        ModbusResponse response = tcpMaster.send((ModbusRequest)(request = new WriteRegistersRequest(slaveId, startOffset, sdata)));
        if (response.isException()) {
            log.error((Object)response.getExceptionMessage());
            return false;
        }
        return true;
    }

    public static void writeHoldingRegister(int slaveId, int offset, Number value, int dataType, String ip, int port) throws ModbusTransportException, ErrorResponseException, ModbusInitException {
        ModbusMaster tcpMaster = Modbus4jWriteUtils.getMaster(ip, port);
        BaseLocator locator = BaseLocator.holdingRegister((int)slaveId, (int)offset, (int)dataType);
        tcpMaster.setValue(locator, (Object)value);
    }

    public static void main(String[] args) {
    }

    static {
        if (modbusFactory == null) {
            modbusFactory = new ModbusFactory();
        }
    }
}

