/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.iwcs.common.utils.plcUtils;

public class CRCUtils {
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int POLYNOMIAL = 40961;
    private static final int PRESET_VALUE = 65535;
    static byte[] crc16_tab_h = new byte[]{0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64};
    static byte[] crc16_tab_l = new byte[]{0, -64, -63, 1, -61, 3, 2, -62, -58, 6, 7, -57, 5, -59, -60, 4, -52, 12, 13, -51, 15, -49, -50, 14, 10, -54, -53, 11, -55, 9, 8, -56, -40, 24, 25, -39, 27, -37, -38, 26, 30, -34, -33, 31, -35, 29, 28, -36, 20, -44, -43, 21, -41, 23, 22, -42, -46, 18, 19, -45, 17, -47, -48, 16, -16, 48, 49, -15, 51, -13, -14, 50, 54, -10, -9, 55, -11, 53, 52, -12, 60, -4, -3, 61, -1, 63, 62, -2, -6, 58, 59, -5, 57, -7, -8, 56, 40, -24, -23, 41, -21, 43, 42, -22, -18, 46, 47, -17, 45, -19, -20, 44, -28, 36, 37, -27, 39, -25, -26, 38, 34, -30, -29, 35, -31, 33, 32, -32, -96, 96, 97, -95, 99, -93, -94, 98, 102, -90, -89, 103, -91, 101, 100, -92, 108, -84, -83, 109, -81, 111, 110, -82, -86, 106, 107, -85, 105, -87, -88, 104, 120, -72, -71, 121, -69, 123, 122, -70, -66, 126, 127, -65, 125, -67, -68, 124, -76, 116, 117, -75, 119, -73, -74, 118, 114, -78, -77, 115, -79, 113, 112, -80, 80, -112, -111, 81, -109, 83, 82, -110, -106, 86, 87, -105, 85, -107, -108, 84, -100, 92, 93, -99, 95, -97, -98, 94, 90, -102, -101, 91, -103, 89, 88, -104, -120, 72, 73, -119, 75, -117, -118, 74, 78, -114, -113, 79, -115, 77, 76, -116, 68, -124, -123, 69, -121, 71, 70, -122, -126, 66, 67, -125, 65, -127, -128, 64};

    public static void main(String[] args) {
        String str16jinzhi = "3E0300500001";
        byte[] str16jinzhiTobyte = CRCUtils.hexStringToBytes(str16jinzhi);
        System.out.println(CRCUtils.Make_CRC(str16jinzhiTobyte));
    }

    public static String Make_CRC(byte[] data) {
        byte[] buf = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            buf[i] = data[i];
        }
        int len = buf.length;
        int crc = 65535;
        for (int pos = 0; pos < len; ++pos) {
            crc = buf[pos] < 0 ? (crc ^= buf[pos] + 256) : (crc ^= buf[pos]);
            for (int i = 8; i != 0; --i) {
                if ((crc & 1) != 0) {
                    crc >>= 1;
                    crc ^= 0xA001;
                    continue;
                }
                crc >>= 1;
            }
        }
        String c = Integer.toHexString(crc);
        if (c.length() == 4) {
            c = c.substring(2, 4) + c.substring(0, 2);
        } else if (c.length() == 3) {
            c = "0" + c;
            c = c.substring(2, 4) + c.substring(0, 2);
        } else if (c.length() == 2) {
            c = "0" + c.substring(1, 2) + "0" + c.substring(0, 1);
        }
        return c;
    }

    public static String getHexString(int i) {
        String hexString = String.format("%04x", i);
        return hexString;
    }

    public static String getCrc16String(byte[] data) {
        StringBuilder builder = new StringBuilder();
        String hex = CRCUtils.getHexString(CRCUtils.getCrc16(data));
        builder.append(hex.substring(2));
        builder.append(hex.substring(0, 2));
        return builder.toString();
    }

    public static String getCrc16String(String data) {
        StringBuilder builder = new StringBuilder();
        String hex = CRCUtils.getHexString(CRCUtils.getCrc16(data));
        builder.append(hex.substring(2));
        builder.append(hex.substring(0, 2));
        return builder.toString();
    }

    public static int getCrc16(byte[] data) {
        System.out.println("\nCRC 16 calculation progress:\n");
        int current_crc_value = 65535;
        for (int i = 0; i < data.length; ++i) {
            current_crc_value ^= data[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((current_crc_value & 1) != 0) {
                    current_crc_value = current_crc_value >>> 1 ^ 0xA001;
                    continue;
                }
                current_crc_value >>>= 1;
            }
        }
        return current_crc_value & 0xFFFF;
    }

    public static int getCrc16(String str) {
        byte[] data = CRCUtils.hexStringToBytes(str);
        System.out.println("\nCRC 16 calculation progress:\n");
        int current_crc_value = 65535;
        for (int i = 0; i < data.length; ++i) {
            current_crc_value ^= data[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((current_crc_value & 1) != 0) {
                    current_crc_value = current_crc_value >>> 1 ^ 0xA001;
                    continue;
                }
                current_crc_value >>>= 1;
            }
        }
        return current_crc_value & 0xFFFF;
    }

    public static String printHexString(byte[] b) {
        StringBuffer returnValue = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            if (i % 2 == 0) {
                returnValue.append(hex.toUpperCase() + "");
                continue;
            }
            returnValue.append(hex.toUpperCase() + " ");
        }
        return returnValue.toString();
    }

    public static String bytesToHexFun1(byte[] bytes) {
        char[] buf = new char[bytes.length * 2];
        int a = 0;
        int index = 0;
        for (int n : bytes) {
            a = n < 0 ? 256 + n : n;
            buf[index++] = HEX_CHAR[a / 16];
            buf[index++] = HEX_CHAR[a % 16];
        }
        return new String(buf);
    }

    public static String bytesToHexFun2(byte[] bytes) {
        char[] buf = new char[bytes.length * 2];
        int index = 0;
        for (byte b : bytes) {
            buf[index++] = HEX_CHAR[b >>> 4 & 0xF];
            buf[index++] = HEX_CHAR[b & 0xF];
        }
        return new String(buf);
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String bytes2HexString(byte[] b) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            result.append(hex.toUpperCase());
        }
        return result.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.replaceAll(" ", "");
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(CRCUtils.charToByte(hexChars[pos]) << 4 | CRCUtils.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static int calcCrc16(byte[] data) {
        return CRCUtils.calcCrc16(data, 0, data.length);
    }

    public static int calcCrc16(byte[] data, int offset, int len) {
        return CRCUtils.calcCrc16(data, offset, len, 65535);
    }

    public static int calcCrc16(byte[] data, int offset, int len, int preval) {
        int ucCRCHi = (preval & 0xFF00) >> 8;
        int ucCRCLo = preval & 0xFF;
        for (int i = 0; i < len; ++i) {
            int iIndex = (ucCRCLo ^ data[offset + i]) & 0xFF;
            ucCRCLo = ucCRCHi ^ crc16_tab_h[iIndex];
            ucCRCHi = crc16_tab_l[iIndex];
        }
        return (ucCRCHi & 0xFF) << 8 | ucCRCLo & 0xFF & 0xFFFF;
    }
}

