/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.http.util;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.http.Exchange;
import org.springblade.core.http.FormBuilder;
import org.springblade.core.http.HttpRequest;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static String get(String url, Map<String, Object> queries) {
        return HttpUtil.get(url, null, queries);
    }

    public static String get(String url, Map<String, String> header, Map<String, Object> queries) {
        HttpRequest httpRequest = HttpRequest.get(url);
        if (header != null && header.keySet().size() > 0) {
            header.forEach(httpRequest::addHeader);
        }
        httpRequest.queryMap(queries);
        return httpRequest.execute().asString();
    }

    public static String post(String url, Map<String, Object> params) {
        return HttpUtil.exchange(url, null, params).asString();
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> params) {
        return HttpUtil.exchange(url, header, params).asString();
    }

    public static String postJson(String url, String json) {
        return HttpUtil.exchange(url, null, json).asString();
    }

    public static String postJson(String url, Map<String, String> header, String json) {
        return HttpUtil.exchange(url, header, json).asString();
    }

    public static Exchange exchange(String url, Map<String, String> header, Map<String, Object> params) {
        HttpRequest httpRequest = HttpRequest.post(url);
        if (header != null && header.keySet().size() > 0) {
            header.forEach(httpRequest::addHeader);
        }
        FormBuilder formBuilder = httpRequest.formBuilder();
        if (params != null && params.keySet().size() > 0) {
            params.forEach(formBuilder::add);
        }
        return formBuilder.execute();
    }

    public static Exchange exchange(String url, Map<String, String> header, String content) {
        HttpRequest httpRequest = HttpRequest.post(url);
        if (header != null && header.keySet().size() > 0) {
            header.forEach(httpRequest::addHeader);
        }
        return httpRequest.bodyString(content).execute();
    }
}

